/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation;

import android.animation.TimeInterpolator;
import android.content.res.Resources;
import android.graphics.PointF;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.unionyy.mobile.meipai.gift.animation.BaseAnimation;
import com.unionyy.mobile.meipai.gift.animation.FrameAnimator;
import com.unionyy.mobile.meipai.gift.animation.SinPathUpdateListener;
import com.unionyy.mobile.meipai.gift.animation.evaluator.MathSinEvaluator;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.ImageTarget;
import java.util.Random;

public class SinPathAnimation
extends BaseAnimation {
    private int mASinaValue = 40;
    private int initPraiseAValue = 15;
    private int initAValueRange = 6;
    private Random random = new Random();
    private Interpolator dce = new DecelerateInterpolator();

    public SinPathAnimation(ImageTarget target, int startX, int startY, float endY, float scaleRatio, Resources resources, long duration) {
        this.initPraiseAValue = (int)TypedValue.applyDimension((int)1, (float)this.initPraiseAValue, (DisplayMetrics)resources.getDisplayMetrics());
        this.initAValueRange = (int)TypedValue.applyDimension((int)1, (float)this.initAValueRange, (DisplayMetrics)resources.getDisplayMetrics());
        this.mASinaValue = (int)TypedValue.applyDimension((int)1, (float)this.mASinaValue, (DisplayMetrics)resources.getDisplayMetrics());
        int imgWidth = target.getWidth();
        int initAValue = this.getQuXianInitAValue();
        int maxASinValue = this.getQuXianMaxAValue(initAValue, imgWidth);
        MathSinEvaluator evaluator = new MathSinEvaluator(startX, initAValue - imgWidth / 2, maxASinValue, startY, this.random.nextBoolean(), this.getPathWvalue());
        float endYValue = endY;
        this.mFrameAnimator = FrameAnimator.ofObject(evaluator, new PointF(0.0f, 0.0f), new PointF(0.0f, endYValue));
        this.mFrameAnimator.addUpdateListener(new SinPathUpdateListener(target, this.getIntAlphaValue(), scaleRatio));
        this.mFrameAnimator.setInterpolator((TimeInterpolator)this.dce);
        this.mFrameAnimator.setDuration(duration);
    }

    public int getQuXianInitAValue() {
        return this.initPraiseAValue + this.random.nextInt(this.initAValueRange + 1);
    }

    public int getQuXianMaxAValue(int initAValue, int imgWidth) {
        int tmpAValue = this.mASinaValue - imgWidth / 2 - initAValue + 1;
        return initAValue + this.random.nextInt(tmpAValue <= 0 ? 1 : tmpAValue);
    }

    private float getPathWvalue() {
        return 0.001f + (float)this.random.nextInt(61) / 10000.0f;
    }

    public float getIntAlphaValue() {
        return 1.0f;
    }
}

