/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.danmaku.basic;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.util.Log;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.danmaku.BarrageEntity;
import com.unionyy.mobile.meipai.danmaku.basic.BarrageDispatcher;
import com.unionyy.mobile.meipai.danmaku.basic.BarrageLog;
import com.unionyy.mobile.meipai.danmaku.basic.BarrageParser;
import com.unionyy.mobile.meipai.danmaku.basic.BarrageViewCacheStuffer;
import com.unionyy.mobile.meipai.danmaku.basic.BaseBarrage;
import com.unionyy.mobile.meipai.danmaku.basic.TextUtil;
import com.unionyy.mobile.meipai.personalcard.MeipaiPersonalCardBuilder;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import java.util.HashMap;
import master.flame.danmaku.controller.DrawHandler;
import master.flame.danmaku.controller.IDanmakuView;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.DanmakuTimer;
import master.flame.danmaku.danmaku.model.IDanmakus;
import master.flame.danmaku.danmaku.model.android.BaseCacheStuffer;
import master.flame.danmaku.danmaku.model.android.DanmakuContext;
import master.flame.danmaku.danmaku.model.android.DanmakuFactory;
import master.flame.danmaku.ui.widget.DanmakuView;

public class BarrageView
extends DanmakuView {
    private static final String TAG = "BarrageView";
    private boolean isAttachedToWindow = false;
    private FragmentManager mFragmentManager;
    private long barrageOwnerId = 0L;

    public BarrageView(Context context) {
        super(context);
    }

    public BarrageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setBarrageOwnerId(long barrageOwnerId) {
        this.barrageOwnerId = barrageOwnerId;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Log.d((String)TAG, (String)"barrageLog: onAttachedToWindow() called");
        BarrageDispatcher.getInstance().cancelAll();
        BarrageDispatcher.getInstance().setTarget(this);
        BarrageDispatcher.getInstance().startLoop();
        this.isAttachedToWindow = true;
        this.startBarrage();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Log.d((String)TAG, (String)"barrageLog: onDetachedFromWindow() called");
        BarrageDispatcher.getInstance().cancelAll();
        BarrageDispatcher.getInstance().setTarget(null);
        this.isAttachedToWindow = false;
        this.release();
    }

    public boolean isAttachedToWindow() {
        return this.isAttachedToWindow;
    }

    public void startBarrage() {
        BarrageView iDanmakuView = this;
        iDanmakuView.setCallback(new DrawHandler.Callback(){

            public void prepared() {
                BarrageView.this.start();
            }

            public void updateTimer(DanmakuTimer timer) {
            }

            public void danmakuShown(BaseDanmaku danmaku) {
            }

            public void drawingFinished() {
                BarrageView.this.setVisibility(8);
            }
        });
        iDanmakuView.setOnDanmakuClickListener(new IDanmakuView.OnDanmakuClickListener(){

            public boolean onDanmakuClick(IDanmakus danmakus) {
                BarrageLog.commonBarrageLog(BarrageView.TAG, "onDanmakuClick() called with: danmakus = [" + danmakus + "]");
                BaseDanmaku latest = danmakus.last();
                if (null != latest) {
                    BarrageLog.commonBarrageLog(BarrageView.TAG, "onDanmakuClick() called with: : text of latest danmaku:" + latest.text);
                    if (latest.tag instanceof BarrageEntity) {
                        BarrageView.this.performBarrageClickEvent(((BarrageEntity)latest.tag).senderId);
                        return true;
                    }
                    BarrageLog.commonBarrageLog(BarrageView.TAG, "onDanmakuClick() called with: : latest.tag:" + latest.tag);
                }
                return false;
            }

            public boolean onDanmakuLongClick(IDanmakus danmakus) {
                BaseDanmaku latest = danmakus.last();
                if (null != latest) {
                    BarrageLog.commonBarrageLog(BarrageView.TAG, "onDanmakuLongClick() called with: : text of latest danmaku:" + latest.text);
                    if (latest.tag instanceof BarrageEntity) {
                        BarrageView.this.performBarrageClickEvent(((BarrageEntity)latest.tag).senderId);
                        return true;
                    }
                    BarrageLog.commonBarrageLog(BarrageView.TAG, "onDanmakuLongClick() called with: : latest.tag:" + latest.tag);
                }
                return true;
            }

            public boolean onViewClick(IDanmakuView view) {
                Log.d((String)BarrageView.TAG, (String)("onViewClick() called with: view = [" + view + "]"));
                return false;
            }
        });
        BarrageParser danmakuParser = new BarrageParser();
        DanmakuContext danmakuContext = DanmakuContext.create();
        HashMap<Integer, Integer> maxLinesPair = new HashMap<Integer, Integer>();
        maxLinesPair.put(1, 1);
        HashMap<Integer, Boolean> overlappingEnablePair = new HashMap<Integer, Boolean>();
        overlappingEnablePair.put(1, false);
        danmakuContext.setDanmakuStyle(2, new float[]{3.0f}).setDuplicateMergingEnabled(false).setScrollSpeedFactor(1.0f).setScaleTextSize(1.2f).setCacheStuffer((BaseCacheStuffer)new BarrageViewCacheStuffer(this.getContext()), null).setMaximumLines(maxLinesPair).preventOverlapping(overlappingEnablePair);
        iDanmakuView.prepare(danmakuParser, danmakuContext);
        iDanmakuView.showFPS(false);
        iDanmakuView.enableDanmakuDrawingCache(true);
    }

    public boolean isIgnoreBarrage(long barrageOwnerId) {
        return this.barrageOwnerId != barrageOwnerId;
    }

    public void addBarrage(final BarrageEntity barrageEntity) {
        if (!this.isAttachedToWindow || barrageEntity == null) {
            MLog.info((Object)TAG, (String)("isAttachedToWindow =" + this.isAttachedToWindow), (Object[])new Object[0]);
            return;
        }
        BarrageDispatcher.getInstance().startLoop();
        if (this.getVisibility() != 0) {
            this.setVisibility(0);
        }
        final BaseDanmaku baseDanmaku = this.getConfig().mDanmakuFactory.createDanmaku(1);
        DanmakuFactory cfr_ignored_0 = this.getConfig().mDanmakuFactory;
        this.getConfig().mDanmakuFactory.MAX_DANMAKU_DURATION = 9000L;
        if (baseDanmaku == null) {
            MLog.info((Object)TAG, (String)"baseDanmaku == null", (Object[])new Object[0]);
            return;
        }
        barrageEntity.senderNickname = TextUtil.handleText(barrageEntity.senderNickname, 20);
        barrageEntity.sendContent = TextUtil.handleText(barrageEntity.sendContent, 40);
        final RequestOptions options = new RequestOptions().placeholder(R.drawable.default_portrait).error(R.drawable.default_portrait).circleCrop();
        Glide.with((Context)this.getContext()).asBitmap().load(StringUtils.isEmpty((String)barrageEntity.senderAvatar) != false ? Integer.valueOf(R.drawable.default_portrait) : barrageEntity.senderAvatar).apply(options).into((Target)new SimpleTarget<Bitmap>(){

            public void onResourceReady(@Nullable Bitmap resource, Transition<? super Bitmap> transition) {
                barrageEntity.avatarBitmap = resource;
                BarrageView.this.addToQueue(baseDanmaku, barrageEntity);
            }

            public void onLoadFailed(Drawable errorDrawable) {
                Glide.with((Context)BarrageView.this.getContext()).asBitmap().load(Integer.valueOf(R.drawable.default_portrait)).apply(options).into((Target)new SimpleTarget<Bitmap>(){

                    public void onResourceReady(@Nullable Bitmap resource, Transition<? super Bitmap> transition) {
                        BarrageLog.commonBarrageLog(BarrageView.TAG, "avatar onLoadFailed: onResourceReady");
                        barrageEntity.avatarBitmap = resource;
                        BarrageView.this.addToQueue(baseDanmaku, barrageEntity);
                    }

                    public void onLoadFailed(@Nullable Drawable errorDrawable) {
                        Bitmap resource = null;
                        if (errorDrawable instanceof BitmapDrawable) {
                            BarrageLog.commonBarrageLog(BarrageView.TAG, "avatar onLoadFailed: errorDrawable != null");
                            resource = ((BitmapDrawable)errorDrawable).getBitmap();
                        } else {
                            BarrageLog.commonBarrageLog(BarrageView.TAG, "avatar onLoadFailed: errorDrawable == null");
                        }
                        barrageEntity.avatarBitmap = resource;
                        BarrageView.this.addToQueue(baseDanmaku, barrageEntity);
                    }
                });
            }
        });
    }

    private void addToQueue(BaseDanmaku baseDanmaku, BarrageEntity barrageEntity) {
        BaseBarrage baseBarrage = new BaseBarrage(baseDanmaku);
        baseBarrage.setTag(barrageEntity);
        baseBarrage.setTime(this.getCurrentTime());
        BarrageLog.commonBarrageLog(TAG, "barrageLog addBarrage() called with: baseBarrage = [" + baseBarrage + "]");
        BarrageDispatcher.getInstance().addBarrage(baseBarrage);
    }

    private void performBarrageClickEvent(long userId) {
        BarrageLog.commonBarrageLog(TAG, "performBarrageClickEvent() called with: userId = [" + userId + "]");
        new MeipaiPersonalCardBuilder(userId).fromWhereArea(MeipaiPersonalCardBuilder.FromWhereArea.CHAT_USER).withChildFragmentManager(this.mFragmentManager).show();
    }

    public void clear() {
        this.removeAllDanmakus(true);
        BarrageDispatcher.getInstance().cancelAll();
    }

    public void release() {
        super.release();
        BarrageDispatcher.getInstance().quit();
    }

    public void setFragmentManager(FragmentManager fragmentManager) {
        this.mFragmentManager = fragmentManager;
    }
}

