/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.preview.utils;

import android.os.Environment;
import android.text.TextUtils;
import com.unionyy.mobile.meipai.preview.core.IStickerFilterCore;
import com.unionyy.mobile.meipai.preview.core.LevelOfEffect;
import com.unionyy.mobile.meipai.preview.utils.AIFileDownloadHelper;
import com.yy.mobile.http.ProgressInfo;
import com.yy.mobile.http.ProgressListener;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.util.FileUtil;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0004J6\u0010\n\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/unionyy/mobile/meipai/preview/utils/AIFileDownloadHelper;", "", "()V", "STICKER_DIR", "", "TAG", "downloadAndUnzipFile", "", "url", "path", "downloadStickerFile", "id", "", "responseListener", "Lcom/yy/mobile/http/ResponseListener;", "responseErrorListener", "Lcom/yy/mobile/http/ResponseErrorListener;", "progressListener", "Lcom/yy/mobile/http/ProgressListener;", "isReadyDownload", "", "meipai_release"})
public final class AIFileDownloadHelper {
    private static final String TAG = "AIFileDownloadHelper";
    @NotNull
    public static final String STICKER_DIR = "stickers";
    public static final AIFileDownloadHelper INSTANCE;

    public final void downloadAndUnzipFile(@Nullable String url, @Nullable String path) {
        MLog.info((Object)TAG, (String)("downloadAndUnzipFile. url = " + url + ", path = " + path), (Object[])new Object[0]);
        if (TextUtils.isEmpty((CharSequence)url) || TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        String realFilePath = path + File.separator + "table.zip";
        RequestManager requestManager = RequestManager.instance();
        String string2 = url;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        requestManager.submitDownloadRequest(string2, realFilePath, (ResponseListener)new ResponseListener<String>(realFilePath, path){
            final /* synthetic */ String $realFilePath;
            final /* synthetic */ String $path;

            public final void onResponse(String it) {
                try {
                    FileUtil.unzip((String)this.$realFilePath, (String)this.$path, (String)"");
                    new File(this.$realFilePath).delete();
                    MLog.info((Object)"AIFileDownloadHelper", (String)"downloadAndUnzipFile. download and unzip success", (Object[])new Object[0]);
                }
                catch (IOException e) {
                    MLog.error((Object)"AIFileDownloadHelper", (String)("downloadAndUnzipFile. Unzip file error : " + e + " ,realFilePath = " + this.$realFilePath), (Object[])new Object[0]);
                }
            }
            {
                this.$realFilePath = string2;
                this.$path = string3;
            }
        }, (ResponseErrorListener)downloadAndUnzipFile.2.INSTANCE, (ProgressListener)downloadAndUnzipFile.3.INSTANCE, false, false);
    }

    public final boolean isReadyDownload(int id2) {
        StringBuilder stringBuilder = new StringBuilder();
        File file = Environment.getExternalStorageDirectory();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Environment.getExternalStorageDirectory()");
        String STICKER_PATH = stringBuilder.append(file.getAbsolutePath()).append(File.separator).append("mpyy").append(File.separator).append(STICKER_DIR).append(File.separator).append(id2).toString();
        File file2 = new File(STICKER_PATH);
        return file2.exists();
    }

    public final void downloadStickerFile(@Nullable String url, int id2, @NotNull ResponseListener<String> responseListener, @NotNull ResponseErrorListener responseErrorListener, @NotNull ProgressListener progressListener) {
        File stickerPath;
        Intrinsics.checkParameterIsNotNull(responseListener, (String)"responseListener");
        Intrinsics.checkParameterIsNotNull((Object)responseErrorListener, (String)"responseErrorListener");
        Intrinsics.checkParameterIsNotNull((Object)progressListener, (String)"progressListener");
        MLog.info((Object)TAG, (String)("-- downloadStickerFile url = " + url + ", id = " + id2), (Object[])new Object[0]);
        if (url == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        File file = Environment.getExternalStorageDirectory();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Environment.getExternalStorageDirectory()");
        String rootDir = stringBuilder.append(file.getAbsolutePath()).append(File.separator).append("mpyy").append(File.separator).toString();
        String STICKER_PATH = rootDir + STICKER_DIR + File.separator;
        File rootFile = new File(rootDir);
        if (!rootFile.exists()) {
            rootFile.mkdir();
        }
        if (!(stickerPath = new File(rootFile.getAbsolutePath() + File.separator + STICKER_DIR)).exists()) {
            stickerPath.mkdir();
        }
        String string2 = url;
        int n = StringsKt.lastIndexOf$default((CharSequence)url, (String)"/", (int)0, (boolean)false, (int)6, null) + 1;
        int n2 = url.length();
        StringBuilder stringBuilder2 = new StringBuilder().append(stickerPath.getAbsolutePath()).append(File.separator);
        boolean bl = false;
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string4 = string3;
        String filePath = stringBuilder2.append(string4).toString();
        File file2 = new File(filePath);
        if (file2.exists()) {
            file2.delete();
        }
        if (this.isReadyDownload(id2)) {
            String unZipPath = STICKER_PATH + id2;
            responseListener.onResponse((Object)String.valueOf(id2));
            ((IStickerFilterCore)ICoreManagerBase.getCore(IStickerFilterCore.class)).cleanEffect(LevelOfEffect.LOW);
            ((IStickerFilterCore)ICoreManagerBase.getCore(IStickerFilterCore.class)).setEffectByLevel(unZipPath, LevelOfEffect.LOW);
        } else {
            RequestManager.instance().submitDownloadRequest(url, filePath, (ResponseListener)new ResponseListener<String>(filePath, STICKER_PATH, id2, responseListener){
                final /* synthetic */ String $filePath;
                final /* synthetic */ String $STICKER_PATH;
                final /* synthetic */ int $id;
                final /* synthetic */ ResponseListener $responseListener;

                public final void onResponse(String it) {
                    File zipFile = new File(this.$filePath);
                    String unZipPath = this.$STICKER_PATH + this.$id;
                    try {
                        MLog.info((Object)"AIFileDownloadHelper", (String)("-- downloadStickerFile download complete id = " + this.$id), (Object[])new Object[0]);
                        FileUtil.unzip((File)zipFile, (String)unZipPath, (String)"");
                        MLog.info((Object)"AIFileDownloadHelper", (String)("-- downloadStickerFile unZipPath = " + unZipPath + ", id = " + this.$id), (Object[])new Object[0]);
                        this.$responseListener.onResponse((Object)String.valueOf(this.$id));
                        ((IStickerFilterCore)ICoreManagerBase.getCore(IStickerFilterCore.class)).cleanEffect(LevelOfEffect.LOW);
                        ((IStickerFilterCore)ICoreManagerBase.getCore(IStickerFilterCore.class)).setEffectByLevel(unZipPath, LevelOfEffect.LOW);
                    }
                    catch (IOException e) {
                        MLog.error((Object)"AIFileDownloadHelper", (String)("-- downloadStickerFile unzip error msg: " + e), (Object[])new Object[0]);
                        try {
                            FileUtil.delete((String)unZipPath);
                        }
                        catch (Exception e2) {
                            MLog.error((Object)"AIFileDownloadHelper", (String)("-- downloadStickerFile delete file error msg: " + e2), (Object[])new Object[0]);
                        }
                    }
                }
                {
                    this.$filePath = string2;
                    this.$STICKER_PATH = string3;
                    this.$id = n;
                    this.$responseListener = responseListener;
                }
            }, new ResponseErrorListener(id2, responseErrorListener){
                final /* synthetic */ int $id;
                final /* synthetic */ ResponseErrorListener $responseErrorListener;

                public final void onErrorResponse(RequestError it) {
                    MLog.error((Object)"AIFileDownloadHelper", (String)("-- downloadStickerFile error = " + it.getMessage() + ", id = " + this.$id), (Object[])new Object[0]);
                    this.$responseErrorListener.onErrorResponse(it);
                }
                {
                    this.$id = n;
                    this.$responseErrorListener = responseErrorListener;
                }
            }, new ProgressListener(id2, progressListener){
                final /* synthetic */ int $id;
                final /* synthetic */ ProgressListener $progressListener;

                public final void onProgress(ProgressInfo it) {
                    StringBuilder stringBuilder = new StringBuilder().append("-- downloadStickerFile progress = ");
                    ProgressInfo progressInfo = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)progressInfo, (String)"it");
                    MLog.info((Object)"AIFileDownloadHelper", (String)stringBuilder.append((double)progressInfo.getProgress() / (double)it.getTotal()).append(", id = ").append(this.$id).toString(), (Object[])new Object[0]);
                    this.$progressListener.onProgress(it);
                }
                {
                    this.$id = n;
                    this.$progressListener = progressListener;
                }
            }, false, true);
        }
    }

    private AIFileDownloadHelper() {
    }

    static {
        AIFileDownloadHelper aIFileDownloadHelper;
        INSTANCE = aIFileDownloadHelper = new AIFileDownloadHelper();
    }
}

