/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.ui.viewdelegate;

import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.dialog.MeipaiOkCancelDialog;
import com.unionyy.mobile.meipai.pk.event.EventQueryStopPkCount;
import com.unionyy.mobile.meipai.pk.event.EventStopPkRsp;
import com.unionyy.mobile.meipai.pk.ui.model.PkStatusInfo;
import com.unionyy.mobile.meipai.pk.ui.viewdelegate.BaseViewUpdateDelegate;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.mobile.ui.utils.dialog.OkCancelDialogListener;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.log.MLog;

public class PkCloseViewDelegate
extends BaseViewUpdateDelegate {
    private static final String TAG = "PkCloseViewDelegate";
    private View closeView;
    private MeipaiOkCancelDialog mMeipaiOkCancelDialog;
    private boolean isReq;

    public PkCloseViewDelegate(View rootView, FragmentActivity activity, int videoMarginTop) {
        super(rootView, activity, videoMarginTop);
        this.closeView = rootView.findViewById(R.id.close_pk);
        this.closeView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MLog.info((Object)PkCloseViewDelegate.TAG, (String)("[PK][\u70b9\u51fb\u5173\u95ed\u6309\u94ae]isReq:" + PkCloseViewDelegate.this.isReq), (Object[])new Object[0]);
                if (!PkCloseViewDelegate.this.isReq) {
                    PkCloseViewDelegate.this.core.reqQueryStopPkCount();
                    PkCloseViewDelegate.this.isReq = true;
                }
            }
        });
    }

    @Override
    public void onInit() {
        super.onInit();
        this.setPkCloseTopMargin(this.getVideoMarginTop() + ScreenUtil.getInstance().dip2px(6));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        PkStatusInfo info = this.core.getPkStatusInfo();
        if (info.type == 5 || info.type == 6) {
            this.closeView.setVisibility(0);
        } else {
            this.closeView.setVisibility(8);
            this.dismissDialog();
        }
    }

    @Override
    public void onStateChanged(int lastState, int curState) {
        super.onStateChanged(lastState, curState);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.onClosePk();
    }

    @Override
    public void onClosePk() {
        super.onClosePk();
        this.dismissDialog();
        this.closeView.setVisibility(8);
    }

    private void setPkCloseTopMargin(int topMargin) {
        if (null != this.closeView) {
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.closeView.getLayoutParams();
            layoutParams.topMargin = topMargin;
            this.closeView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    private void onFindPKstopPkRsp(boolean canClose, String message) {
        this.dismissDialog();
        if (canClose) {
            this.mMeipaiOkCancelDialog = MeipaiOkCancelDialog.Companion.create("\u786e\u5b9a\u7ed3\u675f\u5f53\u524dPK\u5417\uff1f", message, "\u786e\u5b9a", "\u53d6\u6d88", new OkCancelDialogListener(){

                public void onCancel() {
                }

                public void onOk() {
                    if (!PkCloseViewDelegate.this.isReq) {
                        PkCloseViewDelegate.this.isReq = true;
                        PkCloseViewDelegate.this.core.reqStopPk();
                    }
                }
            });
            this.mMeipaiOkCancelDialog.show(this.mActivity.getSupportFragmentManager(), "PK_CLOSE");
        } else {
            this.showTips("\u60a8\u4eca\u65e5\u63d0\u524d\u7ed3\u675fPK\u6b21\u6570\u5df2\u7528\u5b8c");
        }
    }

    private void dismissDialog() {
        if (this.mActivity != null && this.mMeipaiOkCancelDialog != null) {
            try {
                this.mMeipaiOkCancelDialog.dismissAllowingStateLoss();
                this.mMeipaiOkCancelDialog = null;
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
    }

    @BusEvent
    public void onEventStopPkRsp(EventStopPkRsp event) {
        this.isReq = false;
        if (event.getResult() != 0) {
            this.showTips(event.getMessage());
        }
    }

    @BusEvent
    public void onEventQueryStopPkCount(EventQueryStopPkCount event) {
        this.isReq = false;
        if (event.getResult() != 0) {
            this.showTips(event.getMessage());
        } else {
            PkStatusInfo info = this.core.getPkStatusInfo();
            String message = "\u5bf9\u6218\u65f6\u95f4\u63d0\u524d\u7ed3\u675fPK\u89c6\u4e3a\u6295\u964d\uff0c\u5e76\u4f1a\u5173\u95ed\u8fde\u9ea6\uff08\u6bcf\u65e5\u6700\u591a\u53ef\u63d0\u524d\u7ed3\u675f" + event.getTotalTimes() + "\u6b21\uff09";
            this.onFindPKstopPkRsp(event.getLeftTimes() > 0, message);
        }
    }
}

