/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.ui.viewdelegate;

import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.pk.event.EventStartPKOverCountdown;
import com.unionyy.mobile.meipai.pk.ui.model.PkStatusInfo;
import com.unionyy.mobile.meipai.pk.ui.view.PKCountDownOverTimerView;
import com.unionyy.mobile.meipai.pk.ui.viewdelegate.BaseViewUpdateDelegate;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.log.MLog;

public class PKCountDownOverTimerDelegate
extends BaseViewUpdateDelegate {
    private static final String TAG = "PKCountDownOverTimerDelegate";
    private PKCountDownOverTimerView mOverCountDownTimer;
    private boolean isPlayed;

    public PKCountDownOverTimerDelegate(View rootView, FragmentActivity activity, int videoMarginTop) {
        super(rootView, activity, videoMarginTop);
        this.mOverCountDownTimer = (PKCountDownOverTimerView)rootView.findViewById(R.id.live_pk_over_count_down_view);
        this.mOverCountDownTimer.setCountDownTimerListener(new PKCountDownOverTimerView.CountDownTimerListener(){

            @Override
            public void onFinish() {
                PKCountDownOverTimerDelegate.this.mOverCountDownTimer.setVisibility(8);
            }
        });
    }

    @Override
    public void onInit() {
        super.onInit();
        this.setOverCountdownTopMargin(this.getVideoMarginTop() + this.getVideoHeight() - ScreenUtil.getInstance().dip2px(46));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        PkStatusInfo info = this.core.getPkStatusInfo();
        if (info.type == 5 && info.leftTime <= 10) {
            this.playAnimation(info.leftTime * 1000);
        } else {
            this.isPlayed = false;
        }
    }

    @BusEvent(sync=true)
    public void onEventStartPKOverCountdown(EventStartPKOverCountdown event) {
        PkStatusInfo info = this.core.getPkStatusInfo();
        MLog.info((Object)TAG, (String)("[PK][\u5bf9\u6218\u526910s\u5012\u8ba1\u65f6]" + info), (Object[])new Object[0]);
        if (info.type == 5) {
            this.playAnimation(10000);
        }
    }

    @Override
    public void onStateChanged(int lastState, int curState) {
        super.onStateChanged(lastState, curState);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.onClosePk();
    }

    @Override
    public void onClosePk() {
        super.onClosePk();
        if (null != this.mOverCountDownTimer) {
            this.mOverCountDownTimer.clearAnimation();
            this.mOverCountDownTimer.setVisibility(8);
        }
    }

    private void overCountDown(int length) {
        this.mOverCountDownTimer.setVisibility(0);
        this.mOverCountDownTimer.start(length, 10L);
    }

    private void setOverCountdownTopMargin(int overTimeCountdownTopMargin) {
        if (overTimeCountdownTopMargin > 0) {
            FrameLayout.LayoutParams overCountdownLayoutParams = (FrameLayout.LayoutParams)this.mOverCountDownTimer.getLayoutParams();
            if (overTimeCountdownTopMargin > 0) {
                overCountdownLayoutParams.topMargin = overTimeCountdownTopMargin;
                this.mOverCountDownTimer.setLayoutParams((ViewGroup.LayoutParams)overCountdownLayoutParams);
            }
        }
    }

    private void playAnimation(int length) {
        if (!this.isPlayed) {
            this.isPlayed = true;
            this.overCountDown(length);
        }
    }
}

