/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.presenter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.pk.event.EventPKFightingOver;
import com.unionyy.mobile.meipai.pk.presenter.MeiPaiPkBasePresenter;
import com.unionyy.mobile.meipai.pk.ui.IPkComponentHost;
import com.unionyy.mobile.meipai.pk.ui.IPkComponentView;
import com.unionyy.mobile.meipai.pk.ui.model.PkStatusInfo;
import com.unionyy.mobile.meipai.pk.utils.PkArManager;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.pluginstartlive.SceneBehave;
import com.yy.mobile.pluginstartlive.lianmai.core.ILianmaiCore;
import com.yymobile.core.ICoreManagerBase;

public class MeiPaiPkHostPresenter
extends MeiPaiPkBasePresenter {
    private boolean isLianMai;
    private boolean isPlayAr;
    private boolean isOpenPk;

    public MeiPaiPkHostPresenter(@NonNull IPkComponentView pkComponentView) {
        super(pkComponentView);
    }

    @Override
    protected void onPkStatusUpdate() {
        PkStatusInfo info = this.core.getPkStatusInfo();
        if (info.type == 4 || info.type == 5 || info.type == 6) {
            if (this.isPkGameTime(info)) {
                this.onHostPkStart(info);
            }
            if (info.type == 6) {
                this.mHandler.removeCallbacksAndMessages(null);
                if (info.endResult == 2) {
                    if (!this.isPlayAr) {
                        this.isPlayAr = true;
                        PkArManager.getInstence().playPkArEffect(info.loseArUrl, info.leftTime);
                    }
                } else if (info.endResult == 1 && !this.isPlayAr) {
                    this.isPlayAr = true;
                    PkArManager.getInstence().playPkArEffect(info.winArUrl, info.leftTime);
                }
            } else {
                this.isPlayAr = false;
                PkArManager.getInstence().clearPkArEffect();
            }
        }
    }

    @Override
    protected void onEventCountDownFinished(PkStatusInfo info) {
        if (info.type == 4) {
            this.onHostPkStart(info);
        }
        super.onEventCountDownFinished(info);
    }

    @Override
    protected void onClosePk() {
        this.mHandler.removeCallbacksAndMessages(null);
        PkStatusInfo info = this.core.getPkStatusInfo();
        if (this.lastType == 5 || this.lastType == 6 || this.lastType == 4) {
            if (info.isAheadStopInPk() || info.isAheadStopInResult()) {
                if (info.endResult == 1) {
                    PkArManager.getInstence().playPkArEffect(info.winArUrl, 30);
                } else if (info.endResult == 2) {
                    PkArManager.getInstence().playPkArEffect(info.loseArUrl, 30);
                }
            } else {
                PkArManager.getInstence().clearPkArEffect();
                this.isPlayAr = false;
            }
        }
        if (this.isLianMai) {
            ((ILianmaiCore)ICoreManagerBase.getCore(ILianmaiCore.class)).stopCross();
            this.isLianMai = false;
        }
        if (this.isOpenPk) {
            this.isOpenPk = false;
            this.mPkComponentView.setPkVideoBg(null);
            ((IPkComponentHost)this.mPkComponentView).changeAnchorLiveSceneBehave(SceneBehave.NORMAL);
        }
        super.onClosePk();
    }

    @BusEvent
    public void onPKFightingOver(EventPKFightingOver event) {
        if (this.core.getPkStatusInfo().type == 5) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (MeiPaiPkHostPresenter.this.core.getPkStatusInfo().type == 5) {
                        MeiPaiPkHostPresenter.this.core.reqPkLoad();
                    }
                }
            }, 1000L);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (MeiPaiPkHostPresenter.this.core.getPkStatusInfo().type == 5 && MeiPaiPkHostPresenter.this.mPkComponentView != null) {
                        MeiPaiPkHostPresenter.this.mPkComponentView.showTips("\u7531\u4e8e\u60a8\u7684\u7f51\u7edc\u5f02\u5e38,\u672c\u5c40PK\u7ed3\u679c\u65e0\u6cd5\u83b7\u53d6");
                    }
                }
            }, 5000L);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    MeiPaiPkHostPresenter.this.onClosePk();
                }
            }, (long)(this.core.getPkStatusInfo().punishmentTime * 1000));
        }
    }

    private void onHostPkStart(PkStatusInfo info) {
        if (!this.isOpenPk) {
            this.isOpenPk = true;
            ((IPkComponentHost)this.mPkComponentView).changeAnchorLiveSceneBehave(SceneBehave.LIANMAI);
            View bgView = LayoutInflater.from((Context)BasicConfig.getInstance().getAppContext()).inflate(R.layout.meipai_pk_video_bg, null);
            if (info.needChangeColor) {
                bgView.setBackgroundResource(R.drawable.meipai_background_blue_red_normal);
            }
            this.mPkComponentView.setPkVideoBg(bgView);
        }
        if (info.rstatus == 1) {
            if (!this.isLianMai) {
                ((ILianmaiCore)ICoreManagerBase.getCore(ILianmaiCore.class)).startCross(info.rightUid, info.rtopcid, info.rsubcid);
                this.isLianMai = true;
            }
        } else if (this.isLianMai) {
            ((ILianmaiCore)ICoreManagerBase.getCore(ILianmaiCore.class)).stopCross();
            this.isLianMai = false;
        }
    }
}

