/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.basemedia.watchlive.template;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.MutableLiveData;
import android.content.Context;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.duowan.mobile.basemedia.watchlive.template.AbstractComponentContainer;
import com.duowan.mobile.basemedia.watchlive.template.ChannelBaseParam;
import com.duowan.mobile.basemedia.watchlive.template.IChannelBaseParam;
import com.duowan.mobile.basemedia.watchlive.template.IScene;
import com.duowan.mobile.basemedia.watchlive.template.IViewScene;
import com.duowan.mobile.basemedia.watchlive.template.Scene;
import com.duowan.mobile.basemedia.watchlive.template.adapter.IContainerAdapter;

public class SceneFacade {
    private static ArrayMap<Context, LiveData<IScene>> sceneHolder;

    public static void setActivityScene(Context context, String bussinessId) {
        SceneFacade.setActivityScene(context, SceneFacade.findScene(bussinessId));
    }

    public static void setActivityScene(Context context, IScene scene) {
        MutableLiveData data = (MutableLiveData)sceneHolder.get((Object)context);
        if (data == null) {
            data = new MutableLiveData();
            sceneHolder.put((Object)context, (Object)data);
        }
        data.setValue((Object)scene);
    }

    public static IScene getActivityScene(Context context) {
        if (sceneHolder.get((Object)context) == null) {
            return null;
        }
        return (IScene)((LiveData)sceneHolder.get((Object)context)).getValue();
    }

    public static LiveData<IScene> watchSceneChange(Context context) {
        return (LiveData)sceneHolder.get((Object)context);
    }

    public static Class<? extends AbstractComponentContainer> getRootClz(String sceneName, ChannelBaseParam param) {
        return SceneFacade.findScene(sceneName).getRootContainerClz(param);
    }

    public static IViewScene<IChannelBaseParam> findScene(String sceneName) {
        Scene ret;
        if (TextUtils.isEmpty((CharSequence)sceneName)) {
            ret = Scene.GENERAL;
        } else {
            sceneName = sceneName.toUpperCase();
            try {
                ret = Scene.valueOf(sceneName);
            }
            catch (IllegalArgumentException e) {
                ret = Scene.GENERAL;
            }
        }
        return ret;
    }

    public static String getPluginId(String sceneName) {
        return SceneFacade.findScene(sceneName).getPluginId();
    }

    public static boolean checkTemplatePluginActived(String sceneName) {
        return SceneFacade.findScene(sceneName).checkTemplatePluginActived();
    }

    public static IContainerAdapter getTemplateHandler(String sceneName) {
        return SceneFacade.findScene(sceneName).createTemplateHandler();
    }

    public static String getTemplateAlias(String sceneName) {
        return SceneFacade.findScene(sceneName).getAlias();
    }
}

