/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.basemedia.watchlive.template.generate;

import android.content.Context;
import android.os.Bundle;
import com.duowan.mobile.basemedia.watchlive.template.AbstractComponentContainer;
import com.duowan.mobile.basemedia.watchlive.template.generate.BranchContainerConfig;
import com.duowan.mobile.basemedia.watchlive.template.generate.ComponentWrapper;
import com.duowan.mobile.basemedia.watchlive.template.generate.ComponentsFactory;
import com.duowan.mobile.basemedia.watchlive.template.generate.TrunkContainerConfig;
import com.duowan.mobile.entlive.domain.ContainerConfig;
import com.yy.mobile.ui.basicchanneltemplate.component.IComponent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class ComponentsMaker {
    private final Set<ComponentsFactory> mFactorys = new CopyOnWriteArraySet<ComponentsFactory>();
    private final ConcurrentHashMap<Class<? extends IComponent>, ComponentWrapper> mComponents = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<? extends ContainerConfig>, List<Class<? extends IComponent>>> mContainerConfig = new ConcurrentHashMap();
    public Context context;

    public ComponentsMaker(ComponentsFactory factory) {
        this.mFactorys.add(factory);
    }

    public <T extends IComponent> T of(Class<T> clz) {
        return this.wrapper(clz).instance(null);
    }

    public <T extends IComponent> T of(Class<T> clz, Bundle bundle) {
        return this.wrapper(clz).instance(bundle);
    }

    public List<Class<? extends IComponent>> configOf(Class<? extends ContainerConfig> config) {
        List<Class<? extends IComponent>> list = this.mContainerConfig.get(config);
        if (list == null) {
            list = this.componentClasses(config);
            this.mContainerConfig.put(config, list);
        }
        return list;
    }

    public <T extends IComponent> ComponentWrapper<T> wrapper(Class<T> clz) {
        ComponentWrapper<T> componentWrapper = this.mComponents.get(clz);
        if (componentWrapper == null) {
            componentWrapper = this.create(clz);
            if (componentWrapper == null) {
                throw new RuntimeException("Component is not used properly, type:" + clz.getSimpleName());
            }
            this.mComponents.put(clz, componentWrapper);
        }
        return componentWrapper;
    }

    public void addComponentInto(Class<? extends AbstractComponentContainer> containerClz, Class<? extends IComponent> componentClz, int resId) {
        for (ComponentsFactory factory : this.mFactorys) {
            if (!factory.addPluginComponentInto(containerClz, componentClz, resId, null)) continue;
            return;
        }
    }

    public void addComponentInto(Class<? extends AbstractComponentContainer> containerClz, Class<? extends IComponent> componentClz, int resId, Bundle bundle) {
        for (ComponentsFactory factory : this.mFactorys) {
            if (!factory.addPluginComponentInto(containerClz, componentClz, resId, bundle)) continue;
            return;
        }
    }

    public TrunkContainerConfig getConfig(Class<? extends AbstractComponentContainer> containerClz) {
        TrunkContainerConfig baseConfig = this.getBaseConfig(containerClz);
        TrunkContainerConfig ret = this.getExtendConfig(baseConfig);
        return ret;
    }

    public TrunkContainerConfig getBaseConfig(Class<? extends AbstractComponentContainer> containerClz) {
        for (ComponentsFactory factory : this.mFactorys) {
            try {
                TrunkContainerConfig baseConfig = (TrunkContainerConfig)factory.getConfig(containerClz);
                if (baseConfig == null) continue;
                return baseConfig;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private TrunkContainerConfig getExtendConfig(TrunkContainerConfig baseConfig) {
        if (baseConfig == null) {
            return null;
        }
        TrunkContainerConfig config = null;
        for (ComponentsFactory factory : this.mFactorys) {
            try {
                config = (TrunkContainerConfig)factory.getExtendConfig(baseConfig);
                if (config == null) continue;
                baseConfig = config;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        return baseConfig;
    }

    private <T extends IComponent> ComponentWrapper<T> create(Class<T> clz) {
        for (ComponentsFactory factory : this.mFactorys) {
            ComponentWrapper<T> ret = factory.create(clz);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private List<Class<? extends IComponent>> componentClasses(Class<? extends ContainerConfig> config) {
        HashSet<Class<? extends IComponent>> set = new HashSet<Class<? extends IComponent>>();
        for (ComponentsFactory factory : this.mFactorys) {
            List<Class<? extends IComponent>> found = factory.componentClasses(config);
            if (found == null) continue;
            set.addAll(found);
        }
        return new ArrayList<Class<? extends IComponent>>(set);
    }

    public void addFactory(ComponentsFactory factory) {
        this.mFactorys.add(factory);
        for (Map.Entry<Class<? extends TrunkContainerConfig>, Class<? extends BranchContainerConfig>> entry : factory.mConfigExtendMap.entrySet()) {
            this.mContainerConfig.remove(entry.getKey());
        }
    }

    public void removeFactory(ComponentsFactory factory) {
        this.mFactorys.remove(factory);
        for (Map.Entry<Class<? extends TrunkContainerConfig>, Class<? extends BranchContainerConfig>> entry : factory.mConfigExtendMap.entrySet()) {
            this.mContainerConfig.remove(entry.getKey());
        }
    }
}

