/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.ipcapi.internal;

import android.util.Log;
import com.unionyy.ipcapi.HermesService;
import com.unionyy.ipcapi.internal.Reply;
import com.unionyy.ipcapi.sender.Sender;
import com.unionyy.ipcapi.sender.SenderDesignator;
import com.unionyy.ipcapi.util.HermesException;
import com.unionyy.ipcapi.wrapper.ObjectWrapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class HermesInvocationHandler
implements InvocationHandler {
    private static final String TAG = "HERMES_INVOCATION";
    private Sender mSender;

    public HermesInvocationHandler(Class<? extends HermesService> service, ObjectWrapper object) {
        this.mSender = SenderDesignator.getPostOffice(service, 3, object);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] objects) {
        try {
            Reply reply = this.mSender.send(method, objects);
            if (reply == null) {
                return null;
            }
            if (reply.success()) {
                return reply.getResult();
            }
            Log.e((String)TAG, (String)("Error occurs. Error " + reply.getErrorCode() + ": " + reply.getMessage()));
            return null;
        }
        catch (HermesException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)("Error occurs. Error " + e.getErrorCode() + ": " + e.getErrorMessage()));
            return null;
        }
    }
}

