﻿//
// Created by HUTAO on 2017/6/28.
//

#ifndef YYPROTO_PROTOPACKETPOOL_H
#define YYPROTO_PROTOPACKETPOOL_H

#include "commondefine.h"
#include "mutex.h"
#include "IProtoPacket.h"

NAMESPACE_BASEMOD_BEGIN
	class ProtoPacketPool
	{
	public:
		ProtoPacketPool();
		ProtoPacketPool(int limit);
		~ProtoPacketPool();
	
	public:
		IProtoPacket*	newPacket(int uri, const Marshallable& req);
		IProtoPacket*	newPacket(const char *data, int len, int connId);
		IProtoPacket*	newPacket(int uri, const char *data, int len);
		IProtoPacket*   newPacket(int uri, const char *data, int len, int connId);
		void			freePacket(IProtoPacket* proto);
	private:
		IProtoPacket* _newPacket(const char *data, int len, int connId);
	private:
		MutexLock*	mMutex;
		std::deque<IProtoPacket*>	mPackets;
		std::set<IProtoPacket*>		mLargePackets; //not reused.
		int			mLimit;
	};
NAMESPACE_BASEMOD_END
#endif //YYPROTO_PROTOPACKETPOOL_H
