﻿//
// Created by HUTAO on 2017/7/27.
//

#ifndef NETDEMO_ITASKTHREAD_H
#define NETDEMO_ITASKTHREAD_H

#include "commondefine.h"
NAMESPACE_BASEMOD_BEGIN
	class IProtoTask
	{
	public:
		enum Priority {
			HIGH_PRIORITY=0,
			NORMAL_PRIORITY=1,
			LOW_PRIORITY=2,
			EXIT_PRIORITY = 3,
			START_PRIORITY = 4,
			
			SPECIAL_TASK1 = 10,
		};
	public:
		virtual ~IProtoTask(){}
		virtual void run() = 0;
		virtual void	setRepeat(bool repeat) = 0;
		virtual bool	getRepeat() = 0;
		virtual Priority        getPriority()  { return  m_priority; }
	
	protected:
		Priority  m_priority;
		bool      m_bRepeat;
	};
	
	class ITaskThread
	{
	public:
		virtual ~ITaskThread(){}
		virtual void	post(IProtoTask* task) = 0;
		virtual void	post(IProtoTask* task, uint32_t delay) = 0;
		virtual void	remove(IProtoTask* task) = 0;
		virtual	void	stop() = 0;
		virtual	void	clear() = 0;
		virtual void	start() = 0;
	};
NAMESPACE_BASEMOD_END
#endif //NETDEMO_ITASKTHREAD_H
