﻿//
// Created by HUTAO on 2017/6/28.
//

#ifndef YYPROTO_IPROTOPACKET_H
#define YYPROTO_IPROTOPACKET_H

#include "commondefine.h"
#include "packet.h"

#define		MAX_PACKET_POOL_SIZE	50
#define		PACKET_SIZE	512
#define		MAX_PACKET_SIZE			4*1024*1024

#define	    PACKET_HEAD_SIZE   10

NAMESPACE_BASEMOD_BEGIN
	enum PktErrorNo
	{
		PKT_LEN_WRONG = 1,//长度无效
		PKT_LEN_BIG = 2,//长度过大
		PKT_URI_INVALID = 3,//URI无效
		PKT_UNPACK_ERR = 4,//解包错误
	};
	class IProtoPacket
	{
	public:
				
		virtual ~IProtoPacket(){}
		virtual int			getConnId() = 0;
		virtual uint32_t	getUri() = 0;
		virtual int			getLength() = 0;
		virtual int			getRes() = 0;
		virtual char*		getData() = 0;
		virtual bool 		unpack(Marshallable& obj) = 0;
		virtual IProtoPacket*	clone() = 0;

		virtual bool getIsValid() = 0;
	};
NAMESPACE_BASEMOD_END
#endif //YYPROTO_IPROTOPACKET_H
