package com.yy.platform.baseservice.task;

import android.os.Bundle;
import android.os.Handler;

import com.yy.platform.baseservice.IRPCChannel;
import com.yy.platform.baseservice.marshal.NumberUtils;
import com.yy.platform.baseservice.marshal.ProtoPacket;

import java.nio.ByteBuffer;
import java.util.Map;

public class BindTask extends AbstractTask<BindTask.ResponseParam> {

    private RequestParam mSrvReq;

    public static final long URI = 11;

    public BindTask(int reqId, BindTask.RequestParam requestParam,
                    IRPCChannel.RPCCallback<BindTask.ResponseParam> callback,
                    Bundle options, Handler scheduler) {
        super(URI, reqId, callback, options, scheduler);
        mSrvReq = requestParam;
    }

    public BindTask(int reqId, BindTask.RequestParam requestParam,
                    IRPCChannel.RPCCallbackRespHeaders<BindTask.ResponseParam> callback,
                    Bundle options, Handler scheduler) {
        setUri(NumberUtils.longToUint32ForCpp(URI));

        mRequestId = reqId;
        mOptions = new TaskOptions.TaskOption(options);
        mCallback = new CallbackRespHeaders(callback);
        mScheduler = scheduler;
        // super(URI, reqId, new CallbackRespHeaders<BindTask.ResponseParam>(callback), options, scheduler);

        mSrvReq = requestParam;
    }

    @Override
    public byte[] marshall() {
        pushMarshallable(mSrvReq);
        return super.marshall();
    }

    @Override
    public void unmarshall(byte[] buf) {
        super.unmarshall(buf);
        mSrvRes = (ResponseParam) popMarshallable(ResponseParam.class);
    }

    public static class RequestParam extends ProtoPacket {
        private String mContext = "";
        private long mUid;
        private byte[] mToken;
        private long mSeqId = 0;
        private Map<String, String> mClientHeaders;
        private int mTokenType; // 0 - 默认，原来的otp；1 - 第三方token

        public RequestParam(long uid, byte[] token) {
            mContext = "";
            mUid = uid;
            mToken = token;
            mTokenType = 0;
        }

        public RequestParam(String ctx, long uid, byte[] token, long seqId,
                            Map<String, String> clientHeaders) {
            mContext = ctx == null ? "" : ctx;
            mUid = uid;
            mToken = token;
            mSeqId = seqId;
            mClientHeaders = clientHeaders;
            mTokenType = 0;
        }

        public RequestParam(long uid, byte[] token, int tokenType) {
            mContext = "";
            mUid = uid;
            mToken = token;

            mTokenType = tokenType;
        }

        public void setSeqId(long seqId) {
            if (mSeqId == 0) {
                mSeqId = seqId;
            }
        }

        @Override
        public void marshall(ByteBuffer byteBuffer) {
            super.marshall(byteBuffer);
            this.pushBytes(mContext.getBytes());
            this.pushInt64(mUid);
            this.pushBytes(mToken);
            this.pushInt64(mSeqId);
            this.pushMap(mClientHeaders, String.class);
            this.pushInt(mTokenType);
        }
    }

    public static class ResponseParam extends ProtoPacket {
        public String mContext;
        public int mResCode;
        public String mResMsg;
        public Map<String, String> mServerHeaders;

        public ResponseParam() {
        }

        @Override
        public void unmarshall(ByteBuffer buf) {
            super.unmarshall(buf);
            mContext = this.popString16("UTF-8");
            mResCode = this.popInt();
            mResMsg = this.popString16("UTF-8");
            mServerHeaders = this.popMap(String.class, String.class);
        }
    }

    @Override
    public void onResponseSuccess(final int requestId, final int sdkResCode) {
        mScheduler.post(new Runnable() {
            @Override
            public void run() {
                mCallback.onSuccess(requestId, mSrvRes);
            }
        });
    }

    @Override
    public void onResponseFail(final int requestId, final int sdkResCode) {
        mScheduler.post(new Runnable() {
            @Override
            public void run() {
                mCallback.onFail(requestId, sdkResCode, mSrvRes.mResCode,
                        new Exception(mSrvRes.mResMsg));
            }
        });
    }

    final class CallbackRespHeaders implements IRPCChannel.RPCCallback<ResponseParam> {
        protected IRPCChannel.RPCCallbackRespHeaders<BindTask.ResponseParam> mCallbackRespHeaders;

        CallbackRespHeaders(IRPCChannel.RPCCallbackRespHeaders<BindTask.ResponseParam> callback) {
            mCallbackRespHeaders = callback;
        }

        @Override
        public void onSuccess(int requestId, ResponseParam response) {
            mCallbackRespHeaders.onSuccess(requestId, response);
        }

        @Override
        public void onFail(int requestId, int sdkResCode, int srvResCode, Exception e) {
            mCallbackRespHeaders.onFail(requestId, sdkResCode, srvResCode, mSrvRes.mServerHeaders, e);
        }
    }
}
