package com.yy.platform.baseservice.task;

import android.os.Bundle;
import android.os.Handler;

import com.yy.platform.baseservice.IRPCChannel;
import com.yy.platform.baseservice.marshal.ProtoPacket;
import com.yy.platform.baseservice.utils.UserGroupType;

import java.nio.ByteBuffer;
import java.util.ArrayList;

public class BroadSubOrUnSubTask extends AbstractTask<BroadSubOrUnSubTask.ResponseParam> {

    private RequestParam mSrvReq;

    public static final long URI = 13;

    public BroadSubOrUnSubTask(int reqId, RequestParam requestParam,
                               IRPCChannel.RPCCallback<ResponseParam> callback,
                               Bundle options, Handler scheduler) {
        super(URI, reqId, callback, options, scheduler);

        mSrvReq = requestParam;
    }

    @Override
    public byte[] marshall() {
        pushMarshallable(mSrvReq);
        return super.marshall();
    }

    @Override
    public void unmarshall(byte[] buf) {
        super.unmarshall(buf);
        mSrvRes = (ResponseParam) popMarshallable(ResponseParam.class);
    }

    public static class RequestParam extends ProtoPacket {
        private String mContext;
        private ArrayList<UserGroupType> mUserGrps;
        private byte mOptype;

        public RequestParam(String ctx, ArrayList<UserGroupType> userGrps, byte optype) {
            mContext = ctx;
            mUserGrps = userGrps;
            mOptype = optype;
        }

        @Override
        public void marshall(ByteBuffer byteBuffer) {
            super.marshall(byteBuffer);
            this.pushBytes(mContext.getBytes());
            this.pushCollection(mUserGrps, UserGroupType.class);
            this.pushByte(mOptype);
        }

    }

    public static class ResponseParam extends ProtoPacket {
        public String mContext;
        public int mResCode;
        public String mErrMsg;

        public ResponseParam() {
        }

        @Override
        public void unmarshall(ByteBuffer buf) {
            super.unmarshall(buf);
            mContext = this.popString16("UTF-8");
            mResCode = this.popInt();
            mErrMsg = this.popString16("UTF-8");
        }
    }

    @Override
    public void onResponseSuccess(final int requestId, final int sdkResCode) {
        mScheduler.post(new Runnable() {
            @Override
            public void run() {
                mCallback.onSuccess(requestId, mSrvRes);
            }
        });
    }

    @Override
    public void onResponseFail(final int requestId, final int sdkResCode) {
        mScheduler.post(new Runnable() {
            @Override
            public void run() {
                mCallback.onFail(requestId, sdkResCode, mSrvRes.mResCode,
                        new Exception(mSrvRes.mErrMsg));
            }
        });
    }
}
