package com.yy.platform.baseservice.storage;

import android.content.Context;
import android.content.SharedPreferences;

import java.util.UUID;

public enum ShareStore {
    INSTANCE;

    private static SharedPreferences mSharedPref = null;
    private static String mStatisHdId = "";
    private static String mStatisUUID = "";

    public void init(Context appContext, long appId) {
        mSharedPref = appContext.getSharedPreferences(String.valueOf(appId) + "servicesdk", Context.MODE_PRIVATE);
        mStatisHdId = null;
    }

    //这个方法从native层调用到
    public String getHdId() {
        if (mStatisHdId == null) {
            mStatisHdId = mSharedPref.getString("hdid", "");
            try {
                //如果没有产生一个UUID存起来
                if (mStatisHdId.isEmpty()) {
                    String tmpUuid = UUID.randomUUID().toString();
                    mStatisHdId = tmpUuid.replace("-", "");
                    storeHdId();
                }
            } catch (Throwable e) {
                return mStatisHdId;
            }
        }
        return mStatisHdId;
    }

    public String getUUID() {
        if (mStatisUUID.isEmpty()) {
            mStatisUUID = getHdId();
        }
        return mStatisUUID;
    }

    public void setHdId(String hdid) {
        if (hdid == null || hdid.isEmpty()) {
            return;
        }
        mStatisHdId = hdid;

        new Thread(new Runnable() {
            @Override
            public void run() {
                storeHdId();
            }
        }).start();
    }

    private void storeHdId() {
        if (mStatisHdId == null || mStatisHdId.isEmpty()) {
            return;
        }

        SharedPreferences.Editor editor = mSharedPref.edit();
        editor.putString("hdid", mStatisHdId);

        editor.commit();
    }

    public String[] dnsStoreLoad() {

        String lbsips = mSharedPref.getString("ipskey", "");
        if (lbsips == null || lbsips.isEmpty()) {
            String[] ips = new String[]{};
            return ips;
        } else {
            String[] splitips = lbsips.split("\\|");

            return splitips;
        }
    }

    public int dnsStoreFlush(String[] ips) {
        StringBuilder stringBuilder = new StringBuilder("");
        for (int i = 0; i < ips.length; i++) {
            stringBuilder.append(ips[i]);
            stringBuilder.append("|");
        }
        SharedPreferences.Editor editor = mSharedPref.edit();
        editor.putString("ipskey", stringBuilder.toString());

        boolean ret = editor.commit();
        if (!ret) {
            return -1;
        } else {
            return 0;
        }
    }
}
