package com.yy.platform.baseservice.statis;

import com.yy.platform.baseservice.YYServiceCore;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Locale;

public class HttpUtil {

    /**
     * 请求返回结果
     *
     * @author:wsq
     * @time:Mar 8, 2016 4:26:52 PM
     */
    public static class HttpResp {
        //是否成功，200为成功
        public boolean isSucceed = false;
        //返回状态码
        public int statusCode = -1;
        //返回的失败原因
        public String reason = null;
        //结果
        public String result = null;
    }

    public static String post(String urlAddr, String content) throws IOException {
        return postByUrlConn(urlAddr, content).result;
    }

    public static HttpResp getByUrlConn(String urlAddr, String content) throws IOException {
        HttpResp resp = new HttpResp();
        // 新建一个URL对象
        HttpURLConnection urlConn = null;
        DataOutputStream dos = null;
        InputStream is = null;
        URL url = null;
        try {
            if (content != null && content.length() > 0) {
                urlAddr = String.format("%s?%s", urlAddr, content);
            }
            url = new URL(urlAddr);
            // 打开一个HttpURLConnection连接
            urlConn = (HttpURLConnection) url.openConnection();
            // 设置连接超时时间
            urlConn.setConnectTimeout(10 * 1000);
            urlConn.setReadTimeout(10 * 1000);
            // 请求不能使用缓存
            urlConn.setUseCaches(false);
            // 设置为GET请求
            urlConn.setRequestMethod("GET");
            urlConn.setInstanceFollowRedirects(true);
            urlConn.setRequestProperty("User-Agent", "Hiido");
            // 开始连接
            urlConn.connect();
            // 判断请求是否成功
            resp.isSucceed = urlConn.getResponseCode() == 200;
            resp.statusCode = urlConn.getResponseCode();
            resp.reason = urlConn.getResponseMessage();

            // 判断请求是否成功
            if (urlConn.getResponseCode() == 200) {
                YYServiceCore.log(String.format(Locale.US, "get url=[%s] is ok", url));
                /* 取得Response内容 */
                is = urlConn.getInputStream();
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                byte[] b = new byte[1024];
                int len = 0;
                while ((len = is.read(b)) != -1) {
                    bao.write(b, 0, len);
                }
                resp.result = new String(bao.toByteArray(), "UTF-8");
                YYServiceCore.log(String.format(Locale.US, "the result is %s", resp.result));
                b = null;
                bao.close();
            } else {
                YYServiceCore.log(String.format(Locale.US, "http get [%s] error! status:%d",
                        url, urlConn.getResponseCode()));
            }
        } finally {
            try {
                if (urlConn != null) {
                    urlConn.disconnect();
                    urlConn = null;
                }
                if (dos != null) {
                    dos.close();
                    dos = null;
                }
                if (is != null) {
                    is.close();
                    is = null;
                }
                url = null;
            } catch (Throwable e) {
                return resp;
            }
        }
        return resp;
    }

    public static HttpResp postByUrlConn(String urlAddr, String content) throws IOException {
        HttpResp resp = new HttpResp();
        // 新建一个URL对象
        HttpURLConnection urlConn = null;
        DataOutputStream dos = null;
        InputStream is = null;
        URL url = null;
        try {
            url = new URL(urlAddr);
            // 打开一个HttpURLConnection连接
            urlConn = (HttpURLConnection) url.openConnection();
            // 设置连接超时时间
            urlConn.setConnectTimeout(10 * 1000);
            urlConn.setReadTimeout(10 * 1000);
            // Post请求必须设置允许输出
            urlConn.setDoOutput(true);
            // Post请求不能使用缓存
            urlConn.setUseCaches(false);
            // 设置为Post请求
            urlConn.setRequestMethod("POST");
            urlConn.setInstanceFollowRedirects(true);
            // 配置请求Content-Type
            urlConn.setRequestProperty("Accept-Charset", "text/html;charset=UTF-8");

            urlConn.setRequestProperty("User-Agent", "Hiido");
            // 开始连接
            urlConn.connect();
            // 发送请求参数
            dos = new DataOutputStream(urlConn.getOutputStream());
            dos.write(content.getBytes("UTF-8"));
            dos.flush();
            dos.close();

            resp.isSucceed = urlConn.getResponseCode() == 200;
            resp.statusCode = urlConn.getResponseCode();
            resp.reason = urlConn.getResponseMessage();

            // 判断请求是否成功
            if (urlConn.getResponseCode() == 200) {
//                YYServiceCore.Log(String.format(Locale.US,"post url=[%s] is ok",url));
                /* 取得Response内容 */
                is = urlConn.getInputStream();
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                byte[] b = new byte[1024];
                int len = 0;
                while ((len = is.read(b)) != -1) {
                    bao.write(b, 0, len);
                }
                resp.result = new String(bao.toByteArray(), "UTF-8");
//                YYServiceCore.Log(String.format(Locale.US,"the result is %s",resp.result));
                b = null;
                bao.close();
            } else {
                YYServiceCore.log(String.format(Locale.US, "http post [%s] error! status:%d",
                        url, urlConn.getResponseCode()));
            }
        } finally {
            try {
                if (urlConn != null) {
                    urlConn.disconnect();
                    urlConn = null;
                }
                if (dos != null) {
                    dos.close();
                    dos = null;
                }
                if (is != null) {
                    is.close();
                    is = null;
                }
                url = null;
            } catch (Throwable e) {
                return resp;
            }
        }
        return resp;
    }
}

