package com.yy.platform.baseservice.statis;

import android.text.TextUtils;

import java.io.IOException;
import java.util.Locale;
import java.util.Random;

import com.yy.platform.baseservice.YYServiceCore;
import com.yy.platform.baseservice.statis.HttpUtil.HttpResp;

public abstract class AbstractStatisHttpUtil implements IStatisHttpUtil {

    protected int mRetryTimeHost = 1;

    protected int mTryTimeIp = 1;

    protected Throwable mThrowable;

    protected String testServer;

    protected int lastTryTimes;

    protected String getServerAddr() {
        String ret = testServer == null || testServer.length() == 0 ? getUrlService() : testServer;
        return ret;
    }

    protected String[] getFallbackIps() {
        return testServer == null || testServer.length() == 0 ? getUrlAddress() : new String[]{};
    }

    public void setTestServer(String testServer) {
        this.testServer = testServer;
    }

    public boolean sendSync(final String content) {
        return sendSyncByTrying(content);
    }

    protected boolean sendSyncByTrying(final String content) {
        //尝试域名发送，发送3次
        if (sendContent(getServerAddr(), content, mRetryTimeHost)) {
            return true;
        }

        //尝试获取备用ip发送
        // try to use IP address.
        // choose one IP from the backup IP addresses randomly.
        String[] ips = getFallbackIps();
        YYServiceCore.log(String.format(Locale.US, "report fallback IPs : %s", TextUtils.join(" ", ips)));

        if (ips == null || ips.length == 0) {
            return false;
        }

        //(发送2次,每次ip都随机获取)
        int ipTimes = mTryTimeIp;
        int index = 0;
        String url = null;
        while (ipTimes-- > 0) {
            index = new Random().nextInt(ips.length);
            url = asUrl(ips[index]);

            if (sendContent(url, content, 0)) {
                return true;
            }
        }
        return false;
    }

    public boolean sendSync(final String metricUri, long realTS,
                            final String content) {
        //尝试域名发送，发送3次
        if (sendContent(metricUri, realTS, getServerAddr(), content, mRetryTimeHost)) {
            return true;
        }
        //经测试，设置的http connectTimeout 和readTimeout不生效，过很久才返回失败，
        //如果与数据产生时间超过了20s 不再重试了，如果timeout在20s内生效了可以再试一次
        long nowts = System.currentTimeMillis() / 1000;
        if (Math.abs(nowts - realTS) > 20) {
            return true;
        }
        //尝试获取备用ip发送
        // try to use IP address.
        // choose one IP from the backup IP addresses randomly.
        String[] ips = getFallbackIps();
        YYServiceCore.log(String.format(Locale.US, "report fallback IPs : %s", TextUtils.join(" ", ips)));

        if (ips == null || ips.length == 0) {
            return false;
        }

        //(发送2次,每次ip都随机获取)
        int ipTimes = mTryTimeIp;
        int index = 0;
        String url = null;
        while (ipTimes-- > 0) {
            index = new Random().nextInt(ips.length);
            url = asUrl(ips[index]);

            if (sendContent(metricUri, realTS, url, content, 0)) {
                return true;
            }
        }
        return false;
    }

    protected boolean get(String urlAddr, String content) throws IOException {
        return getByUrlConn(urlAddr, content);
    }

    protected boolean post(String urlAddr, String content) throws IOException {
        return postByUrlConn(urlAddr, content);
    }

    protected int statusCode;
    protected String reasonPhrase;

    private boolean getByUrlConn(String urlAddr, String content) throws IOException {
        statusCode = -1;
        reasonPhrase = null;
        HttpResp resp = HttpUtil.getByUrlConn(urlAddr, content);

        statusCode = resp.statusCode;
        reasonPhrase = resp.reason;
        return resp.isSucceed;
    }

    private boolean postByUrlConn(String urlAddr, String content) throws IOException {
        statusCode = -1;
        reasonPhrase = null;
        HttpResp resp = HttpUtil.postByUrlConn(urlAddr, content);

        statusCode = resp.statusCode;
        reasonPhrase = resp.reason;
        return resp.isSucceed;
    }

    protected String asUrl(String ip) {
        return String.format(getUrlFormat(), ip);
    }

    public Throwable getLastError() {
        return mThrowable;
    }

    @Override
    public int getLastStatusCode() {
        return statusCode;
    }

    /**
     * 发送内容
     *
     * @param url
     * @param content
     * @param tryTimes
     * @return
     */
    protected abstract boolean sendContent(final String url, final String content, int tryTimes);

    protected abstract boolean sendContent(final String metricUri, long realTS,
                                           final String url, final String content, int tryTimes);

    /**
     * 获取服务器地址
     *
     * @return
     */
    protected abstract String getUrlService();

    /**
     * 获取地址格式
     *
     * @return
     */
    protected abstract String getUrlFormat();

    /**
     * 获取备用列表
     *
     * @return
     */
    protected abstract String[] getUrlAddress();

}
