package com.yy.platform.baseservice;

import java.util.Map;

public interface IChannelListener {

    interface IChannelStatusNotify {
        /**
         * 通道的连通状态
         * 可及时感知到连接的可用性，
         * 可根据状态描述采取进一步措施，比如提醒用户检查网络、绑定帐号
         *
         * @param status 值含义看参看{@link ConstCode.Status#desc(int)}
         */
        void onStatus(int status);
    }

    interface ITokenProvider {
        /**
         * 断线等如需要重新登录bind Service但Token 失效时，会由SDK回调 向App 或UDB SDK 模块请求新Token
         *
         * @param uid SDK记录的发起过bind的UID
         * @return 返回有效的Token(OTP票据)，根据tokenType不同取不同的token
         * 若tokenType 为0，则调用YYLoginliteSDK 中getServiceToken 获取 或者getOtp("signap")取得
         * 若tokenType 为1，则需使用第三方token服务或自己实现一个
         * 若tokenType 为2，则调用国内版udbauthsdk(AuthSDK)，调用getTokenB("linkd")取得
         */
        byte[] getToken(long uid);
    }

    interface ITokenVerifyNotify {
        /**
         * 回调通知Token无效
         *
         * @param uid
         * @param code 取值含义请参看{@link ConstCode.TokenVerifyCode}
         */
        void onVerifyResult(long uid, int code);
    }

    interface IBindVerifyErrNotify {
        /**
         * 回调通知登录Bind失败及Token错误原因
         *
         * @param uid
         * @param resCode    取值含义请参看{@link ConstCode.BindResCode}
         * @param srvHeaders Token验证失败原因，
         *                   key 为{@link ConstCode.HeaderKey#BindErrKey1},
         *                   value为{@link ConstCode.HeaderValue#BindErrKey1Val1/BindErrKey1Val2
         *                   /BindErrKey1Val3/BindErrKey1Val4}
         */
        void onBindVerifyError(long uid, int resCode, Map<String, String> srvHeaders);
    }

    interface IForceUnBindNotify {
        /**
         * 被Service踢下线
         *
         * @param uid  bind 登录Service的UID
         * @param code 踢下线的原因
         * @param desc 踢下线的描述，可直接提示UI
         */
        void onForceOut(long uid, int code, String desc);
    }

    interface IServiceBroadcastNotify {
        /**
         * 接收到广播
         *
         * @param uid          bind 登录Service的自己的UID，未bind匿名则为0
         * @param grpType      广播组Type
         * @param grpId        广播组ID
         * @param serviceName  服务名
         * @param functionName 方法名
         * @param protoType    协议类型
         * @param data         协议数据
         */
        void onBroadCast(long uid, long grpType, long grpId,
                         String serviceName, String functionName,
                         String protoType, byte[] data);
    }

    interface IServiceStrGroupBroadcastNotify {
        /**
         * 接收到广播
         *
         * @param uid          bind 登录Service的自己的UID，未bind匿名则为0
         * @param grpStr       广播组
         * @param serviceName  服务名
         * @param functionName 方法名
         * @param protoType    协议类型
         * @param data         协议数据
         */
        void onBroadCastFromStrGroup(long uid, String grpStr,
                                     String serviceName, String functionName,
                                     String protoType, byte[] data);
    }

    interface IServiceUnicastNotify {
        /**
         * 接收到广播
         *
         * @param uid          bind 登录Service的自己的UID，未bind匿名则为0
         * @param serviceName  服务名
         * @param functionName 方法名
         * @param protoType    协议类型
         * @param data         协议数据
         */
        void onUnicast(long uid, String serviceName, String functionName, String protoType, byte[] data);
    }

    interface IServiceHiidoMetricsStatisApi {
        /**
         * 对应 HiidoSDK.instance().reportReturnCode
         *
         * @param scode
         * @param uri
         * @param timeConsumption
         * @param code
         */
        void reportReturnCode(final int scode, final String uri, final long timeConsumption, final String code);

        /**
         * 对应 HiidoSDK.instance().reportCount
         *
         * @param scode
         * @param uri
         * @param countName
         * @param count
         */
        void reportCount(int scode, String uri, String countName, long count);

        /**
         * 对应 HiidoSDK.instance().reportCount
         *
         * @param scode
         * @param uri
         * @param countName
         * @param count
         * @param times
         */
        void reportCount(int scode, String uri, String countName, long count, int times);

        /**
         * 对应 HiidoSDK.instance().reportStatisticContentTemporary
         *
         * @param act
         * @param intFields
         * @param longFields
         * @param stringFields
         */
        void reportStatisticContentTemporary(String act,
                                             Map<String, Integer> intFields,
                                             Map<String, Long> longFields,
                                             Map<String, String> stringFields);
    }

    interface IReportPktApi {
        /**
         * 接收无效包的回调统计
         *
         * @param code 错误code,取值{@link ConstCode.PktErrorCode}
         * @param pkt  错包
         * @param uri  预留
         */
        void reportPktError(final int code, final String pkt, final String uri);
    }
}
