package com.yy.platform.baseservice;

public class ConstCode {

    public final static class Status {
        /**
         * 初始化
         */
        public final static int Init = 0;
        /**
         * 正在连接服务器...
         */
        public final static int OnConnecting = 1;
        /**
         * 连接超时!
         */
        public final static int OnConnecttimeout = 2;
        /**
         * 连接成功!
         */
        public final static int OnConnected = 3;
        /**
         * 连接断开了!
         */
        public final static int OnClosed = 4;
        /**
         * 关闭连接
         */
        public final static int Close = 5;
        /**
         * 连接绑定ID状态!
         */
        public final static int Binded = 6;

        public static String desc(int code) {
            if (Init == code) {
                return "初始化";
            } else if (OnConnecting == code) {
                return "正在连接服务器...";
            } else if (OnConnecttimeout == code) {
                return "连接超时!";
            } else if (OnConnected == code) {
                return "连接成功!";
            } else if (OnClosed == code) {
                return "连接断开了!";
            } else if (Close == code) {
                return "关闭连接";
            } else if (Binded == code) {
                return "连接绑定ID状态!";
            }
            return "UNKNOW-未知状态";
        }
    }

    /**
     * 客户端返回码
     */
    public final static class SdkResCode {
        /**
         * 成功收到服务响应
         */
        public static final int RECV_RESPONSE = 1;
        /**
         * 发送请求成功
         */
        public static final int SEND_SUCCESS = 0;
        /**
         * 未连接
         */
        public static final int NO_CONNECTED = -1;
        /**
         * 需要绑定ID
         */
        public static final int NEED_BIND = -2;
        /**
         * 客户端请求超时(请求已发送出去但未收到响应)
         */
        public static final int TIMEOUT = -3;

        /**
         * 客户端请求超时(连接还未成功)
         */
        public static final int TIMEOUT_SEND = -4;

        /**
         * 绑定Service时uid=0非法
         */
        public static final int BIND_UID_0 = -5;

        /**
         * 绑定Service时token为空
         */
        public static final int BIND_TOKEN_NIL = -6;

        /**
         * 客户端未知错误
         */
        public static final int UNKNOW = -255;

        public static String desc(int code) {
            if (RECV_RESPONSE == code) {
                return "成功收到服务响应(" + code + ")";
            } else if (SEND_SUCCESS == code) {
                return "发送请求成功(" + code + ")";
            } else if (NO_CONNECTED == code) {
                return "未连接(" + code + ")";
            } else if (NEED_BIND == code) {
                return "需要绑定ID(" + code + ")";
            } else if (TIMEOUT == code) {
                return "客户端请求超时-请求已发送出去但未收到响应(" + code + ")";
            } else if (TIMEOUT_SEND == code) {
                return "客户端请求超时-连接还未成功(" + code + ")";
            } else if (BIND_UID_0 == code) {
                return "绑定UID=0非法(" + code + ")";
            } else if (BIND_TOKEN_NIL == code) {
                return "绑定Token为空非法(" + code + ")";
            }
            return "UNKNOW-客户端未知错误(" + code + ")";
        }
    }

    /**
     * 上下行服务端返回码,
     *
     * @see <a href="https://git.yy.com/opensource/g-yy-bt/service_platform/blob/master/ServiceInterfaceYY.md>
     * https://git.yy.com/opensource/g-yy-bt/service_platform/blob/master/ServiceInterfaceYY.md</a>
     */
    public final static class SrvResCode {
        /**
         rescode resMsg desc notice
         200"OK" 返回成功 业务后台有响应，至于业务层面的错误异常需在业务data里定义
         400"Bad Request" 上行消息解析失败
         401"Unauthorized" 上行消息uid未验证 需要使用实名认证的票据登入
         402"Payment Required" 你懂的 该请service组吃顿饭了
         403"Forbidden"预留
         404"Not Found"预留
         408"Request Timeout"后端超时
         500"Internal Server Error"
         502"Bad Gateway"预留
         503"Service Unavailable" 找不到后端服务 路由规则匹配失败
         504"Gateway Timeout"预留
         **/

        /**
         * 请求业务服务成功
         */
        public static final int RES_SUCCESS = 200;
        /**
         * 上行消息解析失败
         */
        public static final int RES_BADREQUEST = 400;
        /**
         * 上行消息uid未验证 需要使用实名认证的票据登入
         */
        public static final int RES_UNAUTHORIZED = 401;
        /**
         * 你懂的 该请service组吃顿饭了
         */
        public static final int RES_PAYMENTREQUIRED = 402;
        /**
         * 请求业务服务失败(Forbidden)
         */
        public static final int RES_FAIL = 403;
        /**
         * 找不到服务(Not Found)
         */
        public static final int RES_NOTFOUND = 404;
        /**
         * 请求业务服务超时(Request Timeout)
         */
        public static final int RES_TIMEOUT = 408;

        /**
         * 请求超过次数限制
         */
        public static final int RES_OVERTIMES = 453;

        /**
         * 内部服务错误
         */
        public static final int RES_INTERNALSERVERERROR = 500;
        /**
         * 网关错误(Bad Gateway)
         */
        public static final int RES_BADGATEWAY = 502;
        /**
         * 找不到后端服务 路由规则匹配失败
         */
        public static final int RES_SERVICEUNAVAILABLE = 503;
        /**
         * 网关超时(Gateway Timeout)
         */
        public static final int RES_GATEWAYTIMEOUT = 504;

        public static String desc(int code) {
            if (RES_SUCCESS == code) {
                return "请求业务服务成功(" + code + ")";
            } else if (RES_BADREQUEST == code) {
                return "上行消息解析失败(" + code + ")";
            } else if (RES_UNAUTHORIZED == code) {
                return "上行消息uid未验证(" + code + ")";
            } else if (RES_PAYMENTREQUIRED == code) {
                return "你懂的\t该请service组吃顿饭了(" + code + ")";
            } else if (RES_FAIL == code) {
                return "请求业务服务失败(" + code + ")";
            } else if (RES_NOTFOUND == code) {
                return "找不到服务(" + code + ")";
            } else if (RES_TIMEOUT == code) {
                return "请求业务服务超时(" + code + ")";
            } else if (RES_OVERTIMES == code) {
                return "请求超过次数限制(" + code + ")";
            } else if (RES_INTERNALSERVERERROR == code) {
                return "内部服务错误(" + code + ")";
            } else if (RES_BADGATEWAY == code) {
                return "网关错误(" + code + ")";
            } else if (RES_SERVICEUNAVAILABLE == code) {
                return "找不到后端服务(" + code + ")";
            } else if (RES_GATEWAYTIMEOUT == code) {
                return "网关超时(" + code + ")";
            }
            return "UNKNOW-未知服务错误(" + code + ")";
        }
    }

    public final static class ServiceTokenType {
        /**
         * 国际版UDB的service token，使用用yyloginlitesdk 的getServiceToken 接口得到token
         */
        public final static int NEW_UDB_TOKEN = 0;
        /**
         * 业务自己账号体系下产生的uid 和token，既不是从国际版UDB SDK也不是国内版UDB SDK 拿到token的情况下
         */
        public final static int THIRD_USER_TOKEN = 1;
        /**
         * YY体系（国内UDB）下的linkd token
         */
        public final static int YY_UDB_TOKEN = 2;
    }

    /**
     * 绑定帐号服务端返回码(Service Login ResCode)
     */
    public static final class BindResCode {
        /**  rescode resMsgdesc notice
         200""登入成功
         300""未就绪，请重试其他接入ap
         403"OTP_APPID_ERR(53)"Otp票据验证失败
         408""Otp票据验证超时，请重试
         406""负载满，请重试其他接入ap
         409""资源冲突，请重试其他接入ap
         */

        /**
         * 绑定成功
         */
        public static final int BIND_SUCCESS = 200;
        /**
         * 未就绪，请重试
         */
        public static final int BIND_NOTREADY_TORETRY = 300;
        /**
         * 票据验证失败
         */
        public static final int BIND_OTP_FAIL = 403;
        /**
         * 票据验证超时
         */
        public static final int BIND_OTP_TIMEOUT = 408;
        /**
         * 负载满，请重试
         */
        public static final int BIND_LOAD_FULL = 406;
        /**
         * 资源冲突，请重试
         */
        public static final int BIND_RESOURCE_CONFLICT = 409;

        public static String desc(int code) {
            if (BIND_SUCCESS == code) {
                return "绑定成功(" + code + ")";
            } else if (BIND_NOTREADY_TORETRY == code) {
                return "未就绪，请重试(" + code + ")";
            } else if (BIND_OTP_FAIL == code) {
                return "票据验证失败(" + code + ")";
            } else if (BIND_OTP_TIMEOUT == code) {
                return "票据验证超时(" + code + ")";
            } else if (BIND_LOAD_FULL == code) {
                return "负载满，请重试(" + code + ")";
            } else if (BIND_RESOURCE_CONFLICT == code) {
                return "资源冲突，请重试(" + code + ")";
            }
            return "UNKNOW-未知绑定错误(" + code + ")";
        }
    }

    public static final class TokenVerifyCode {
        /**
         * 已过期
         */
        public static final int TOKEN_EXPIRED = 1;
    }
    public static final class HeaderKey {
        //Bind登录AP 的token 无效错误码的key
        public static final String BindErrKey1 = "tokenservice-errorCode";
    }
    public static final class HeaderValue {
        //签名校验失败
        public static final String BindErrKey1Val1 = "signatureError";
        //uid错误
        public static final String BindErrKey1Val2 = "uidWrong";
        //appid错误
        public static final String BindErrKey1Val3 = "appidWrong";
        //超时
        public static final String BindErrKey1Val4 = "expire";
    }
    public static final class PktErrorCode {
        //长度无效
        public static final int PKT_LEN_WRONG = 1;
        //长度过大
        public static final int PKT_LEN_BIG = 2;
        //URI无效
        public static final int PKT_URI_INVALID = 3;
        //解包错误
        public static final int PKT_UNPACK_ERR = 4;
    }
}

