package com.yy.platform.baseservice.marshal;

public class NumberUtils {

    /**
     * 用于解析C++传递给java的uint32_t
     *
     * @param num num实际是C++传递上来的uint32_t
     * @return long
     */
    public static long uint32ToLong(int num) {
        // long l = num >> 32;
        // l = l << 32 & num >> 1;
        // return l;
        return ((long) num) & 0xFFFFFFFFL;
    }

    /**
     * 对比两个无符号32位整数的大小。
     *
     * @param a 保存无符号32位整数
     * @param b 保存无符号32位整数
     * @return int
     * 等于0，表示a=b；等于1，表示a>b；等于-1表示a<b。
     */
    public static int uint32Compare(int a, int b) {
        long al = uint32ToLong(a);
        long bl = uint32ToLong(b);
        if (al == bl) {
            return 0;
        } else if (al > bl) {
            return 1;
        } else if (bl > al) {
            return -1;
        } else {
            // IMLog.warn(ImModule.TAG, "uint32Compare");
            return -2;
        }
    }

    /**
     * 把一个8位的数存放如byte中。
     *
     * @param num 范围为0~255，用于表示一个C++的uint8_t
     * @return byte
     */
    public static byte uint8ToByte(int num) {
        return (byte) (num & 0xFFFF);
    }

    /**
     * 取得c++ uint32_t的最大值
     *
     * @return long
     */
    public static long maxUint32() {
        return uint32ToLong(0xFFFFFFFF);
    }

    /**
     * 把一个long转换为uint32_t存放在int中，用于传递值给C++
     *
     * @param num
     * @return int
     */
    public static int longToUint32ForCpp(long num) {
        if (num > maxUint32() || num < 0) {
            return -1;
        }
        return (int) (num & 0xFFFFFFFF);
    }

    public static int getLongLow32Bit(long num) {
        return (int) (num & 0xFFFFFFFF);
    }

    public static int getLongHigh32Bit(long num) {
        return (int) ((0xFFFFFFFF00000000L & num) >> 32);
    }

    public static short setBit(short num, int index) {
        if (index < 0 || index > 16 - 1) {
            // IMLog.warn(ImModule.TAG, "invalid index = %d", index);
            return num;
        }
        return (short) (num | (1 << index));
    }

    public static int setBit(int num, int index) {
        if (index < 0 || index > 32 - 1) {
            // IMLog.warn(ImModule.TAG, "invalid index = %d", index);
            return num;
        }
        return num | (1 << index);
    }

    public static long setBit(long num, int index) {
        if (index < 0 || index > 64 - 1) {
            // IMLog.warn(ImModule.TAG, "invalid index = %d", index);
            return num;
        }
        return num | (1L << index);
    }

    /**
     * long转换为byte数组
     *
     * @param l
     * @return
     */
    public static byte[] longToBytes(long l) {
        byte[] bytes = new byte[8];
        bytes[0] = (byte) (l >> 56);
        bytes[1] = (byte) (l >> 48);
        bytes[2] = (byte) (l >> 40);
        bytes[3] = (byte) (l >> 32);
        bytes[4] = (byte) (l >> 24);
        bytes[5] = (byte) (l >> 16);
        bytes[6] = (byte) (l >> 8);
        bytes[7] = (byte) (l >> 0);
        return bytes;
    }

    /**
     * byte[]转为int
     *
     * @param b
     * @return
     */
    public static int byteToInt(byte[] b) {
        int mask = 0xff;
        int temp = 0;
        int n = 0;
        for (int i = 0; i < 4; i++) {
            n <<= 8;
            temp = b[i] & mask;
            n |= temp;
        }
        return n;
    }

    /**
     * 将越界的int型转为long型
     *
     * @param i
     * @return
     */
    public static long intToLong(int i) {
        long result = 0L;
        // 这里你用右位移运算，向右位移一位
        result = i >>> 1;
        result <<= 1;
        // 判断是否为奇数，奇数加1
        if (i % 2 != 0) {
            result += 1;
        }
        return result;
    }
}
