package com.yy.platform.baseservice.notify;

import com.yy.platform.baseservice.marshal.ProtoPacket;

import java.nio.ByteBuffer;

public class ReportServiceCount extends ProtoPacket {
    public int mScode;
    public String mCountUri;
    public ReportItem.ServiceCountItem[] mCountImtems;

    public static final long URI = 57;

    public ReportServiceCount() {
    }

    @Override
    public void unmarshall(byte[] buf) {
        super.unmarshall(buf);

        mScode = popInt();
        mCountUri = popString16UTF8();
        int len = popInt();
        mCountImtems = new ReportItem.ServiceCountItem[len];
        for (int i = 0; i < len; i++) {
            mCountImtems[i] = new ReportItem.ServiceCountItem();
            mCountImtems[i].mCountName = popString16UTF8();
            mCountImtems[i].mCount = popInt64();
        }
    }

    @Override
    public void unmarshall(ByteBuffer buf) {
        super.unmarshall(buf);

        mScode = popInt();
        mCountUri = popString16UTF8();
        int len = popInt();
        mCountImtems = new ReportItem.ServiceCountItem[len];
        for (int i = 0; i < len; i++) {
            mCountImtems[i] = new ReportItem.ServiceCountItem();
            mCountImtems[i].mCountName = popString16UTF8();
            mCountImtems[i].mCount = popInt64();
        }
    }
}
