//
// Created by HuTao on 2019/2/22.
//

#ifndef YYSERVICESDK_PARENT_YYSERVICECORE_H
#define YYSERVICESDK_PARENT_YYSERVICECORE_H

#include "ICoreChannel.h"
NAMESPACE_SERVICE_BEGIN
    typedef void (*ReleaseFunc)();

    class ServiceCore
    {
    public:
        static ServiceCore* initInstance(uint32_t appid,std::string& appName,
                                           std::string& appVer,std::string& sdkVer,
                                           std::string region,
                                           std::string logpath, bool logConsole);
        static ServiceCore* initInstance(uint32_t appid,std::string& appName,
                                           std::string& appVer,std::string& sdkVer,
                                           std::string region,
                                           IServiceLog* logger,bool logConsole);

        static void deInit();

        static ServiceCore* getInstance(){
            return sInstance;
        }
        /**
         * 开启本模块的Worker，开始运转，为与服务器通信做准备
         * @param mid
         *          模块ID，默认给0。如果功能集较多，单线程处理不够时，启动多个Worker分别处理不同模块
         * @param net
         *          启动时的网络状态，若后续有网络变化，可帮助本模块及时的连接上服务器
         * @return
         */
        ITaskThread* StartWorker(int mid,int net,ReleaseFunc jniDetachFunc);
        /**
         * 停止本模块运转
         * @param mid
         */
        void StopWorker(int mid);

        void SetProvider(IServiceProvider* provider);

        MutexLock* GetLock();

        ICoreChannel* NewChannel(int mid,int initNetStatus);
        void DeleteChannel(ICoreChannel* channel);

        ICoreChannel* GetChannel(int mid);

        uint32_t GetReqId();
    protected:
        static ServiceCore* sInstance;

        ServiceCore(uint32_t appid,std::string& appName,
                      std::string& appVer,std::string& sdkVer,
                      std::string region);

        ~ServiceCore();
    };

NAMESPACE_SERVICE_END

#endif //YYSERVICESDK_PARENT_YYSERVICECORE_H
