//
// Created by HuTao on 2019/2/22.
//

#ifndef YYSERVICESDK_PARENT_ICHANNEL_H
#define YYSERVICESDK_PARENT_ICHANNEL_H
#include "commondefine.h"
#include "basemod.h"
#include "ProtoPacketPool.h"
#include "LogFile.h"

#include "CodeDef.h"
#include "IRPCChannel.h"
#include "RequestResponse.h"
#include "DownLinkNotify.h"

NAMESPACE_SERVICE_BEGIN

    struct IServiceLog
    {
        virtual void OnLog(std::string msg) = 0;
    };
    struct IServiceProvider
    {
        virtual std::string hdid() = 0;
        virtual std::vector<std::string> dnsResolve(std::string& host) = 0;
        virtual std::vector<std::string> dnsStoreLoad() = 0;
        virtual int dnsStoreFlush(std::vector<std::string>& ips) = 0;
    };

    struct IServiceStatusNotify
    {
        virtual int OnStatus(int status) = 0;
        virtual void OnSyncServiceTime(uint64_t ts) = 0;
    };

    struct ILoginCallback
    {
        virtual void OnSuccess(LoginTask::RequestParam&, uint32_t,std::string, LoginTask::ResponseParam&) = 0;
        virtual void OnFail(LoginTask::RequestParam&, uint32_t,std::string, int sdkResCode, int srvResCode,
                std::string errDesc) = 0;
    };
//    typedef std::function<void(uint32_t,std::string,
//                               LoginTask::ResponseParam)> LoginSuccessCallback;
//    typedef std::function<void(uint32_t,std::string,
//                               int sdkResCode, int srvResCode, std::string errDesc)> LoginFailCallback;
    struct ILogoutCallback
    {
        virtual void OnSuccess(LogoutTask::RequestParam&, uint32_t,std::string, LogoutTask::ResponseParam&) = 0;
        virtual void OnFail(LogoutTask::RequestParam&, uint32_t,std::string, int sdkResCode, int srvResCode,
                std::string errDesc) = 0;
    };
//    typedef std::function<void(uint32_t,std::string,
//                               LogoutTask::ResponseParam)> LogoutSuccessCallback;
//    typedef std::function<void(uint32_t,std::string,
//                               int sdkResCode, int srvResCode, std::string errDesc)> LogoutFailCallback;
    struct ITokenProvider
    {
        virtual std::string RequestToken(uint64_t& uid) = 0;
    };
//    typedef std::function<std::string(uint64_t uid)> TokenProvider;
    struct IForceoutWatcher
    {
        virtual void OnForceOut( ForceOutNotify& forceOutNotify) = 0;
    };

    struct IBroadSubOrUnSubCallback
    {
        virtual void OnSuccess(BroadSubOrUnSubTask::RequestParam&, uint32_t, BroadSubOrUnSubTask::ResponseParam&) = 0;
        virtual void OnFail(BroadSubOrUnSubTask::RequestParam&, uint32_t, int sdkResCode, int srvResCode,
                std::string errDesc) = 0;
    };
//    typedef std::function<void(uint32_t, BroadSubOrUnSubTask::ResponseParam)> BroadSuccessCallback;
//    typedef std::function<void(uint32_t, int sdkResCode, int srvResCode, std::string errDesc)> BroadFailCallback;

    struct IDownDataWatcher
    {
        virtual void OnUnicastNotify( UnicastNotify& unicastNotify) = 0;
        virtual void OnBroadcastNotify( BrocastNotify& broadNotify) = 0;
        virtual void OnDLServiceResponse( RPCTask::ResponseParam& responseParam) = 0;
        virtual void OnLocalData( std::string& data) = 0;
    };
    struct IReportWatcher
    {
        virtual void OnReportAct(ReportServiceAct& rItem) = 0;
        virtual void OnReportRtt(ReportServiceRtt& rItem) = 0;
        virtual void OnReportCount(ReportServiceCount& rItem) = 0;
        virtual void OnReportActRtt(ReportServiceActRtt& rItem) = 0;
        virtual void OnReportActCount(ReportServiceActCount& rItem) = 0;
        virtual void OnReportPktError(int code, std::string& pkt,std::string& uri) = 0;
    };

    class ICoreChannel : public IRPCChannel
    {
    public:
        ICoreChannel(){};
        virtual ~ICoreChannel(){};

        virtual int Open(IServiceStatusNotify* statusNotify) = 0;

        virtual int OpenWithTest(std::string testaddr,int port, IServiceStatusNotify* statusNotify) = 0;

        virtual int Close() = 0;

        virtual void OnNetworkStatusChange(int status) = 0;

        virtual void SetDefaultHeaders(std::map<std::string,std::string>& defaultHeaders) = 0;
        virtual void SetDefaultRoutes(std::map<std::string,std::string>& defaultRoutes) = 0;

        virtual int RpcCall(RPCTask::RequestParam& request,
                            TaskOption callOption,
                            ITaskThread* callbackThread,
                            IRPCCallback* callback) = 0;

        virtual int GetInstId() = 0;//同一个进程多通道实例时可能需要
        virtual int Bind(uint64_t uid,int tokenType,ITokenProvider* tokenProvider,
                         TaskOption callOption,
                         ITaskThread* callbackThread,
                         ILoginCallback* callback) = 0;
        virtual int UnBind(uint64_t uid,TaskOption callOption,
                         ITaskThread* callbackThread,
                         ILogoutCallback* callback) = 0;
        virtual void SetForceOutListener(IForceoutWatcher* listener) = 0;

        virtual int SubOrUnSubBroadcast(BroadSubOrUnSubTask::RequestParam& requestParam,
                                        TaskOption callOption,
                                        ITaskThread* callbackThread,
                                        IBroadSubOrUnSubCallback* callback) = 0;
        virtual uint16_t OpenLocalChannel(std::set<uint32_t > uris) = 0;
        virtual void SendLocalData(std::string& data) = 0;
        //注册广播、单播、下行消息接收器
        virtual void Watch(bool regist,
                           IDownDataWatcher* downDataWatcher) = 0;
        virtual void Watch(bool regist,IReportWatcher* reportWatcher) = 0;

        virtual const ConnectedQuality& GetApQos() = 0;
        virtual NetworkArea GetMyNetworkArea() = 0;

        virtual std::string GetIpStr(std::string& srvIp,std::string& srvPort) = 0;

        virtual void Lock() = 0;
        virtual void UnLock() = 0;

        virtual ProtoPacketPool* PacketPool() = 0;
    };

NAMESPACE_SERVICE_END
#endif //YYSERVICESDK_PARENT_ICHANNEL_H
