﻿//
// Created by HUTAO on 2017/7/13.
//

#ifndef YYPROTO_LOGFILE_H
#define YYPROTO_LOGFILE_H

#include "commondefine.h"
#include "mutex.h"

#undef __CLASS__
#define __CLASS__ "Log"
NAMESPACE_BASEMOD_BEGIN

#define NETTAG "YYSDK_S"

/**
* 业务模块使用本日志类时，给定相应预定义变量
* 得到宏LOGID，进而转换为Log实例索引，宏LOGID 只能在业务模块使用
*/
//#if defined(__IM__)
//#define LOGID 1
//#elif defined(__SIGNAL__)
//#define LOGID 2
//#elif defined(__PUSH__)
//#define LOGID 3
//#else
//#define DEFAULT_MODULE_ID 0 //如果需要多通道则定义相应预定义宏来保证使得编译通过，这样才可以保证能正确的使用LogFile 打印日志
//#endif

//#if !defined(LOGID)
//#define LOGID DEFAULT_MODULE_ID
//#endif
#define LOGID 0
/**
* 以下宏由业务方使用
*/
#define LOGE()		Log::getInstance(LOGID)->L(E,NETTAG, __CLASS__,  __FUNCTION__)
#define LOGITAG0() 	Log::getInstance(LOGID)->L(I,NETTAG, __CLASS__,  __FUNCTION__)
#define LOGITAG1(T1) 	Log::getInstance(LOGID)->L(I,NETTAG, __CLASS__,  __FUNCTION__, T1)
#define LOGITAG2(T1,T2) 	Log::getInstance(LOGID)->L(I,NETTAG, __CLASS__,  __FUNCTION__, T1,T2)
#define LOGITAG3(T1,T2,T3) 	Log::getInstance(LOGID)->L(I,NETTAG, __CLASS__,  __FUNCTION__, T1,T2,T3)
#define LOGITAG4(T1,T2,T3,T4) 	Log::getInstance(LOGID)->L(I,NETTAG, __CLASS__,  __FUNCTION__, T1,T2,T3,T4)
#define LOGITAG5(T1,T2,T3,T4,T5) 	Log::getInstance(LOGID)->L(I,NETTAG, __CLASS__,  __FUNCTION__,T1,T2,T3,T4,T5)
#define LOGITAG6(T1,T2,T3,T4,T5,T6) 	Log::getInstance(LOGID)->L(I,NETTAG, __CLASS__,  __FUNCTION__,T1,T2,T3,T4,T5,T6)
#define LOGITAG7(T1,T2,T3,T4,T5,T6,T7) 	Log::getInstance(LOGID)->L(I,NETTAG, __CLASS__,  __FUNCTION__,T1,T2,T3,T4,T5,T6,T7)
#define LOGITAG8(T1,T2,T3,T4,T5,T6,T7,T8) 	Log::getInstance(LOGID)->L(I,NETTAG, __CLASS__,  __FUNCTION__,T1,T2,T3,T4,T5,T6,T7,T8)
#define LOGITAG9(T1,T2,T3,T4,T5,T6,T7,T8,T9) 	Log::getInstance(LOGID)->L(I,NETTAG, __CLASS__,  __FUNCTION__,T1,T2,T3,T4,T5,T6,T7,T8,T9)
#define LOGITAG10(T1,T2,T3,T4,T5,T6,T7,T8,T9,T10) 	Log::getInstance(LOGID)->L(I,NETTAG, __CLASS__,  __FUNCTION__,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)
#define LOGI0(tag) 	Log::getInstance(LOGID)->L(I,tag, __CLASS__,  __FUNCTION__)
#define LOGI1(tag, T1) 	Log::getInstance(LOGID)->L(I,tag, __CLASS__,  __FUNCTION__, T1)
#define LOGI2(tag, T1,T2) 	Log::getInstance(LOGID)->L(I,tag, __CLASS__,  __FUNCTION__, T1,T2)
#define LOGI3(tag, T1,T2,T3) 	Log::getInstance(LOGID)->L(I,tag, __CLASS__,  __FUNCTION__, T1,T2,T3)
#define LOGI4(tag, T1,T2,T3,T4) 	Log::getInstance(LOGID)->L(I,tag, __CLASS__,  __FUNCTION__, T1,T2,T3,T4)
#define LOGI5(tag, T1,T2,T3,T4,T5) 	Log::getInstance(LOGID)->L(I,tag, __CLASS__,  __FUNCTION__,T1,T2,T3,T4,T5)
#define LOGI6(tag, T1,T2,T3,T4,T5,T6) 	Log::getInstance(LOGID)->L(I,tag, __CLASS__,  __FUNCTION__,T1,T2,T3,T4,T5,T6)
#define LOGI7(tag, T1,T2,T3,T4,T5,T6,T7) 	Log::getInstance(LOGID)->L(I,tag, __CLASS__,  __FUNCTION__,T1,T2,T3,T4,T5,T6,T7)
#define LOGI8(tag, T1,T2,T3,T4,T5,T6,T7,T8) 	Log::getInstance(LOGID)->L(I,tag, __CLASS__,  __FUNCTION__,T1,T2,T3,T4,T5,T6,T7,T8)
#define LOGI9(tag,T1,T2,T3,T4,T5,T6,T7,T8,T9) 	Log::getInstance(LOGID)->L(I,tag, __CLASS__,  __FUNCTION__,T1,T2,T3,T4,T5,T6,T7,T8,T9)
#define LOGI10(tag,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10) 	Log::getInstance(LOGID)->L(I,tag, __CLASS__,  __FUNCTION__,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10)

#define LOG_DEBUG 7
#define LOG_INFO  6
#define LOG_WARNING 4
#define LOG_ERROR  3
#define LOG_OUTPUTLEVEL 8

#define URI_PARSE(X) (X >> 8), (X & 0xFF)

#if defined(_WIN32)
const uint32_t    MAX_FILE_SIZE = 512 * 1024 * 500;               // 250M
const std::wstring LOGFILE_PREFIX = L"netsdk";//各模块前缀
const std::wstring LOGFILE_SUFFIX = L".bak";
#else
const uint32_t    MAX_FILE_SIZE = 512 * 1024 * 5;               // 2.5M
const std::string LOGFILE_PREFIX = "yysdk";//各模块前缀
const std::string LOGFILE_SUFFIX = ".bak";
#endif
const uint32_t    ROTATED_FILE_SIZE = 10;


enum Level
{
	E = LOG_ERROR,
	W = LOG_WARNING,
	I = LOG_INFO,
	D = LOG_DEBUG,

	U = LOG_OUTPUTLEVEL
};
enum Printer
{
	App = 1,
	SdkToAppProvideDir = 2,
	SdkToAppInstallDir = 3,
};
class ILog
{
public:
	virtual ~ILog() {};
public:
    virtual void Log(const std::string& msg) = 0;
};
/**
* 本日志实现类必须由使用方实例化
*/
class Log
{
private:
	Log()
	{
		m_printer = SdkToAppInstallDir;
		m_isDebug = false;
	};
	Log(int x);//日志类单例由调用方创建管理，生命周期最好与库的加载、卸载保持一致
	virtual ~Log();
	static Log* gLogInstance[8];//目前预分配8个
public:
	/**
	* 创建日志实例
	*/
	static Log* newInstance(int mid);
	/**
	* 删除日志实例
	*/
	static void deleteInstance(int mid);
	/**
	* 获取日志实例
	*/
	static Log *getInstance(int mid);

	/**
	* 获取本实例在basenet中的索引
	*/
	int getInstanceIndex() { return m_id; }
	/**
	* 若由SDK自己写log文件，请通过本方法设置相应文件路径
	* @param path
	* 			路径名，一般取app安装路径
	* @param appname
	* 			appid，如“yymand”
	* @param prefix
	* 			日志文件前缀，给空值则默认前缀为上述 定义LOGFILE_PREFIX
	*/
#if defined(_WIN32)
	void SetFile(const std::wstring path, const std::wstring appname, const std::wstring prefix);
#else
    void SetFile(const std::string path, const std::string appname, const std::string prefix);
#endif
	void SetOutConsle(bool isDebug);
	/**
	* 若由app写log文件，请及时注册日志接收实现
	* @param loger
	* 			ILog接口的实现
	*/
	void RegisterLoger(ILog* loger);
	/**
	* 若由app写log文件，不用后及时注销日志接收实现
	*/
	void UnRegisterLoger();
	
#ifdef _WIN32
	void logRun(void* param);
#else
	void* logRun(void* param);
#endif
private:
	void startRun();
	void stopRun();
	bool checkLogPath(const char* path);
	//此方法可能运行在多个线程中，内部实现注意是否安全
    void outputLog(Level level, const char* tag, const std::string& msg);
	bool writeLogToFile(const std::string &msg);
#if defined(_WIN32)
	void openLog();
    std::wstring getLogName();
    std::wstring getRotatedLogName();
	void rotateFileName();
#else
	void openLog();
    std::string getLogName();
    std::string getRotatedLogName();
	void rotateFileName();
#endif
	std::string getCurrentTimeString();
	
	void closeLog();
	
	int						  m_id;
	bool                      m_stopped;
#ifdef _WIN32
	HANDLE					  m_hThread;
	HANDLE					  m_event;
#else
	pthread_t                 m_hThread;
#endif

	int                              m_threadErrNo;
	std::list<std::string>           m_logList;
	MutexLock                      	*m_listMutex;
	FILE                            *m_fp;
	volatile uint64_t                m_logNumIn;
	volatile uint64_t                m_logNumOut;
	
#if defined(_WIN32)
    std::wstring m_filePath;
    std::wstring m_prefix;
    std::wstring m_name;
	int m_printer = SdkToAppInstallDir;
    bool m_isDebug = false;
#else
    int m_printer;
    bool m_isDebug;
    std::string m_filePath;
    std::string m_prefix;
    std::string m_name;
#endif

	ILog* mLoger;
public:
	friend class BaseLog;
	inline void L(Level level, const char* tag, const char* classname, const char* funcname)
	{
		std::ostringstream ows;
		ows << "[" << classname << "::" << funcname << "]";
		outputLog(level, tag, ows.str());
	}
	template<typename T>
	inline void L(Level level, const char* tag, const char* classname, const char* funcname, T value)
	{
		std::ostringstream ows;
		ows << "[" << classname << "::" << funcname << "]" << " " << value;
		outputLog(level, tag, ows.str());
	}
	template<typename T1, typename T2>
	inline void L(Level level, const char* tag, const char* classname, const char* funcname,
		T1 value1, T2 value2)
	{
		std::ostringstream ows;
		ows << "[" << classname << "::" << funcname << "]" << " " << value1 << " " << value2;
		outputLog(level, tag, ows.str());
	}

	template<typename T1, typename T2, typename T3>
	inline void L(Level level, const char* tag, const char* classname, const char* funcname,
		T1 value1, T2 value2, T3 value3)
	{
		std::ostringstream ows;
		ows << "[" << classname << "::" << funcname << "]" << " "<< value1 << " " << value2 << " " << value3;
		outputLog(level, tag, ows.str());
	}
	template<typename T1, typename T2, typename T3, typename T4>
	inline void L(Level level, const char* tag, const char* classname, const char* funcname,
		T1 value1, T2 value2, T3 value3, T4 value4)
	{
		std::ostringstream ows;
        ows << "[" << classname << "::" << funcname << "]" << " " << value1 << " " << value2 << " " << value3 << " " << value4;
		outputLog(level, tag, ows.str());
	}
	template<typename T1, typename T2, typename T3, typename T4, typename T5>
	inline void L(Level level, const char* tag, const char* classname, const char* funcname,
		T1 value1, T2 value2, T3 value3, T4 value4, T5 value5)
	{
		std::ostringstream ows;
		ows << "[" << classname << "::" << funcname << "]" << " "<< value1 << " " << value2 << " " << value3 << " " << value4 << " " << value5;
		outputLog(level, tag, ows.str());
	}
	template<typename T1, typename T2, typename T3, typename T4, typename T5, typename T6>
	inline void L(Level level, const char* tag, const char* classname, const char* funcname,
		T1 value1, T2 value2, T3 value3, T4 value4, T5 value5, T6 value6)
	{
		std::ostringstream ows;
		ows << "[" << classname << "::" << funcname << "]" << " " << value1 << " " << value2 << " " << value3 << " " << value4 << " " << value5 << " " << value6;
		outputLog(level, tag, ows.str());
	}
	template<typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7>
	inline void L(Level level, const char* tag, const char* classname, const char* funcname,
		T1 value1, T2 value2, T3 value3, T4 value4, T5 value5, T6 value6, T7 value7)
	{
		std::ostringstream ows;
		ows << "[" << classname << "::" << funcname << "]" << " " << value1 << " " << value2 << " " << value3 << " " << value4 << " " << value5 << " " << value6 << " " << value7;
		outputLog(level, tag, ows.str());
	}
	template<typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7, typename T8>
	inline void L(Level level, const char* tag, const char* classname, const char* funcname,
		T1 value1, T2 value2, T3 value3, T4 value4, T5 value5, T6 value6, T7 value7, T8 value8)
	{
		std::ostringstream ows;
		ows << "[" << classname << "::" << funcname << "]" << " " << value1 << " " << value2 << " " << value3 << " " << value4 << " " << value5 << " " << value6 << " " << value7 << " " << value8;
		outputLog(level, tag, ows.str());
	}
	template<typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7, typename T8, typename T9>
	inline void L(Level level, const char* tag, const char* classname, const char* funcname,
		T1 value1, T2 value2, T3 value3, T4 value4, T5 value5, T6 value6, T7 value7, T8 value8, T9 value9)
	{
		std::ostringstream ows;
		ows << "[" << classname << "::" << funcname << "]" << " " << value1 << " " << value2 << " " << value3 << " " << value4 << " " << value5 << " " << value6 << " " << value7 << " " << value8 << " " << value9;
		outputLog(level, tag, ows.str());
	}
	template<typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7, typename T8, typename T9, typename T10>
	inline void L(Level level, const char* tag, const char* classname, const char* funcname,
		T1 value1, T2 value2, T3 value3, T4 value4, T5 value5, T6 value6, T7 value7, T8 value8, T9 value9, T10 value10)
	{
		std::ostringstream ows;
		ows << "[" << classname << "::" << funcname << "]" << " " << value1 << " " << value2 << " " << value3 << " " << value4 << " " << value5 << " " << value6 << " " << value7 << " " << value8 << " " << value9 << " " << value10;
		outputLog(level, tag, ows.str());
	}
	
};
#if defined(_WIN32)
    std::string WStringToString(const std::wstring& ws);
    std::wstring StringToWString(const std::string& str);
#endif
NAMESPACE_BASEMOD_END
#endif //YYPROTO_LOGFILE_H
