//
// Created by HUTAO on 2017/6/27.
//

#ifndef YYPROTO_PACKET_EX_CPP_H
#define YYPROTO_PACKET_EX_CPP_H

#include "commondefine.h"
#include "packet.h"
#include "blockbuffer_ex.h"

NAMESPACE_BASEMOD_BEGIN
#define PACK_NULL_TLV_TAG (0xff)
#define PACK_TLV_COND(cond, tag) ((cond)?(tag):PACK_NULL_TLV_TAG)
	
#define PACK_BATCH_PUSH_SINGLE(n) *((T##n*)pData) = xhton(v##n); pData += sizeof(T##n);
#define PACK_BATCH_PUSH_VARTEMP_TEMP_ARGS2 typename T1, typename T2
#define PACK_BATCH_PUSH_VARTEMP_FUNC_ARGS2 T1 v1, T2 v2
#define PACK_BATCH_PUSH_VARTEMP_LEN_ADDER2 sizeof(T1) + sizeof(T2)
#define      PACK_BATCH_PUSH_VARTEMP_PUSH2 PACK_BATCH_PUSH_SINGLE(1) PACK_BATCH_PUSH_SINGLE(2)

#define PACK_BATCH_PUSH_VARTEMP_TEMP_ARGS3 PACK_BATCH_PUSH_VARTEMP_TEMP_ARGS2, typename T3
#define PACK_BATCH_PUSH_VARTEMP_FUNC_ARGS3 PACK_BATCH_PUSH_VARTEMP_FUNC_ARGS2, T3 v3
#define PACK_BATCH_PUSH_VARTEMP_LEN_ADDER3 PACK_BATCH_PUSH_VARTEMP_LEN_ADDER2 + sizeof(T3)
#define      PACK_BATCH_PUSH_VARTEMP_PUSH3      PACK_BATCH_PUSH_VARTEMP_PUSH2 PACK_BATCH_PUSH_SINGLE(3)

#define PACK_BATCH_PUSH_VARTEMP_TEMP_ARGS4 PACK_BATCH_PUSH_VARTEMP_TEMP_ARGS3, typename T4
#define PACK_BATCH_PUSH_VARTEMP_FUNC_ARGS4 PACK_BATCH_PUSH_VARTEMP_FUNC_ARGS3, T4 v4
#define PACK_BATCH_PUSH_VARTEMP_LEN_ADDER4 PACK_BATCH_PUSH_VARTEMP_LEN_ADDER3 + sizeof(T4)
#define      PACK_BATCH_PUSH_VARTEMP_PUSH4      PACK_BATCH_PUSH_VARTEMP_PUSH3 PACK_BATCH_PUSH_SINGLE(4)

#define PACK_BATCH_PUSH_VARTEMP_TEMP_ARGS5 PACK_BATCH_PUSH_VARTEMP_TEMP_ARGS4, typename T5
#define PACK_BATCH_PUSH_VARTEMP_FUNC_ARGS5 PACK_BATCH_PUSH_VARTEMP_FUNC_ARGS4, T5 v5
#define PACK_BATCH_PUSH_VARTEMP_LEN_ADDER5 PACK_BATCH_PUSH_VARTEMP_LEN_ADDER4 + sizeof(T5)
#define      PACK_BATCH_PUSH_VARTEMP_PUSH5      PACK_BATCH_PUSH_VARTEMP_PUSH4 PACK_BATCH_PUSH_SINGLE(5)

#define PACK_BATCH_PUSH_VARTEMP_TEMP_ARGS6 PACK_BATCH_PUSH_VARTEMP_TEMP_ARGS5, typename T6
#define PACK_BATCH_PUSH_VARTEMP_FUNC_ARGS6 PACK_BATCH_PUSH_VARTEMP_FUNC_ARGS5, T6 v6
#define PACK_BATCH_PUSH_VARTEMP_LEN_ADDER6 PACK_BATCH_PUSH_VARTEMP_LEN_ADDER5 + sizeof(T6)
#define      PACK_BATCH_PUSH_VARTEMP_PUSH6      PACK_BATCH_PUSH_VARTEMP_PUSH5 PACK_BATCH_PUSH_SINGLE(6)

#define PACK_BATCH_PUSH_VARTEMP_TEMP_ARGS7 PACK_BATCH_PUSH_VARTEMP_TEMP_ARGS6, typename T7
#define PACK_BATCH_PUSH_VARTEMP_FUNC_ARGS7 PACK_BATCH_PUSH_VARTEMP_FUNC_ARGS6, T7 v7
#define PACK_BATCH_PUSH_VARTEMP_LEN_ADDER7 PACK_BATCH_PUSH_VARTEMP_LEN_ADDER6 + sizeof(T7)
#define      PACK_BATCH_PUSH_VARTEMP_PUSH7      PACK_BATCH_PUSH_VARTEMP_PUSH6 PACK_BATCH_PUSH_SINGLE(7)

#define PACK_BATCH_PUSH_VARTEMP_TEMP_ARGS8 PACK_BATCH_PUSH_VARTEMP_TEMP_ARGS7, typename T8
#define PACK_BATCH_PUSH_VARTEMP_FUNC_ARGS8 PACK_BATCH_PUSH_VARTEMP_FUNC_ARGS7, T8 v8
#define PACK_BATCH_PUSH_VARTEMP_LEN_ADDER8 PACK_BATCH_PUSH_VARTEMP_LEN_ADDER7 + sizeof(T8)
#define      PACK_BATCH_PUSH_VARTEMP_PUSH8      PACK_BATCH_PUSH_VARTEMP_PUSH7 PACK_BATCH_PUSH_SINGLE(8)

#define PACK_BATCH_PUSH_VARTEMP_TEMP_ARGS9 PACK_BATCH_PUSH_VARTEMP_TEMP_ARGS8, typename T9
#define PACK_BATCH_PUSH_VARTEMP_FUNC_ARGS9 PACK_BATCH_PUSH_VARTEMP_FUNC_ARGS8, T9 v9
#define PACK_BATCH_PUSH_VARTEMP_LEN_ADDER9 PACK_BATCH_PUSH_VARTEMP_LEN_ADDER8 + sizeof(T9)
#define      PACK_BATCH_PUSH_VARTEMP_PUSH9      PACK_BATCH_PUSH_VARTEMP_PUSH8 PACK_BATCH_PUSH_SINGLE(9)

#define PACK_BATCH_PUSH_VARTEMP_TEMP_ARGS10 PACK_BATCH_PUSH_VARTEMP_TEMP_ARGS9, typename T10
#define PACK_BATCH_PUSH_VARTEMP_FUNC_ARGS10 PACK_BATCH_PUSH_VARTEMP_FUNC_ARGS9, T10 v10
#define PACK_BATCH_PUSH_VARTEMP_LEN_ADDER10 PACK_BATCH_PUSH_VARTEMP_LEN_ADDER9 + sizeof(T10)
#define      PACK_BATCH_PUSH_VARTEMP_PUSH10      PACK_BATCH_PUSH_VARTEMP_PUSH9 PACK_BATCH_PUSH_SINGLE(10)

#define PACK_BATCH_PUSH_VARTEMP_TEMP_ARGS11 PACK_BATCH_PUSH_VARTEMP_TEMP_ARGS10, typename T11
#define PACK_BATCH_PUSH_VARTEMP_FUNC_ARGS11 PACK_BATCH_PUSH_VARTEMP_FUNC_ARGS10, T11 v11
#define PACK_BATCH_PUSH_VARTEMP_LEN_ADDER11 PACK_BATCH_PUSH_VARTEMP_LEN_ADDER10 + sizeof(T11)
#define      PACK_BATCH_PUSH_VARTEMP_PUSH11      PACK_BATCH_PUSH_VARTEMP_PUSH10 PACK_BATCH_PUSH_SINGLE(11)
	

#define UNPACK_BATCH_POP_SINGLE(n) v##n = xntoh(*((T##n*)pData)); pData += sizeof(T##n);

#define UNPACK_BATCH_POP_VARTEMP_TEMP_ARGS2 typename T1, typename T2
#define UNPACK_BATCH_POP_VARTEMP_FUNC_ARGS2 T1& v1, T2& v2
#define UNPACK_BATCH_POP_VARTEMP_POP2 UNPACK_BATCH_POP_SINGLE(1) UNPACK_BATCH_POP_SINGLE(2)

#define UNPACK_BATCH_POP_VARTEMP_TEMP_ARGS3 UNPACK_BATCH_POP_VARTEMP_TEMP_ARGS2, typename T3
#define UNPACK_BATCH_POP_VARTEMP_FUNC_ARGS3 UNPACK_BATCH_POP_VARTEMP_FUNC_ARGS2, T3& v3
#define UNPACK_BATCH_POP_VARTEMP_POP3       UNPACK_BATCH_POP_VARTEMP_POP2 UNPACK_BATCH_POP_SINGLE(3)

#define UNPACK_BATCH_POP_VARTEMP_TEMP_ARGS4 UNPACK_BATCH_POP_VARTEMP_TEMP_ARGS3, typename T4
#define UNPACK_BATCH_POP_VARTEMP_FUNC_ARGS4 UNPACK_BATCH_POP_VARTEMP_FUNC_ARGS3, T4& v4
#define UNPACK_BATCH_POP_VARTEMP_POP4       UNPACK_BATCH_POP_VARTEMP_POP3 UNPACK_BATCH_POP_SINGLE(4)

#define UNPACK_BATCH_POP_VARTEMP_TEMP_ARGS5 UNPACK_BATCH_POP_VARTEMP_TEMP_ARGS4, typename T5
#define UNPACK_BATCH_POP_VARTEMP_FUNC_ARGS5 UNPACK_BATCH_POP_VARTEMP_FUNC_ARGS4, T5& v5
#define UNPACK_BATCH_POP_VARTEMP_POP5       UNPACK_BATCH_POP_VARTEMP_POP4 UNPACK_BATCH_POP_SINGLE(5)

#define UNPACK_BATCH_POP_VARTEMP_TEMP_ARGS6 UNPACK_BATCH_POP_VARTEMP_TEMP_ARGS5, typename T6
#define UNPACK_BATCH_POP_VARTEMP_FUNC_ARGS6 UNPACK_BATCH_POP_VARTEMP_FUNC_ARGS5, T6& v6
#define UNPACK_BATCH_POP_VARTEMP_POP6       UNPACK_BATCH_POP_VARTEMP_POP5 UNPACK_BATCH_POP_SINGLE(6)

#define UNPACK_BATCH_POP_VARTEMP_TEMP_ARGS7 UNPACK_BATCH_POP_VARTEMP_TEMP_ARGS6, typename T7
#define UNPACK_BATCH_POP_VARTEMP_FUNC_ARGS7 UNPACK_BATCH_POP_VARTEMP_FUNC_ARGS6, T7& v7
#define UNPACK_BATCH_POP_VARTEMP_POP7       UNPACK_BATCH_POP_VARTEMP_POP6 UNPACK_BATCH_POP_SINGLE(7)

#define UNPACK_BATCH_POP_VARTEMP_TEMP_ARGS8 UNPACK_BATCH_POP_VARTEMP_TEMP_ARGS7, typename T8
#define UNPACK_BATCH_POP_VARTEMP_FUNC_ARGS8 UNPACK_BATCH_POP_VARTEMP_FUNC_ARGS7, T8& v8
#define UNPACK_BATCH_POP_VARTEMP_POP8       UNPACK_BATCH_POP_VARTEMP_POP7 UNPACK_BATCH_POP_SINGLE(8)

#define UNPACK_BATCH_POP_VARTEMP_TEMP_ARGS9 UNPACK_BATCH_POP_VARTEMP_TEMP_ARGS8, typename T9
#define UNPACK_BATCH_POP_VARTEMP_FUNC_ARGS9 UNPACK_BATCH_POP_VARTEMP_FUNC_ARGS8, T9& v9
#define UNPACK_BATCH_POP_VARTEMP_POP9       UNPACK_BATCH_POP_VARTEMP_POP8 UNPACK_BATCH_POP_SINGLE(9)

#define UNPACK_BATCH_POP_VARTEMP_TEMP_ARGS10 UNPACK_BATCH_POP_VARTEMP_TEMP_ARGS9, typename T10
#define UNPACK_BATCH_POP_VARTEMP_FUNC_ARGS10 UNPACK_BATCH_POP_VARTEMP_FUNC_ARGS9, T10& v10
#define UNPACK_BATCH_POP_VARTEMP_POP10       UNPACK_BATCH_POP_VARTEMP_POP9 UNPACK_BATCH_POP_SINGLE(10)

#define UNPACK_BATCH_POP_VARTEMP_TEMP_ARGS11 UNPACK_BATCH_POP_VARTEMP_TEMP_ARGS10, typename T11
#define UNPACK_BATCH_POP_VARTEMP_FUNC_ARGS11 UNPACK_BATCH_POP_VARTEMP_FUNC_ARGS10, T11& v11
#define UNPACK_BATCH_POP_VARTEMP_POP11       UNPACK_BATCH_POP_VARTEMP_POP10 UNPACK_BATCH_POP_SINGLE(11)
	

#define PACK_BATCH_PUSH_FINAL(z) \
template <PACK_BATCH_PUSH_VARTEMP_TEMP_ARGS##z>\
PackX & batch_prim_push(PACK_BATCH_PUSH_VARTEMP_FUNC_ARGS##z)\
{\
	size_t uLen = PACK_BATCH_PUSH_VARTEMP_LEN_ADDER##z;\
	char * pData = m_buffer.pre_batch_append(uLen);\
	PACK_BATCH_PUSH_VARTEMP_PUSH##z\
	m_buffer.post_batch_append(uLen);\
	return *this; \
}

#define UNPACK_BATCH_POP_FINAL(z) \
template <UNPACK_BATCH_POP_VARTEMP_TEMP_ARGS##z>\
bool batch_prim_pop(UNPACK_BATCH_POP_VARTEMP_FUNC_ARGS##z) const\
{\
	const char * pData = m_data;\
	UNPACK_BATCH_POP_VARTEMP_POP##z\
	size_t uSizeDelta = pData - m_data;\
    if (UNLIKELY(uSizeDelta > m_size))\
    {\
        m_bUnpackError = true;\
        return false;\
    }\
	m_data = pData;\
	m_size -= uSizeDelta;\
    return true;\
}

	class PackBufferX{
	public:
		PackBufferX(PackBuffer& objPB) :bbx(&(objPB.bb)){}
		
		char * data() {
			return bbx.data();
		}
		size_t size() const {
			return bbx.size();
		}
		
		bool resize(size_t n) {
            return bbx.resize(n);
		}
		
		bool resize_nothrow(size_t n) {
			return bbx.resize(n);
		}
		
		bool append(const char * data, size_t size) {
            return bbx.append(data, size);
		}
		bool append(const char * data) {
			return append(data, ::strlen(data));
		}
		
		template <typename PrimType>
		bool append_prim(PrimType n)
		{
            return (bbx.append_prim(n));
		}
		
		char * pre_batch_append(size_t n)
		{
			char * p = bbx.pre_batch_append(n);
			if (p)
				return p;
			return NULL;
		}
		
		void post_batch_append(size_t n)
		{
			bbx.post_batch_append(n);
		}
		
		bool replace(size_t pos, const char * rep, size_t n) {
			return bbx.replace(pos, rep, n);
		}
		
		template <typename PrimType>
		bool replace_prim(size_t pos, PrimType n)
		{
			return bbx.replace_prim(pos, n);
		}
		
		bool reserve(size_t n) {
			return (bbx.reserve(n));

		}
	
	private:
		PackBuffer::BB::XSoxBB bbx;
	};
	
	class PackX
	{
	private:
		PackX (const PackX & o);
		PackX & operator = (const PackX& o);
	
	public:
		uint8_t xhton(uint8_t i8) { return i8; }
		uint16_t xhton(uint16_t i16) { return XHTONS(i16); }
		uint32_t xhton(uint32_t i32) { return XHTONL(i32); }
		uint64_t xhton(uint64_t i64) { return XHTONLL(i64); }
		
		PackX(Pack* pPack) : m_pPack(pPack), m_buffer(pPack->m_buffer),
		m_offset(pPack->m_offset), m_bPackError(pPack->m_bPackError)
		{}
		
		// access this packet.
		char * data()       { return m_buffer.data() + m_offset; }
		const char * data()  const { return m_buffer.data() + m_offset; }
		size_t size() const { return m_buffer.size() - m_offset; }
		
		size_t bufsize() const { return m_buffer.size(); }
		
		PackX & push(const void * s, size_t n) {
            if(!m_buffer.append((const char *)s, n))
            {
                m_bPackError = true;
            }
            return *this;
        }
		PackX & push(const void * s){
            if(!m_buffer.append((const char *)s))
            {
                 m_bPackError = true;
            }
            return *this;
        }
		
		PACK_BATCH_PUSH_FINAL(2)
		PACK_BATCH_PUSH_FINAL(3)
		PACK_BATCH_PUSH_FINAL(4)
		PACK_BATCH_PUSH_FINAL(5)
		PACK_BATCH_PUSH_FINAL(6)
		PACK_BATCH_PUSH_FINAL(7)
		PACK_BATCH_PUSH_FINAL(8)
		PACK_BATCH_PUSH_FINAL(9)
		PACK_BATCH_PUSH_FINAL(10)
		PACK_BATCH_PUSH_FINAL(11)
		
		//用于压入optional field. Tag 0xff为保留tag，当Tag==0xff时，字段会被跳过
		//必须按uTag从小到大的顺序调用，且value长度不超过16MB
		//example: p.TLV(1, m_uInt1).TLV(PACK_TLV_COND(m_bHasTag2,2), m_uInt2).TLV(PACK_TLV_COND(m_uInt3>0,3), m_uInt3).TLV_finish();
		template <typename T>
		PackX & TLV(uint8_t uTag, const T& v)
		{
			if (m_bPackError == true)
			{
				return *this;
			}
			if (PACK_NULL_TLV_TAG == uTag) return *this;
			size_t uPos = m_buffer.size();
			push_uint32(0); //placeholder
			*this << v;
			size_t uSize = m_buffer.size() - uPos; //placeholder长度计入，方便unpack时处理
			if (UNLIKELY((uSize & 0xffffff) != uSize))
			{
				m_bPackError = true;
				return *this;
			}
			uint32_t uTagSize = (uTag << 24) | (uSize & 0xffffff); //255 tags + 16M size
			m_buffer.replace_prim(uPos, uTagSize); //不能直接用原指针，可能marshal时重新分配了buffer
			return *this;
		}
		
		//通过bExist判断是否value是否存在
		template <typename T>
		PackX & TLV(bool bExist, uint8_t uTag, const T& v)
		{
			if (m_bPackError == true)
			{
				return *this;
			}
			return bExist?TLV(uTag, v):*this;
		}
		
		//指针版本，通过指针是否为空判断value存在
		template <typename T>
		PackX & TLVP(uint8_t uTag, T* const& ptr)
		{
			if (m_bPackError == true)
			{
				return *this;
			}
			//T* _ptr = *ptr;
			return ptr?TLV(uTag, *ptr):*this;
		}
		
		//在一系列push_TLV后必须调用，避免解包误用后续的数据作为tlv解析
		PackX & TLV_finish()
		{
			if (m_bPackError == true)
			{
				return *this;
			}
			return push_uint32(0xff787878); //end flag
		}
		
		
		PackX & push_uint8(uint8_t u8)	 {
            if(!m_buffer.append_prim(u8)) m_bPackError = true;
            return *this;
        }
		PackX & push_uint16(uint16_t u16) {
            if(!m_buffer.append_prim(XHTONS(u16))) m_bPackError = true;
            return *this;
        }
		PackX & push_uint32(uint32_t u32) {
            if(!m_buffer.append_prim(XHTONL(u32))) m_bPackError = true;
            return *this;
        }
		PackX & push_uint64(uint64_t u64) {
            if(!m_buffer.append_prim(XHTONLL(u64))) m_bPackError = true;
            return *this;
        }
		
		PackX & push_int16(int16_t i16) {
            if(!m_buffer.append_prim(XHTONS_SIGN(i16))) m_bPackError = true;
            return *this;
        }
		PackX & push_int32(int32_t i32) {
            if(!m_buffer.append_prim(XHTONL_SIGN(i32))) m_bPackError = true;
            return *this;
        }
		PackX & push_int64(int64_t i64) {
            if(!m_buffer.append_prim(XHTONLL_SIGN(i64))) m_bPackError = true;
            return *this;
        }
		
		PackX & push_float(float f) {
            if(!m_buffer.append_prim(XHTONF(f))) m_bPackError = true;
            return *this;
        }
		PackX & push_double(double d) {
            if(!m_buffer.append_prim(XHTOND(d))) m_bPackError = true;
            return *this;
        }
		
		PackX & push_varstr(const Varstr& vs)     { return push_varstr(vs.data(), vs.size()); }
		PackX & push_varstr(const void * s)        { return push_varstr(s, strlen((const char *)s)); }
		PackX & push_varstr(const std::string & s) { return push_varstr(s.data(), s.size()); }
		PackX & push_varstr(const void * s, size_t len)
		{
			if (len > 0xFFFF)
			{
				m_bPackError = true;
				len = 0;
			}
			return push_uint16(uint16_t(len)).push(s, len);
		}
		PackX & push_varstr32(const void * s, size_t len)
		{
			if (len > 0xFFFFFFFF)
			{
				m_bPackError = true;
				len = 0;
			}
			return push_uint32(uint32_t(len)).push(s, len);
		}

		PackX & push_varwstring32(const std::wstring &ws){
			size_t len = ws.size() * 2;
			return push_uint32((uint32_t)len).push(ws.data(), len);
		}
		

	public:
		// replace. pos is the buffer offset, not this Pack m_offset
		size_t replace(size_t pos, const void * data, size_t rplen) {
			m_buffer.replace(pos, (const char*)data, rplen);
			return pos + rplen;
		}
		size_t replace_uint8(size_t pos, uint8_t u8)    { m_buffer.replace_prim(pos, u8); return pos+sizeof(u8);}
		size_t replace_uint16(size_t pos, uint16_t u16) {
			m_buffer.replace_prim(pos, XHTONS(u16));
			return pos+sizeof(u16);
		}
		size_t replace_uint32(size_t pos, uint32_t u32) {
			m_buffer.replace_prim(pos, XHTONL(u32));
			return pos+sizeof(u32);
		}
		Pack& SoxPack()
		{
			return *m_pPack;
		}

		bool isPackError() const
		{
			return m_bPackError;
		}
	protected:
		Pack* m_pPack;
		mutable PackBufferX m_buffer;
		size_t& m_offset;
		bool m_bPackError;
	};
	
	class UnpackX
	{
	public:
		uint8_t xntoh(uint8_t i8) const { return i8; }
		uint16_t xntoh(uint16_t i16) const { return XNTOHS(i16); }
		uint32_t xntoh(uint32_t i32) const { return XNTOHL(i32); }
		uint64_t xntoh(uint64_t i64) const { return XNTOHLL(i64); }
		
		UnpackX(const Unpack* pUnpack)
        : m_pUnpack(pUnpack)
        , m_data(pUnpack->m_data)
        , m_size(pUnpack->m_size)
        , m_vendsizetmp(0)
        , m_bUnpackError(pUnpack->m_bUnpackError)
		{}
		
        void reset(const void * data, size_t size) const
        {
            m_data = (const char *)data;
            m_size = size;
        }
		
		operator const void *() const { return m_data; }
		bool operator!() const  { return (NULL == m_data); }
		
		//直接内存复制，要求字段在字节流的顺序和在消息定义(内存)中的顺序一致
		template <typename TypeFirst, typename TypeLast>
		bool raw_copy(TypeFirst* p1, TypeLast* p2) const
		{
#ifdef NO_ENDIAN_CONV
		//printf("", p1);
		size_t uSize = (char *)p2 - (char *)p1 + sizeof(TypeLast);
		if (m_size < uSize)
		{
			m_bUnpackError = true;
			return false;
		}
		memcpy((char *)p1, m_data, uSize);
		m_data += uSize; m_size -= uSize;
		return true;
#else
			return false;
#endif
		}
		
		UNPACK_BATCH_POP_FINAL(2)
		UNPACK_BATCH_POP_FINAL(3)
		UNPACK_BATCH_POP_FINAL(4)
		UNPACK_BATCH_POP_FINAL(5)
		UNPACK_BATCH_POP_FINAL(6)
		UNPACK_BATCH_POP_FINAL(7)
		UNPACK_BATCH_POP_FINAL(8)
		UNPACK_BATCH_POP_FINAL(9)
		UNPACK_BATCH_POP_FINAL(10)
		UNPACK_BATCH_POP_FINAL(11)
		
		template <typename T>
		void _TLVSetValHelper(T& v, uint32_t uCurValSize) const
		{
		}
		
		void _TLVSetValHelper(uint32_t& v, uint32_t uCurValSize) const
		{
			v = uCurValSize;
		}
		
		//bExist返回value是否存在
		template <typename T>
		const UnpackX & TLV(bool& bExist, uint8_t uTag, T& v) const
		{
            if (m_bUnpackError == true)
            {
                return *this;
            }
			uint32_t uTagSize = peek_uint32();
			uint8_t uCurTag = (uTagSize >> 24) & 0xff;
			uint32_t uCurValSize = (uTagSize & 0xffffff);
			bExist = false;
			while (uCurTag < uTag)
			{
				if (UNLIKELY(m_size < uCurValSize))
                {
                    m_bUnpackError = true;
                    return *this;
                }
				m_data += uCurValSize; m_size -= uCurValSize;
				uTagSize = peek_uint32();
				uCurTag = (uTagSize >> 24) & 0xff;
				uCurValSize = (uTagSize & 0xffffff);
			}
			if(UNLIKELY(PACK_NULL_TLV_TAG == uCurTag))
			{
				//v = uCurValSize;
				_TLVSetValHelper(v, uCurValSize);
				m_vendsizetmp = 0;
				bExist = true;
				return *this;
			}
			if(uCurTag == uTag)
			{
				const char * data_bak = m_data;
				size_t size_bak = m_size;
				m_data += 4u; m_size -= 4u;
				m_vendsizetmp = size_bak - uCurValSize;
				*this >> v;
				m_data = data_bak + uCurValSize;
				m_size = size_bak - uCurValSize;
				bExist = true;
			}
			return *this;
		}
		
		template <typename T>
		const UnpackX & TLV(uint8_t uTag, T& v) const
		{
            if (m_bUnpackError == true)
            {
                return *this;
            }
			bool bSink;
			return TLV(bSink, uTag, v);
		}
		
		//ptr是否为空判断value是否存在（调用者必须确保传入的ptr为NULL）
		//当传入的ptr不为空，则需要在调用前将其指向的内容初始化为默认值(无效值)，以此判断是否解析了有效的value
		template <typename T>
		const UnpackX & TLVP(uint8_t uTag, T*& ptr) const
		{
            if (m_bUnpackError == true)
            {
                return *this;
            }
			uint32_t uTagSize = peek_uint32();
			uint8_t uCurTag = (uTagSize >> 24) & 0xff;
			uint32_t uCurValSize = (uTagSize & 0xffffff);
			
			while (uCurTag < uTag)
			{
				if (UNLIKELY(m_size < uCurValSize))
                {
                    m_bUnpackError = true;
                    return *this;
                }
				m_data += uCurValSize; m_size -= uCurValSize;
				uTagSize = peek_uint32();
				uCurTag = (uTagSize >> 24) & 0xff;
				uCurValSize = (uTagSize & 0xffffff);
			}
			if(UNLIKELY(PACK_NULL_TLV_TAG == uCurTag))
			{
				return *this;
			}
			if(uCurTag == uTag)
			{
				const char * data_bak = m_data;
				size_t size_bak = m_size;
				m_data += 4u; m_size -= 4u;
				m_vendsizetmp = size_bak - uCurValSize;
				if (LIKELY(!ptr)) ptr = new T;
				*this >> *ptr;
				m_data = data_bak + uCurValSize;
				m_size = size_bak - uCurValSize;
			}
			return *this;
		}
		
		//在一系列push_TLV后必须调用，避免解包误用后续的数据作为tlv解析
		const UnpackX & TLV_finish() const
		{
            if (m_bUnpackError == true)
            {
                return *this;
            }
			uint32_t uDummy = 0;
			TLV(0xff, uDummy);
			if (UNLIKELY(uDummy != 0x787878))
            {
                m_bUnpackError = true;
            }
			return *this;
		}
		
		std::string pop_varstr() const {
			Varstr vs = pop_varstr_ptr();
            if(m_bUnpackError)
            {
                return "";
            }
			return std::string(vs.data(), vs.size());
		}
		
		std::string pop_varstr32() const {
			Varstr vs = pop_varstr32_ptr();
            if(m_bUnpackError)
            {
                return "";
            }
			return std::string(vs.data(), vs.size());
		}
		
		RawBasicString pop_varstr_raw() const{
			Varstr vs = pop_varstr_ptr();
            if(m_bUnpackError)
            {
                return RawBasicString("", 0);
            }
			return RawBasicString(vs.data(), vs.size());
		}
		
		RawBasicString pop_varstr32_raw() const {
			Varstr vs = pop_varstr32_ptr();
            if(m_bUnpackError)
            {
                return RawBasicString("", 0);
            }
			return RawBasicString(vs.data(), vs.size());
		}
		
		std::wstring pop_varwstring32() const{
			Varstr vs = pop_varstr32_ptr();
            if(m_bUnpackError)
            {
                return L"";
            }
			return std::wstring((wchar_t *)vs.data(), vs.size() / 2);
		}

		std::string pop_fetch(size_t k) const {
            if(m_bUnpackError)
            {
                return "";
            }
			return std::string(pop_fetch_ptr(k), k);
		}
		
		void finish() const {
            if (!empty()) {
                m_bUnpackError = true;
            };
		}
		
		uint8_t pop_uint8() const{
			if (UNLIKELY(m_size < 1u))
            {
                m_bUnpackError = true;
                return 0;
            }
			
			uint8_t i8 = 0;
			memcpy(&i8, m_data, sizeof(uint8_t));
			
			m_data += 1u; m_size -= 1u;
			return i8;
		}
		
		uint16_t pop_uint16() const{
			if (UNLIKELY(m_size < 2u))
            {
                m_bUnpackError = true;
                return 0;
            }
			
			uint16_t i16 = 0;
			memcpy(&i16, m_data, sizeof(uint16_t));
			//i16 = xntohs(i16);
			m_data += 2u; m_size -= 2u;
			return XNTOHS(i16);
		}
		
		uint32_t pop_uint32() const{
			if (UNLIKELY(m_size < 4u))
            {
                m_bUnpackError = true;
                return 0;
            }

			uint32_t i32 = 0;
			memcpy(&i32, m_data, sizeof(uint32_t));
			//i32 = xntohl(i32);
			m_data += 4u; m_size -= 4u;
			return XNTOHL(i32);
		}
		
		/**
		 * 为了能在unmarshal_container时，取到容器的size，并reserve内存而添加
		 */
		uint32_t peek_uint32() const {
			if (UNLIKELY(m_size < 4u))
            {
                m_bUnpackError = true;
                return 0;
            }
			uint32_t i32 = 0;
			memcpy(&i32, m_data, sizeof(uint32_t));
			//i32 = xntohl(i32);
			return XNTOHL(i32);
		}
		
		uint64_t pop_uint64() const {
			if (UNLIKELY(m_size < 8u))
            {
                m_bUnpackError = true;
                return 0;
            }
			//NDK无法处理long long类型的边界对其
			uint64_t i64 = 0;
			memcpy(&i64, m_data, sizeof(uint64_t));
			//i64 = xntohll(i64);
			m_data += 8u;
			m_size -= 8u;
			return XNTOHLL(i64);
		}
		
		int16_t pop_int16() const{
			if (UNLIKELY(m_size < 2u))
            {
                m_bUnpackError = true;
                return 0;
            }
			
			int16_t i16 = 0;
			memcpy(&i16, m_data, sizeof(int16_t));
			//i16 = xntohs(i16);
			m_data += 2u; m_size -= 2u;
			return XNTOHS_SIGN(i16);
		}
		
		int32_t pop_int32() const{
			if (UNLIKELY(m_size < 4u))
            {
                m_bUnpackError = true;
                return 0;
            }
			int32_t i32 = 0;
			memcpy(&i32, m_data, sizeof(int32_t));
			//i32 = xntohl(i32);
			m_data += 4u; m_size -= 4u;
			return XNTOHL_SIGN(i32);
		}
		
		int64_t pop_int64() const {
			if (UNLIKELY(m_size < 8u))
            {
                m_bUnpackError = true;
                return 0;
            }
			//NDK无法处理long long类型的边界对其
			int64_t i64 = 0;
			memcpy(&i64, m_data, sizeof(int64_t));
			//i64 = xntohll(i64);
			m_data += 8u; m_size -= 8u;
			return XNTOHLL_SIGN(i64);
		}
		
		float pop_float() const{
			if (UNLIKELY(m_size < 4u))
            {
                m_bUnpackError = true;
                return 0.0;
            }
			float f = 0;
			memcpy(&f, m_data, sizeof(float));
			
			m_data += 4u; m_size -= 4u;
			return XNTOHL_SIGN(f);
		}
		double pop_double() const{
			if (UNLIKELY(m_size < 8u))
            {
                m_bUnpackError = true;
                return 0.0;
            }
			double f = 0;
			memcpy(&f, m_data, sizeof(double));
			//i32 = xntohl(i32);
			m_data += 8u; m_size -= 8u;
			return XNTOHL_SIGN(f);
		}
		
		Varstr pop_varstr_ptr() const {
			Varstr vs;
			vs.m_size = pop_uint16();
			vs.m_data = pop_fetch_ptr(vs.m_size);
			return vs;
		}
		
		Varstr pop_varstr32_ptr() const {
			Varstr vs;
			vs.m_size = pop_uint32();
			vs.m_data = pop_fetch_ptr(vs.m_size);
			return vs;
		}
		
		const char * pop_fetch_ptr(size_t k) const {
			if (UNLIKELY(m_size < k))
			{
                m_bUnpackError = true;
                k = m_size;
			}
			
			const char * p = m_data;
			m_data += k; m_size -= k;
			return p;
		}
		
		bool empty() const	  { return m_size == 0; }
		const char * data() const { return m_data; }
		size_t size() const	  { return m_size; }
		size_t vendsize() const	  { return m_vendsizetmp; }
		
		const Unpack& SoxUnack() const
		{
			return *m_pUnpack;
		}
        bool isUnpackError() const
        {
            return m_bUnpackError;
        }
	private:
		mutable const Unpack * m_pUnpack;
		const char *&m_data;
		size_t& m_size;
		mutable size_t m_vendsizetmp; //用于TLV的value判断边界。value的unmarshable应在开始复制一份使用，以免value重入TLV()使该值发生变化。
    protected:
        mutable bool m_bUnpackError;
	};
	
	//Marshallable的扩展，加入安全的边界处理和版本号字段。VSMarshallable可利用边界或版本号实现一定扩展性
	struct VSMarshallable : public Marshallable
	{
		size_t m_vendpos; //用于判断边界
		mutable uint8_t m_vver; //用户可用来标识协议版本(0~15)
		
		VSMarshallable() : m_vendpos(0), m_vver(0) {}
		
		//设置协议版本
		void SetVVer(uint8_t v) const//0~15
		{
			m_vver = v;
		}
		
		//判断边界
		bool IsNotEnd(const Unpack & p)
		{
			return (p.size() > m_vendpos);
		}
		
		//用户协议编解码实现，跟Marshallable的marshal/unmarshal用法一样
		virtual void vsmarshal(PackX &) const = 0;
		virtual void vsunmarshal(const UnpackX &) = 0;
		
		//真正的编解码入口
		virtual void marshal(PackX & p) const {
			size_t uPos = p.bufsize();
			p.push_uint32(0); //placeholder
			vsmarshal(p);
			if (p.isPackError())
			{
				return;
			}
			size_t uSize = (m_vver << 28) | ((p.bufsize() - uPos - 4) & 0xfffffff); //placeholder长度不计入
			//size_t uSize = (p.bufsize() - uPos - 4);
			p.replace_uint32(uPos, (uint32_t)uSize);
		}
		
		virtual void unmarshal(const UnpackX &p) {
            if (p.isUnpackError())
            {
                return ;
            }
			uint32_t uSize = p.pop_uint32();
			m_vver = uSize >> 28;
			uSize &= 0xfffffff;
			m_vendpos = p.size() - uSize;
			const char * data_bak = p.data();
			size_t size_bak = p.size();
			vsunmarshal(p);
            if (p.isUnpackError())
            {
                return ;
            }
			p.reset(data_bak + uSize, size_bak - uSize);
		}
		
		virtual void marshal(Pack & p_) const {
			if (p_.isPackError())
			{
				return;
			}
			PackX p(&p_);
			VSMarshallable::marshal(p);
			if (p.isPackError())
			{
				p_.setPackError();
			}
		}
		
		virtual void unmarshal(const Unpack & p_) {
            if (p_.isUnpackError())
            {
                return;
            }
			UnpackX p(&p_);
			VSMarshallable::unmarshal(p);
            if (p.isUnpackError())
            {
                p_.setUnpackError();
            }
		}
		
	};
	inline PackX& operator << (PackX & p, const Marshallable & m)
	{
		m.marshal(p.SoxPack());
		return p;
	}
	
	inline const UnpackX& operator >> (const UnpackX & p, const Marshallable & m)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		const_cast<Marshallable &>(m).unmarshal(p.SoxUnack());
		return p;
	}
	inline PackX& operator << (PackX & p, const VSMarshallable & m)
	{
		m.marshal(p);
		return p;
	}
	
	inline const UnpackX& operator >> (const UnpackX & p, const VSMarshallable & m)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		const_cast<VSMarshallable &>(m).unmarshal(p);
		return p;
	}

	// base type helper
	inline PackX & operator << (PackX & p, bool sign)
	{
		p.push_uint8(sign ? 1 : 0);
		return p;
	}
	
	inline PackX & operator << (PackX & p, uint8_t  i8)
	{
		p.push_uint8(i8);
		return p;
	}
	
	inline PackX & operator << (PackX & p, uint16_t  i16)
	{
		p.push_uint16(i16);
		return p;
	}
	
	inline PackX & operator << (PackX & p, uint32_t  i32)
	{
		p.push_uint32(i32);
		return p;
	}
	inline PackX & operator << (PackX & p, uint64_t  i64)
	{
		p.push_uint64(i64);
		return p;
	}
	
	inline PackX & operator << (PackX & p, int16_t  i16)
	{
		p.push_int16(i16);
		return p;
	}
	
	inline PackX & operator << (PackX & p, int32_t  i32)
	{
		p.push_int32(i32);
		return p;
	}
	inline PackX & operator << (PackX & p, int64_t  i64)
	{
		p.push_int64(i64);
		return p;
	}
	
	inline PackX & operator << (PackX & p, float  f)
	{
		p.push_float(f);
		return p;
	}
	inline PackX & operator << (PackX & p, double  d)
	{
		p.push_double(d);
		return p;
	}
	
	inline PackX & operator << (PackX & p, const std::string & str)
	{
		p.push_varstr(str);
		return p;
	}
	
	inline PackX & operator << (PackX & p, const RawBasicString & str)
	{
		p.push_varstr32(str.data(), str.size());
		return p;
	}
	
	inline PackX & operator << (PackX & p, const std::wstring & str)
	{
		p.push_varwstring32(str);
		return p;
	}
	
	inline PackX & operator << (PackX & p, const Varstr& pstr)
	{
		p.push_varstr(pstr);
		return p;
	}
	
	inline const UnpackX & operator >> (const UnpackX & p, Varstr& pstr)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		pstr = p.pop_varstr_ptr();
		return p;
	}
	
	inline const UnpackX & operator >> (const UnpackX & p, uint32_t & i32)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		i32 =  p.pop_uint32();
		return p;
	}
	
	inline const UnpackX & operator >> (const UnpackX & p, uint64_t & i64)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		i64 =  p.pop_uint64();
		return p;
	}
	
	inline const UnpackX & operator >> (const UnpackX & p, int16_t & i16)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		i16 =  p.pop_int16();
		return p;
	}
	
	inline const UnpackX & operator >> (const UnpackX & p, int32_t & i32)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		i32 =  p.pop_int32();
		return p;
	}
	
	inline const UnpackX & operator >> (const UnpackX & p, int64_t & i64)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		i64 =  p.pop_int64();
		return p;
	}
	
	inline const UnpackX & operator >> (const UnpackX & p, float & f)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		f =  p.pop_float();
		return p;
	}
	inline const UnpackX & operator >> (const UnpackX & p, double & d)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		d =  p.pop_double();
		return p;
	}
	
	inline const UnpackX & operator >> (const UnpackX & p, std::string & str)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		str = p.pop_varstr();
		return p;
	}
	
	inline const UnpackX & operator >> (const UnpackX & p, RawBasicString & str)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		str = p.pop_varstr32_raw();
		return p;
	}
	
	inline const UnpackX & operator >> (const UnpackX & p, std::wstring & str)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		// XXX map::value_type::first_type
		str = p.pop_varwstring32();
		return p;
	}
	
	inline const UnpackX & operator >> (const UnpackX & p, uint16_t & i16)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		i16 =  p.pop_uint16();
		return p;
	}
	
	inline const UnpackX & operator >> (const UnpackX & p, uint8_t & i8)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		i8 =  p.pop_uint8();
		return p;
	}
	
	inline const UnpackX & operator >> (const UnpackX & p, bool & sign)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		sign =  (p.pop_uint8() == 0) ? false : true;
		return p;
	}
	
	template <class T1, class T2> inline
	PackX& operator << (PackX& s, const std::pair<T1, T2>& p)
	{
		s << p.first << p.second;
		return s;
	}
	
	template <class T1, class T2> inline
	const UnpackX& operator >> (const UnpackX& s, std::pair<const T1, T2>& p)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		const T1& m = p.first;
		T1 & m2 = const_cast<T1 &>(m);
		s >> m2 >> p.second;
		return s;
	}
	
	template <class T1, class T2> inline
	const UnpackX& operator >> (const UnpackX& s, std::pair<T1, T2>& p)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		s >> p.first >> p.second;
		return s;
	}
	
	template <class T> inline
	PackX& operator << (PackX& p, const std::vector<T>& vec)
	{
		marshal_container(p, vec);
		return p;
	}
	
	template <class T> inline
	const UnpackX& operator >> (const UnpackX& p, std::vector<T>& vec)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		unmarshal_container(p, std::back_inserter(vec));
		return p;
	}
	
	template <class T1, class T2>
	inline PackX& operator << (PackX& p, const std::map<T1,T2>& map)
	{
		marshal_container(p, map);
		return p;
	}
	
	template <class T1, class T2>
	inline const UnpackX& operator >> (const UnpackX& p, std::map<T1,T2>& map)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		unmarshal_container(p, std::inserter(map,map.begin()));
		return p;
	}
	
	template <class T> inline
	PackX& operator << (PackX& p, const std::set<T>& set)
	{
		marshal_container(p, set);
		return p;
	}
	
	template <class T> inline
	const UnpackX& operator >> (const UnpackX& p, std::set<T>& set)
	{
        if (p.isUnpackError())
        {
            return p;
        }
		unmarshal_container(p, std::inserter(set, set.begin()));
		return p;
	}
	
	template < typename ContainerClass >
	inline void marshal_container(PackX & p, const ContainerClass & c)
	{
		p.push_uint32(uint32_t(c.size())); // use uint32 ...
		for (typename ContainerClass::const_iterator i = c.begin(); i != c.end(); ++i)
			p << *i;
	}
	
	template < typename OutputIterator >
	inline void unmarshal_container(const UnpackX & p, OutputIterator i)
	{
        if (p.isUnpackError())
        {
            return ;
        }
        uint32_t count = p.pop_uint32();
        if(p.isUnpackError())
        {
            return;
        }
        
        for (; count > 0; --count)
        {
            if(p.isUnpackError())
                return;
            typename OutputIterator::container_type::value_type tmp;
            p >> tmp;
            *i = tmp;
            ++i;
        }
	}
	
	template < typename OutputContainer>
	inline void unmarshal_containerEx(const UnpackX & p, OutputContainer & c)
	{
        if (p.isUnpackError())
        {
            return ;
        }
        uint32_t count = p.pop_uint32();
        if(p.isUnpackError())
        {
            return;
        }
        
        for( ; count >0 ; --count)
        {
            if(p.isUnpackError())
                return;
            typename OutputContainer::value_type tmp;
            tmp.unmarshal(p);
            c.push_back(tmp);
        }
	}
NAMESPACE_BASEMOD_END
#endif //YYPROTO_PACKET_EX_CPP_H
