﻿//
// Created by HUTAO on 2017/6/28.
//

#ifndef YYPROTO_LINK_H
#define YYPROTO_LINK_H

#include "commondefine.h"
#include "packet.h"
#include "packet_ex.h"
#include "zip_tpl.h"
#include "basesvid.h"
#include "netconst.h"

NAMESPACE_BASEMOD_BEGIN
struct PExchangeKey : public Marshallable
{
	enum {uri = (17 << 8) | protocol::LINKD_SVID};

	std::string publicKey;
	std::string e;

	virtual void marshal(Pack &pk) const
	{
		pk << publicKey << e;
	}

	virtual void unmarshal(const Unpack &up)
	{
		up >> publicKey >> e;
	}
};

struct PExchangeKeyExt: public Marshallable
{
	enum {uri = (50 << 8) | protocol::LINKD_SVID};

	std::string    publicKey;
	std::string    e;
	std::string    extentPayload;                // PGetAntiCode含包头。掉线重连时不填

	virtual void marshal(Pack &pk) const
	{
		pk << publicKey << e;

		pk.push_varstr32(extentPayload.data(), extentPayload.size());
	}

	virtual void unmarshal(const Unpack &up)
	{
		up >> publicKey >> e;

		if (!up.empty())
		{
			extentPayload = up.pop_varstr32();
		}
	}
};

struct PExchangeKeyRes : public Marshallable
{
	enum {uri = (21 << 8) | protocol::LINKD_SVID};

	std::string encSessionKey;

	virtual void marshal(Pack &pk) const
	{
		pk << encSessionKey;
	}

	virtual void unmarshal(const Unpack &up)
	{
		up >> encSessionKey;
	}
};

struct PExchangeKeyExtRes: public Marshallable
{
	enum {uri = (51 << 8) | protocol::LINKD_SVID};

	std::string    encSessionKey;
	std::string    extentPayload;

	virtual void marshal(Pack &pk) const
	{
		pk << encSessionKey;

		pk.push_varstr32(extentPayload.data(), extentPayload.size());
	}

	virtual void unmarshal(const Unpack &up)
	{
		up >> encSessionKey;

		if (!up.empty())
		{
			extentPayload = up.pop_varstr32();
		}
	}
};

typedef ZipMarshal<PExchangeKeyExt,    52 << 8 | protocol::LINKD_SVID>    PExchangeKeyExtZip;
typedef ZipMarshal<PExchangeKeyExtRes, 53 << 8 | protocol::LINKD_SVID>    PExchangeKeyExtZipRes;

// 经 AP dispatcher 到 UDB 获取反外挂代码请求里层包
struct PGetAntiCode: public Marshallable
{
	enum {uri = (3048 << 8) | protocol::LINKD_SVID};

	std::string    context;
	std::string    bizName;                       // 反外挂虚拟机类别

	virtual void marshal(Pack &pk) const
	{
		pk << context << bizName;
	}

	virtual void unmarshal(const Unpack &up)
	{
		up >> context >> bizName;
	}
};

// UDB 经 dispatcher 到 AP 获取反外挂代码响应里层包
struct PGetAntiCodeRes: public Marshallable
{
	enum {uri = (3049 << 8) | protocol::LINKD_SVID};

	std::string    context;
	std::string    antiCode;

	virtual void marshal(Pack &pk) const
	{
		pk << context << antiCode;
	}

	virtual void unmarshal(const Unpack &up)
	{
		up >> context >> antiCode;
	}
};

//LBS
struct PCS_GetAPInfo : Marshallable
{
	enum {uri = (115 << 8) | protocol::IMLBS_SVID};

	PCS_GetAPInfo() : m_uUid(INVALID_UID), m_uRetry(0), m_uSdkVersion(0), m_uAppkey(0), m_priIsp(AUTO_DETECT) {}

	uint64_t      m_uUid;
	uint32_t      m_uAppId;//业务内部标识
	uint32_t      m_uRetry;
	std::string   m_strIMEI;
	uint32_t      m_uSdkVersion;
	std::string   m_uAppVersion;
	std::string   m_strClientFrom;
	std::string   m_strPlatform;
	std::set<uint32_t> m_uForbidIp;
	std::vector<std::pair<uint32_t, std::string> > m_mapApSpecReq;
	uint32_t m_lcid; // 兼容pc端强制升级，默认值=-1规避目前pc=0的配置
	uint32_t m_uAppkey; // 欢聚云应用标识，业务的AppId
	std::string   m_strContext;
	ISPType m_priIsp; // 用户指定优先使用的isp
	std::string m_priRegion; // 用户指定优先使用的国家/地区 2字母缩写：[https://zh.wikipedia.org/wiki/ISO_3166-1]
	virtual void marshal(Pack &p) const
	{
		p << m_uUid << m_uAppId << m_uRetry;
		p << m_strIMEI << m_uSdkVersion << m_uAppVersion << m_strClientFrom << m_strPlatform;
		marshal_container(p, m_uForbidIp);
		marshal_container(p, m_mapApSpecReq);
		p << m_lcid << m_uAppkey << m_strContext;
		p.push_uint16(m_priIsp);
		p << m_priRegion;
	}

	virtual void unmarshal(const Unpack &p)
	{
		p >> m_uUid >> m_uAppId >> m_uRetry;
		if(!p.empty())
		{
			p >> m_strIMEI >> m_uSdkVersion >> m_uAppVersion >> m_strClientFrom >> m_strPlatform;
			unmarshal_container(p, std::inserter(m_uForbidIp, m_uForbidIp.begin()));
		}
		if(!p.empty())
		{
			unmarshal_container(p, std::back_inserter(m_mapApSpecReq));
		}
		if (!p.empty())
		{
			p >> m_lcid;
		}
		if (!p.empty())
		{
			p >> m_uAppkey;
		}
		if (!p.empty())
		{
			p >> m_strContext;
		}
		if (!p.empty())
		{
			m_priIsp = (ISPType)p.pop_uint16();
		}
		if(!p.empty())
		{
			p >> m_priRegion;
		}
	}
};

struct CAPInfo: Marshallable
{
	uint32_t                 m_uGrpId;          // 机房编号
	std::string              m_strIp;
	std::vector<uint16_t>    m_vecPort;

	CAPInfo()
	{
		m_uGrpId = NONE_SERVER_ID;
	}

	CAPInfo(uint32_t uGrpId, const std::string& strIp, const std::vector<uint16_t> &vecPort)
	{
		m_uGrpId  = uGrpId;
		m_strIp   = strIp;
		m_vecPort = vecPort;
	}

	virtual void marshal(Pack &p) const
	{
		p << m_strIp << m_uGrpId;
		marshal_container(p, m_vecPort);
	}

	virtual void unmarshal(const Unpack &p)
	{
		p >> m_strIp >> m_uGrpId;
		unmarshal_container(p, std::back_inserter(m_vecPort));
	}
};

struct PCS_GetAPInfoRes: Marshallable
{
	enum {uri = (116 << 8) | protocol::IMLBS_SVID};

	uint32_t                  m_uAreaId;        // 区域编号
	ISPType                   m_emISPType;
	uint32_t                  m_uIp;
	std::vector<CAPInfo>      m_vecApInfo;
	uint32_t                  m_uAppId;
	uint32_t                  m_uRescode;       // PC 用的
	std::string               m_strExtension;  // 统计用，合法字符[0-9a-zA-Z,;:_@]
	uint32_t				  m_uApLinkMode;   // [not used]
	uint32_t				  m_uApLoginMode;  // [not used]0:UNKNOWN 1:AP_BYPASS 2:LINKD 3:AP
	std::string               m_strContext;     //回填PCS_GetAPInfo
	uint32_t                  m_uMode;          //[PC用的]now=JoinMode: 0:Default 1:auther 2:smanager

	virtual void marshal(Pack &pk) const
	{
		pk << m_uAreaId << m_uIp;
		pk.push_uint16(m_emISPType);
		marshal_container(pk, m_vecApInfo);
		pk << m_uAppId << m_uRescode << m_strExtension;
		pk << m_uApLinkMode;
		pk << m_uApLoginMode;
		pk << m_strContext;
		pk << m_uMode;
	}

	virtual void unmarshal(const Unpack &up)
	{
		up >> m_uAreaId >> m_uIp;
		m_emISPType = (ISPType)up.pop_uint16();
		unmarshal_container(up, std::back_inserter(m_vecApInfo));

		if (up.size() > 0)
		{
			up >> m_uAppId;
		}
		else
		{
			m_uAppId = 0;
		}

		if(!up.empty())
		{
			up >> m_uRescode >> m_strExtension;
		}

		if(!up.empty())
		{
			up >> m_uApLinkMode;
		}
		if(!up.empty())
		{
			up >> m_uApLoginMode;
		}
		if (!up.empty())
		{
			up >> m_strContext;
		}
		if (!up.empty())
		{
			up >> m_uMode;
		}
	}
};

//struct PCS_APPing : public VSMarshallable
//{
//    enum {uri = (3102 << 8) | protocol::LINKD_SVID};
//
//    //CAppUIDs在底层
//    std::string m_strContext;
//    uint32_t lastRtt;//(上次ping回复的rtt)
//    uint8_t telNetType;//手机网络状态（GPRS、LTE等）
//    uint8_t netType;//网络类型(wifi\mobile\unknow)
//    uint16_t ispType;//运营商类型
//    uint32_t sdkVer;//(sdk version)
//    uint32_t LbsReturnIp;
//
//    virtual void vsmarshal(PackX &p) const
//    {
//        p << m_strContext<< lastRtt << telNetType << netType << ispType << sdkVer << LbsReturnIp;
//    }
//
//    virtual void vsunmarshal(const UnpackX &p)
//    {
//        if(!p.empty())
//        {
//            p >> m_strContext;
//        }
//        if(!p.empty())
//        {
//            p >> lastRtt >> telNetType >> netType >> ispType >> sdkVer >> LbsReturnIp;
//        }
//    }
//};
//
//struct PCS_APPong: public VSMarshallable
//{
//    enum {uri = (3103 << 8) | protocol::LINKD_SVID};
//
//    std::set<uint32_t>    m_setAvailAppID; // available AppIDS in AP
//    uint32_t              m_uServerTimeStamp;
//    std::string           m_strContext;
//
//    virtual void vsmarshal(PackX &p) const
//    {
//        p << m_setAvailAppID << m_uServerTimeStamp << m_strContext;
//    }
//
//    virtual void vsunmarshal(const UnpackX &p)
//    {
//        p >> m_setAvailAppID;
//
//        if (!p.empty())
//        {
//            p >> m_uServerTimeStamp;
//        }
//
//        if (!p.empty())
//        {
//            p >> m_strContext;
//        }
//    }
//};
	
	// 连接保活
	struct PCS_ServicePingRequest : public Marshallable
	{
		enum {uri = (5655 << 8 | protocol::SERVICE_SVID)};

		std::string context; // [可选]如无外层包，必需提供上下文字段

		virtual void marshal(Pack &pk) const {
			pk << context;
		}

		virtual void unmarshal(const Unpack &up) {
			up >> context;
		}

		virtual std::ostream & trace(std::ostream & ss) const {
			return ss;
		}
	};

	struct PCS_ServicePingResponse : public Marshallable
	{
		enum {uri = (5656 << 8 | protocol::SERVICE_SVID)};

		PCS_ServicePingResponse():timestamp(0){}

		std::string context; // [可选]如无外层包，必需提供上下文字段

		uint64_t timestamp; // [必填]服务器时间戳

		virtual void marshal(Pack &pk) const {
			pk << context;
			pk << timestamp;
		}

		virtual void unmarshal(const Unpack &up) {
			up >> context;
			up >> timestamp;
		}

		virtual std::ostream & trace(std::ostream & ss) const {
			return ss;
		}
	};
	struct PCS_GetAPInfo2 : Marshallable
	{
		enum {uri = (117 << 8) | protocol::IMLBS_SVID};
		
		PCS_GetAPInfo2() : uid(uint64_t(-1)), appid(0),svcApType(265){}
		
		std::string context; // 上下文
		uint64_t uid; // 用户唯一标识，可填未认证的uid
		uint32_t appid; // 欢聚云应用标识 appkey
		uint32_t svcApType; // 内部业务标识，固定填265
		std::string deviceId; // 设备id
		std::string sdkVer; // sdk版本号(一般为整数)
		std::string appVer; // 应用版本号([0-9a-zA-Z._\-]*)
		std::string priRegion; // 用户指定优先使用的国家/地区 2字母缩写：[https://zh.wikipedia.org/wiki/ISO_3166-1]
		std::map<std::string, std::string> clientExtent; // 扩展字段 //客户端->aplbs 客户端信息扩展字段
//		LbsRetry:[0-9]* //客户端重试lbs次数

		virtual void marshal(Pack &p) const
		{
			p << context;
			p << uid;
			p << appid;
			p << svcApType;
			p << deviceId;
			p << sdkVer;
			p << appVer;
			p << priRegion;
			p << clientExtent;
		}
		
		virtual void unmarshal(const Unpack &up)
		{
			up >> context;
			up >> uid;
			up >> appid;
			up >> svcApType;
			up >> deviceId;
			up >> sdkVer;
			up >> appVer;
			up >> priRegion;
			up >> clientExtent;
		}
	};
	
	
	struct PCS_GetAPInfo2Res : Marshallable
	{
		enum {uri = (118 << 8) | protocol::IMLBS_SVID};
		
		PCS_GetAPInfo2Res()
				: areaType(0), ispType(0), userIp(0)
		{}
		
		std::string context; // 回填PCS_GetAPInfo2上下文
		uint32_t areaType; // 区域编号
		uint32_t ispType; // isp编号
		uint32_t userIp; // 用户出口ip
		std::map<std::string, std::string> serverExtent; // 扩展字段(灰度开关),aplbs->客户端 服务端信息扩展字段
		std::vector<CAPInfo> apInfosTcp;
		std::vector<CAPInfo> apInfosAccessTrans;
		//初定serverExtent["enableAccessTrans"] = "1" 控制使用弱网sdk
		//ApAccessTransVer:[0-9]* ap弱网udp传输sdk版本
		
		virtual void marshal(Pack &p) const
		{
			p << context;
			p << areaType;
			p << ispType;
			p << userIp;
			p << serverExtent;
			p << apInfosTcp;
			p << apInfosAccessTrans;
		}
		
		virtual void unmarshal(const Unpack &up)
		{
			up >> context;
			up >> areaType;
			up >> ispType;
			up >> userIp;
			up >> serverExtent;
			up >> apInfosTcp;
			up >> apInfosAccessTrans;
		}
	};

	struct PingThruLocalSock: public Marshallable
	{
		enum {uri = 101};
		std::string     strContext;

		virtual void marshal(Pack &pk) const
		{
			pk << strContext;
		}
		virtual void unmarshal(const Unpack &up)
		{
			up >> strContext;
		}
	};

	struct PongThruLocalSock: public Marshallable
	{
		enum {uri = 102};
		std::string     strContext;
		uint32_t wanIp;

		virtual void marshal(Pack &pk) const
		{
			pk << strContext << wanIp;
		}
		virtual void unmarshal(const Unpack &up)
		{
			up >> strContext;
			if (up.size() > 0)
			{
				up >> wanIp;
			}
		}
	};
NAMESPACE_BASEMOD_END
#endif //YYPROTO_LINK_H
