﻿//
// Created by HUTAO on 2017/7/28.
//

#ifndef NETDEMO_ITASKTIMER_H
#define NETDEMO_ITASKTIMER_H

#include "commondefine.h"
#include "ITaskThread.h"
#include "ProtoTime.h"

NAMESPACE_BASEMOD_BEGIN
	template<class T>
	class ProtoTimer : public IProtoTask
	{
	private:
		typedef void (T::*callback)();
	public:
		ProtoTimer()
		{
			m_bRepeat = false;
			m_nStart = currentSystemTimeMs();
		}
		ProtoTimer(ITaskThread* pThread,bool repeat)
		{
			m_pThread = pThread;
			m_bRepeat = repeat;
			m_nStart = currentSystemTimeMs();
		}
		
		~ProtoTimer()
		{
		}
	
	public:
		virtual void run()
		{
			(m_pObject->*m_pFunc)();
			m_nEnd = currentSystemTimeMs() - m_nStart;
			m_nStart += m_nEnd;
		}
		
		virtual void	setRepeat(bool repeat)
		{
			m_bRepeat = repeat;
		}
		
		virtual bool	getRepeat()
		{
			return m_bRepeat;
		}
	
	public:
		virtual void    post()
		{
			m_pThread->post(this);
		}
		virtual void    post(uint32_t delay)
		{
			m_pThread->post(this,delay);
		}
		virtual void    remove()
		{
			m_pThread->remove(this);
		}
	
	public:
		void init(T* x, callback cb)
		{
			m_pObject = x;
			m_pFunc = cb;
		}
		
		void init(T* x, callback cb, std::string name)
		{
			m_pObject = x;
			m_pFunc = cb;
			m_strName = name;
		}
		
		std::string		getName()
		{
			return m_strName;
		}
	
	protected:
		ITaskThread* m_pThread;
		uint64_t	m_nStart;
		uint64_t	m_nEnd;
		T*			m_pObject;
		callback	m_pFunc;
		std::string m_strName;
	};

NAMESPACE_BASEMOD_END
#endif //NETDEMO_ITASKTIMER_H
