/*
 * Decompiled with CFR 0.152.
 */
package com.yy.platform.baseservice.utils;

import android.content.Context;
import android.os.Build;
import com.yy.platform.baseservice.YYServiceCore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class LoadLibraryUtils {
    public static boolean loadLibrary(Context context, String string) {
        YYServiceCore.log(String.format("load library: %s", string));
        try {
            System.loadLibrary(string);
            YYServiceCore.log(String.format("load library: %s success", string));
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            YYServiceCore.log(String.format("System.loadLibrary %s failed:%s", string, unsatisfiedLinkError.getMessage()));
            boolean bl = LoadLibraryUtils.load(context, string, context.getClassLoader());
            if (bl) {
                YYServiceCore.log(String.format("load library: %s success", string));
            } else {
                YYServiceCore.log(String.format("load library: %s failed", string));
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean load(Context context, String string, ClassLoader classLoader) {
        File file;
        Object object;
        File file2 = new File(context.getApplicationInfo().nativeLibraryDir);
        String string2 = null;
        if ("armeabi-v7a".equals(Build.CPU_ABI) && ((File)(object = new File(file2, "lib" + string + "-v7a.so"))).exists()) {
            file = new File(context.getDir("lib_v7a", 0), "lib" + string + ".so");
            if (!file.exists() || ((File)object).length() != file.length()) {
                LoadLibraryUtils.a((File)object, file);
            }
            if (file.exists() && file.length() == ((File)object).length()) {
                string2 = file.getAbsolutePath();
            }
        }
        if (string2 == null && ((File)(object = new File(file2, "lib" + string + ".so"))).exists()) {
            string2 = ((File)object).getAbsolutePath();
        }
        if (string2 != null && LoadLibraryUtils.a(string2, classLoader)) {
            YYServiceCore.log(string2 + " loaded");
            return true;
        }
        if (LoadLibraryUtils.b(string, classLoader)) {
            YYServiceCore.log(string + " loaded");
            return true;
        }
        object = null;
        try {
            file = new File(context.getDir("lib_ext", 0), "lib" + string + ".so");
            File file3 = new File(context.getApplicationInfo().sourceDir);
            object = new ZipFile(file3);
            if (LoadLibraryUtils.a((ZipFile)object, string, file) && file.length() > 0L && LoadLibraryUtils.a(file.getAbsolutePath(), classLoader)) {
                YYServiceCore.log(file.getAbsolutePath() + " loaded");
                boolean bl = true;
                return bl;
            }
        }
        catch (Throwable throwable) {
            YYServiceCore.log("load failed:" + throwable.getMessage());
        }
        finally {
            try {
                if (object != null) {
                    ((ZipFile)object).close();
                }
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        YYServiceCore.log(string + " load failed");
        return false;
    }

    private static boolean a(String string, ClassLoader classLoader) {
        try {
            Runtime runtime = Runtime.getRuntime();
            Method method = runtime.getClass().getDeclaredMethod("load", String.class, ClassLoader.class);
            method.setAccessible(true);
            method.invoke((Object)runtime, string, classLoader);
        }
        catch (InvocationTargetException invocationTargetException) {
            YYServiceCore.log("Fail to load library:" + invocationTargetException.getTargetException().getMessage());
            return false;
        }
        catch (Throwable throwable) {
            YYServiceCore.log("Fail to load library:" + throwable.getMessage());
            return false;
        }
        return true;
    }

    private static boolean b(String string, ClassLoader classLoader) {
        try {
            Runtime runtime = Runtime.getRuntime();
            Method method = runtime.getClass().getDeclaredMethod("loadLibrary", String.class, ClassLoader.class);
            method.setAccessible(true);
            method.invoke((Object)runtime, string, classLoader);
        }
        catch (InvocationTargetException invocationTargetException) {
            YYServiceCore.log("Fail to load library:" + invocationTargetException.getTargetException().getMessage());
            return false;
        }
        catch (Throwable throwable) {
            YYServiceCore.log("Fail to load library:" + throwable.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(File file, File file2) {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            if (file2.exists()) {
                file2.delete();
            }
            if (file.exists()) {
                byte[] byArray = new byte[2048];
                int n2 = 0;
                inputStream = new FileInputStream(file);
                fileOutputStream = new FileOutputStream(file2);
                while ((n2 = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n2);
                }
            }
        }
        catch (Exception exception) {
            YYServiceCore.log("Fail to load library:" + exception.getMessage());
            file2.delete();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                YYServiceCore.log("Fail to load library:" + exception.getMessage());
            }
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {
                YYServiceCore.log("Fail to load library:" + exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean a(ZipFile zipFile, String string, File file) {
        ZipEntry zipEntry = null;
        if ("armeabi-v7a".equals(Build.CPU_ABI) && (zipEntry = zipFile.getEntry("lib/armeabi-v7a/lib" + string + ".so")) == null) {
            zipEntry = zipFile.getEntry("lib/armeabi/lib" + string + "-v7a.so");
        }
        if (zipEntry == null) {
            zipEntry = zipFile.getEntry("lib/armeabi/lib" + string + ".so");
        }
        if (zipEntry == null) {
            return false;
        }
        if (zipEntry.getSize() == file.length()) {
            return true;
        }
        if (file.exists()) {
            file.delete();
        }
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            inputStream = zipFile.getInputStream(zipEntry);
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[2048];
            int n2 = 0;
            while ((n2 = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n2);
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            YYServiceCore.log("Fail to load library:" + throwable.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                YYServiceCore.log("Fail to load library:" + exception.getMessage());
            }
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {
                YYServiceCore.log("Fail to load library:" + exception.getMessage());
            }
        }
        return false;
    }
}

