/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.plugin.pluginunionpersonalcenter.profile.edit.province.provincecity;

import android.content.Context;
import android.util.Xml;
import com.yy.mobile.plugin.pluginunionpersonalcenter.profile.edit.province.provincecity.City;
import com.yy.mobile.plugin.pluginunionpersonalcenter.profile.edit.province.provincecity.Province;
import com.yy.mobile.util.log.MLog;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ProvinceCityUtil {
    private static final String PROVINCES_CITY_XML_FILE = "provinces_citys.xml";
    private static final String TAG_PROVINCE = "province";
    private static final String TAG_CITY = "city";
    private static final String TAG_ID = "id";
    private static final String TAG_NAME = "name";
    private static ProvinceCityUtil _self = null;
    private static Context mContext;

    public static ProvinceCityUtil instance(Context c) {
        if (_self == null) {
            _self = new ProvinceCityUtil();
            mContext = c.getApplicationContext();
        }
        return _self;
    }

    public String getProvince(int idOfProvince) {
        List<Province> l = this.getProvinces();
        for (int i = 0; i < l.size(); ++i) {
            if (!l.get(i).getId().equalsIgnoreCase("" + idOfProvince)) continue;
            return l.get(i).getName();
        }
        return "";
    }

    public String getCity(int idOfProvince, int idOfCity) {
        List<Province> pl = this.getProvinces();
        for (int i = 0; i < pl.size(); ++i) {
            if (!pl.get(i).getId().equalsIgnoreCase("" + idOfProvince)) continue;
            List<City> cl = pl.get(i).getCityList();
            for (int j = 0; j < cl.size(); ++j) {
                if (!cl.get(j).getId().equalsIgnoreCase("" + idOfCity)) continue;
                return cl.get(j).getName();
            }
        }
        return "";
    }

    public List<Province> getProvinces() {
        ArrayList<Province> provinceList = new ArrayList<Province>();
        ArrayList<City> cityList = null;
        Province province = null;
        City city = null;
        InputStream inputStream = null;
        XmlPullParser xmlParser = Xml.newPullParser();
        try {
            inputStream = mContext.getResources().getAssets().open(PROVINCES_CITY_XML_FILE);
            xmlParser.setInput(inputStream, "utf-8");
            int evtType = xmlParser.getEventType();
            while (evtType != 1) {
                switch (evtType) {
                    case 2: {
                        String tag = xmlParser.getName();
                        if (tag.equalsIgnoreCase(TAG_PROVINCE)) {
                            province = new Province();
                            province.setId(xmlParser.getAttributeValue(null, TAG_ID));
                            province.setName(xmlParser.getAttributeValue(null, TAG_NAME));
                            cityList = new ArrayList<City>();
                            break;
                        }
                        if (province == null || !tag.equalsIgnoreCase(TAG_CITY)) break;
                        city = new City();
                        city.setId(xmlParser.getAttributeValue(null, TAG_ID));
                        city.setName(xmlParser.getAttributeValue(null, TAG_NAME));
                        cityList.add(city);
                        break;
                    }
                    case 3: {
                        if (!xmlParser.getName().equalsIgnoreCase(TAG_PROVINCE) || provinceList == null) break;
                        province.setCityList(cityList);
                        provinceList.add(province);
                        province = null;
                        cityList = null;
                        break;
                    }
                }
                evtType = xmlParser.next();
            }
        }
        catch (XmlPullParserException e) {
            MLog.error((Object)"hsj", (String)"ProvinceCityUtil xmlParse: ", (Throwable)e, (Object[])new Object[0]);
        }
        catch (IOException e1) {
            MLog.error((Object)"hsj", (String)"ProvinceCityUtil io: ", (Throwable)e1, (Object[])new Object[0]);
        }
        return provinceList;
    }
}

