/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.plugin.pluginunionpersonalcenter.fans;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.android.arouter.launcher.ARouter;
import com.yy.mobile.plugin.main.events.IArtistClient_onUserFansListRsp_EventArgs;
import com.yy.mobile.plugin.pluginunionpersonalcenter.R;
import com.yy.mobile.plugin.pluginunionpersonalcenter.fans.FansUserInfo;
import com.yy.mobile.plugin.pluginunionpersonalcenter.fans.UserFansListAdapter;
import com.yy.mobile.plugin.pluginunionpersonalcenter.fans.UserFansListFragment$$EventBinder;
import com.yy.mobile.ui.BaseFragmentKt;
import com.yy.mobile.ui.widget.EndlessListScrollListener;
import com.yy.mobile.ui.widget.StatusLayout;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.valid.BlankUtil;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.artist.IArtistCore;
import com.yymobile.core.ent.artist.IPQueryUserFansListRsp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class UserFansListFragment
extends BaseFragmentKt {
    private static final String TAG = "UserFansListFragment";
    public static final String EXTRA_UID = "extra_uid";
    private static final int TIME_OUT_MILLIS = 10000;
    private View mRoot;
    private long mUid;
    private PullToRefreshListView mListView;
    private UserFansListAdapter mAdapter;
    private EndlessListScrollListener mEndlessListScrollListener;
    private int pageNo = 1;
    private int pageSize = 20;
    private boolean isLastPage = false;
    private View.OnClickListener mReloadClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            UserFansListFragment.this.hideStatus();
            UserFansListFragment.this.showLoading(UserFansListFragment.this.mRoot, 0, 0);
            UserFansListFragment.this.pageNo = 1;
            UserFansListFragment.this.requestUserFansList(UserFansListFragment.this.mUid, UserFansListFragment.this.pageNo, UserFansListFragment.this.pageSize);
        }
    };
    private Runnable checkRequestTimeoutTask = new Runnable(){

        @Override
        public void run() {
            UserFansListFragment.this.hideStatus();
            UserFansListFragment.this.mListView.onRefreshComplete();
            UserFansListFragment.this.mEndlessListScrollListener.onLoadComplete();
            if (FP.empty(UserFansListFragment.this.mAdapter.getData())) {
                UserFansListFragment.this.showReload(UserFansListFragment.this.mRoot, R.drawable.icon_error, R.string.click_screen_reload);
            }
        }
    };
    AdapterView.OnItemClickListener onItemClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> adapterView, View view, int position, long id2) {
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((Object)UserFansListFragment.TAG, (String)("position = " + position), (Object[])new Object[0]);
            }
            try {
                if (UserFansListFragment.this.mAdapter != null && UserFansListFragment.this.mListView != null && UserFansListFragment.this.mAdapter.getCount() > 0 && position > 0 && position - ((ListView)UserFansListFragment.this.mListView.getRefreshableView()).getHeaderViewsCount() >= 0) {
                    UserFansListFragment.this.showUserInfo(position - ((ListView)UserFansListFragment.this.mListView.getRefreshableView()).getHeaderViewsCount(), "\u6b63\u5728\u5904\u7406");
                }
            }
            catch (Throwable throwable) {
                MLog.error((Object)UserFansListFragment.TAG, (Throwable)throwable);
            }
        }
    };
    private EventBinder mUserFansListFragmentSniperEventBinder;

    public static UserFansListFragment instance(long uid) {
        UserFansListFragment instance = new UserFansListFragment();
        Bundle args = new Bundle();
        args.putLong(EXTRA_UID, uid);
        instance.setArguments(args);
        return instance;
    }

    public void onCreate(Bundle savedInstanceState) {
        this.mUid = this.getArguments().getLong(EXTRA_UID);
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mRoot = inflater.inflate(R.layout.personalcenter_fragment_user_fanslist_layout, container, false);
        if (!this.isNetworkAvailable()) {
            this.showReload(this.mRoot, R.drawable.icon_error, R.string.click_screen_reload);
        } else {
            this.showLoading(this.mRoot, 0, 0);
        }
        this.initListView();
        return this.mRoot;
    }

    public void onResume() {
        super.onResume();
        if (!this.isNetworkAvailable()) {
            this.showReload(this.mRoot, R.drawable.icon_error, R.string.click_screen_reload);
        } else {
            this.requestUserFansList(this.mUid, this.pageNo, this.pageSize);
        }
    }

    @BusEvent
    public void onUserFansListRsp(IArtistClient_onUserFansListRsp_EventArgs busEventArgs) {
        int result = busEventArgs.getResult();
        long uid = busEventArgs.getUid();
        List userList = busEventArgs.getUserList();
        int offset = busEventArgs.getOffset();
        int listSize = busEventArgs.getListSize();
        MLog.info((Object)TAG, (String)("-- onUserFansListRsp result:" + result + " uid:" + uid + " userlist:" + userList + " offset:" + offset + " listSize:" + listSize), (Object[])new Object[0]);
        MLog.info((Object)TAG, (String)("mUid = " + this.mUid), (Object[])new Object[0]);
        if (this.mUid == uid) {
            this.hideStatus();
            ++this.pageNo;
            this.mListView.onRefreshComplete();
            this.mEndlessListScrollListener.onLoadComplete();
            this.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
            if (result != 0) {
                if (this.mAdapter == null || this.mAdapter.getCount() <= 0) {
                    this.showReload(R.drawable.icon_error, R.string.click_screen_reload);
                }
            } else if (BlankUtil.isBlank((Collection)userList) && offset == 1) {
                this.showNoData(R.drawable.icon_no_anchors, "\u5f53\u524d\u6ca1\u6709\u7c89\u4e1d\u2026\u2026");
                this.mAdapter.getData().clear();
                this.mAdapter.notifyDataSetChanged();
            } else {
                if (userList.size() < this.pageSize) {
                    this.isLastPage = true;
                }
                ArrayList<FansUserInfo> data = new ArrayList<FansUserInfo>(userList.size());
                for (int i = 0; i < userList.size(); ++i) {
                    String uidStr = (String)((Map)userList.get(i)).get(IPQueryUserFansListRsp.ITEM_FRIEND_UID);
                    String nickName = (String)((Map)userList.get(i)).get(IPQueryUserFansListRsp.ITEM_FRIEND_NICK_NAME);
                    String avatar2 = (String)((Map)userList.get(i)).get(IPQueryUserFansListRsp.ITEM_FRIEND_AVATAR);
                    String isAnchorStr = (String)((Map)userList.get(i)).get(IPQueryUserFansListRsp.ITEM_FRIEND_IS_ANCHOR);
                    String anchorVStr = (String)((Map)userList.get(i)).get(IPQueryUserFansListRsp.ITEM_FRIEND_AUTH_V);
                    String fansNumStr = (String)((Map)userList.get(i)).get(IPQueryUserFansListRsp.ITEM_FRIEND_FANS_NUM);
                    long fansUid = StringUtils.safeParseLong((String)uidStr);
                    boolean isAnchor = StringUtils.safeParseInt((String)isAnchorStr) == 1;
                    int fansNum = StringUtils.safeParseInt((String)fansNumStr);
                    int anchorV = new Uint32(anchorVStr).intValue();
                    data.add(new FansUserInfo(fansUid, nickName, avatar2, fansNum, anchorV, isAnchor));
                }
                this.mAdapter.addData(data);
                this.mListView.onRefreshComplete();
                this.mEndlessListScrollListener.onLoadComplete();
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)TAG, (String)("onUserFansListRsp data = " + data), (Object[])new Object[0]);
                }
            }
        }
    }

    private void initListView() {
        this.mListView = (PullToRefreshListView)this.mRoot.findViewById(R.id.lv_list);
        this.mListView.setMode(PullToRefreshBase.Mode.PULL_FROM_START);
        this.mListView.setScrollingWhileRefreshingEnabled(true);
        this.mAdapter = new UserFansListAdapter((Activity)this.getActivity());
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        ((ListView)this.mListView.getRefreshableView()).setOnItemClickListener(this.onItemClickListener);
        this.mListView.setOnRefreshListener((PullToRefreshBase.OnRefreshListener2)new PullToRefreshBase.OnRefreshListener2<ListView>(){

            public void onPullDownToRefresh(PullToRefreshBase<ListView> refreshView) {
                if (!UserFansListFragment.this.checkNetToast()) {
                    UserFansListFragment.this.getHandler().post(UserFansListFragment.this.checkRequestTimeoutTask);
                } else {
                    UserFansListFragment.this.pageNo = 1;
                    UserFansListFragment.this.isLastPage = false;
                    UserFansListFragment.this.requestUserFansList(UserFansListFragment.this.mUid, UserFansListFragment.this.pageNo, UserFansListFragment.this.pageSize);
                }
            }

            public void onPullUpToRefresh(PullToRefreshBase<ListView> refreshView) {
            }
        });
        this.mEndlessListScrollListener = new EndlessListScrollListener((StatusLayout)this.mRoot.findViewById(R.id.status_layout));
        this.mEndlessListScrollListener.setListener(new EndlessListScrollListener.EndlessListener(){

            public void onLoadData() {
                UserFansListFragment.this.requestUserFansList(UserFansListFragment.this.mUid, UserFansListFragment.this.pageNo, UserFansListFragment.this.pageSize);
            }

            public boolean shouldLoadData() {
                if (UserFansListFragment.this.isLastPage || !UserFansListFragment.this.isNetworkAvailable()) {
                    UserFansListFragment.this.getHandler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            UserFansListFragment.this.mEndlessListScrollListener.onLoadComplete();
                        }
                    }, 500L);
                    return false;
                }
                return true;
            }
        });
        this.mListView.setOnScrollListener((AbsListView.OnScrollListener)this.mEndlessListScrollListener);
    }

    private void requestUserFansList(long uid, int pageNo, int pageSize) {
        ((IArtistCore)CoreFactory.getCore(IArtistCore.class)).queryUserFansList(uid, pageNo, pageSize);
        this.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
        this.getHandler().postDelayed(this.checkRequestTimeoutTask, 10000L);
    }

    public View.OnClickListener getLoadListener() {
        return this.mReloadClickListener;
    }

    public void showUserInfo(int position, String text) {
        if (!this.checkNetToast() || !this.checkActivityValid()) {
            return;
        }
        FansUserInfo info = this.mAdapter.getItem(position);
        if (info == null) {
            return;
        }
        if (info.getUid() > 0L) {
            ARouter.getInstance().build("/User/View").withLong("extra_anchor_uid", info.getUid()).navigation((Context)this.getActivity());
        }
    }

    protected void onViewCreated(View view, Bundle bundle) {
        if (this.mUserFansListFragmentSniperEventBinder == null) {
            this.mUserFansListFragmentSniperEventBinder = new UserFansListFragment$$EventBinder();
        }
        this.mUserFansListFragmentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, bundle);
    }

    protected void onDestroyView() {
        super.onDestroyView();
        if (this.mUserFansListFragmentSniperEventBinder != null) {
            this.mUserFansListFragmentSniperEventBinder.unBindEvent();
        }
    }
}

