/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.View;
import com.yy.mobile.mvp.MvpPresenter;
import com.yy.mobile.mvp.MvpView;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.common.AbsStatusFragment;
import com.yy.mobile.ui.common.IStatusFragment;
import com.yy.mobile.ui.common.NoMobileLiveFragment;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreManager;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.mobilelive.ILivePluginCore;

public class BaseFragment<P extends MvpPresenter<V>, V extends MvpView>
extends BaseLinkFragment<P, V> {
    private static final String TAG = "BaseFragment";

    public void onViewStateRestored(Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        if (savedInstanceState != null) {
            Fragment fragment = this.getChildFragmentManager().findFragmentByTag("STATUS_TAG");
            if (fragment != null && fragment instanceof NoMobileLiveFragment) {
                ((NoMobileLiveFragment)fragment).setListener(this.getNoMobileLiveDataListener());
            } else if (fragment != null && fragment instanceof AbsStatusFragment) {
                ((AbsStatusFragment)fragment).setListener(this.getNoMobileLiveDataListener());
            } else if (fragment != null && fragment instanceof IStatusFragment) {
                if (!MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose((Object)TAG, (String)"xuwakao, onViewStateRestored re-set listener", (Object[])new Object[0]);
                }
                ((IStatusFragment)fragment).setListener(this.getLoadListener());
            }
        }
    }

    public void showNoMobileLivePersonalReplayData(long userId, boolean showNoRecordTips) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (this.getView() == null) {
            MLog.error((Object)TAG, (String)"wuting, showNoMobileLivePersonalReplayData view is NULL", (Object[])new Object[0]);
            return;
        }
        View view = this.getView().findViewById(R.id.status_layout);
        if (view.getId() <= 0) {
            MLog.error((Object)TAG, (String)"wuting, had not set layout id", (Object[])new Object[0]);
            return;
        }
        if (ICoreManagerBase.getCore(ILivePluginCore.class) != null) {
            AbsStatusFragment fragment = ((ILivePluginCore)CoreManager.getCore(ILivePluginCore.class)).getNoMobileLivePersonalReplayDateFragmentInstance(userId, showNoRecordTips);
            fragment.setListener(this.getNoMobileLiveDataListener());
            this.getChildFragmentManager().beginTransaction().replace(view.getId(), (Fragment)fragment, "STATUS_TAG").commitAllowingStateLoss();
        }
    }

    public void showLoginDialog() {
        if (this.getActivity() != null && this.getActivity() != null) {
            ((BaseActivity)this.getActivity()).showLoginDialog();
        }
    }
}

