/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gift;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.gift.core.IGiftUICore;
import com.yy.mobile.ui.gift.hotball.Bezier2XEvaluator;
import com.yy.mobile.ui.utils.AbstractViewController;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.revenue.IChannelRevenueCore;
import com.yymobile.core.gift.TeamPkFreeGiftNotice;

public class PKGiftAnimController
extends AbstractViewController
implements View.OnTouchListener {
    private static final String TAG = "PKGiftAnimController";
    int screenH;
    int screenW;
    int w;
    int h;
    AnimatorSet set;
    AnimatorSet setClick;
    PointF overF;

    protected void onCreatePrepare(Bundle savedInstanceState) {
        super.onCreatePrepare(savedInstanceState);
        this.isInitHidden = true;
    }

    protected View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        RecycleImageView imageView = new RecycleImageView((Context)this.getActivity());
        ImageLoader.loadImageResource((int)R.drawable.icon_pk_gift, (RecycleImageView)imageView, (ImageConfig)ImageConfig.defaultImageConfig());
        this.screenH = ResolutionUtils.getScreenHeight((Context)this.getActivity());
        this.screenW = ResolutionUtils.getScreenWidth((Context)this.getActivity());
        this.overF = new PointF();
        imageView.measure(0, 0);
        this.w = imageView.getMeasuredWidth();
        this.h = imageView.getMeasuredHeight();
        return imageView;
    }

    protected void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
    }

    public void startAnim(TeamPkFreeGiftNotice tn) {
        if (((IGiftUICore)ICoreManagerBase.getCore(IGiftUICore.class)).isGiftIconVisible()) {
            Point point = ((IChannelRevenueCore)ICoreManagerBase.getCore(IChannelRevenueCore.class)).getWebViewCenterLeftPosition(tn.actName);
            Rect rect = ((IGiftUICore)ICoreManagerBase.getCore(IGiftUICore.class)).getGiftIconPosition();
            MLog.info((Object)TAG, (String)("startAnim " + tn + ",point=" + point), (Object[])new Object[0]);
            if (rect != null && point != null) {
                PointF end = new PointF();
                if (!this.isLandScape()) {
                    end.set((float)(rect.left - this.w / 2 + this.dp(18)), (float)(this.screenH / 2));
                    this.overF.set(end.x, (float)(this.screenH - rect.bottom));
                } else {
                    end.set((float)(this.screenW / 2 - this.w / 2), (float)(this.screenH / 2 - this.h / 2));
                    this.overF.set((float)(this.screenW - rect.right - this.w / 2 + this.dp(18)), (float)(this.screenH - rect.bottom - this.h / 2 + this.dp(18)));
                }
                PointF start = new PointF((float)(this.screenW - this.dp(60)), (float)(this.screenH / 2 - this.dp(40)));
                start.set((float)(point.x - this.w / 2), (float)(point.y - this.h / 2));
                PointF p = new PointF();
                p.set(end.x * 1.0f + (start.x - end.x) * 0.4f, end.y - (float)this.dp(20));
                this.anim(this.mRootView, start, end, p, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationStart(Animator animation) {
                        PKGiftAnimController.this.show();
                        PKGiftAnimController.this.mRootView.setOnTouchListener(null);
                        PKGiftAnimController.this.mRootView.animate().alpha(1.0f);
                    }

                    public void onAnimationEnd(Animator animation) {
                        PKGiftAnimController.this.hide();
                    }
                });
            }
        }
    }

    private void anim(final View target2, PointF start, PointF end, PointF middle, Animator.AnimatorListener listener2) {
        int deta;
        this.set = new AnimatorSet();
        Bezier2XEvaluator evaluator = new Bezier2XEvaluator(middle);
        ValueAnimator bezier = ValueAnimator.ofObject((TypeEvaluator)evaluator, (Object[])new Object[]{start, end});
        bezier.setDuration(1000L);
        bezier.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                PointF p = (PointF)animation.getAnimatedValue();
                target2.setX(p.x);
                target2.setY(p.y);
            }
        });
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)target2, (String)"scaleX", (float[])new float[]{0.1f, 1.0f});
        scaleX.setDuration(500L);
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)target2, (String)"scaleY", (float[])new float[]{0.1f, 1.0f});
        scaleY.setDuration(500L);
        ObjectAnimator translateX = null;
        ObjectAnimator translateY = null;
        if (!this.isLandScape()) {
            deta = this.screenH - (int)end.y;
            translateX = ObjectAnimator.ofFloat((Object)target2, (String)"translationX", (float[])new float[]{end.x, end.x + (float)this.dp(8), end.x + (float)this.dp(-8), end.x + (float)this.dp(8), end.x + (float)this.dp(-8), end.x});
            translateY = ObjectAnimator.ofFloat((Object)target2, (String)"translationY", (float[])new float[]{end.y, end.y + (float)deta * 0.1f, end.y + (float)deta * 0.4f, end.y + (float)deta * 0.6f, end.y + (float)deta * 0.8f, end.y + (float)deta});
        } else {
            deta = (int)this.overF.y - (int)end.y;
            int detaX = (int)(this.overF.x - end.x);
            translateX = ObjectAnimator.ofFloat((Object)target2, (String)"translationX", (float[])new float[]{end.x, end.x + (float)detaX * 0.1f, end.x + (float)detaX * 0.3f, end.x + (float)detaX * 0.5f, end.x + (float)detaX * 0.9f, this.overF.x});
            translateY = ObjectAnimator.ofFloat((Object)target2, (String)"translationY", (float[])new float[]{end.y, end.y + (float)deta * 0.1f, end.y + (float)deta * 0.4f, end.y + (float)deta * 0.6f, end.y + (float)deta * 0.8f, this.overF.y});
        }
        translateX.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                target2.setOnTouchListener((View.OnTouchListener)PKGiftAnimController.this);
            }

            public void onAnimationEnd(Animator animation) {
                target2.setOnTouchListener(null);
            }
        });
        translateX.setDuration(2500L);
        translateY.setDuration(2500L);
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)target2, (String)"alpha", (float[])new float[]{1.0f, 0.2f});
        alpha.setStartDelay(2000L);
        alpha.setDuration(200L);
        this.set.play((Animator)bezier).with((Animator)scaleX).with((Animator)scaleY);
        this.set.play((Animator)translateX).with((Animator)translateY).with((Animator)alpha).after((Animator)bezier);
        if (listener2 != null) {
            this.set.addListener(listener2);
        }
        this.set.start();
    }

    private void animTranslate(View target2, PointF start, PointF end, Animator.AnimatorListener listener2) {
        this.endAnimClick();
        this.setClick = new AnimatorSet();
        this.setClick.setDuration(500L);
        this.setClick.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        ObjectAnimator translateY = ObjectAnimator.ofFloat((Object)target2, (String)"translationY", (float[])new float[]{start.y, end.y});
        if (this.isLandScape()) {
            ObjectAnimator translateX = ObjectAnimator.ofFloat((Object)target2, (String)"translationX", (float[])new float[]{start.x, end.x});
            this.setClick.play((Animator)translateY).with((Animator)translateX);
        } else {
            this.setClick.play((Animator)translateY);
        }
        if (listener2 != null) {
            this.setClick.addListener(listener2);
        }
        this.setClick.start();
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.set != null && this.set.isRunning()) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"onTouch tx=%.2f,ty=%.2f", (Object[])new Object[]{Float.valueOf(this.mRootView.getTranslationX()), Float.valueOf(this.mRootView.getTranslationY())});
            }
            PointF start = new PointF(this.mRootView.getTranslationX(), this.mRootView.getTranslationY());
            this.set.removeAllListeners();
            this.set.end();
            this.animTranslate(this.mRootView, start, this.overF, null);
        }
        return false;
    }

    protected void onOrientationChanged(boolean isLandscape) {
        this.screenH = ResolutionUtils.getScreenHeight((Context)this.getActivity());
        this.screenW = ResolutionUtils.getScreenWidth((Context)this.getActivity());
        if (this.mRootView != null && this.mRootView.getLayoutParams() != null) {
            this.endAnim();
            this.endAnimClick();
        }
    }

    private void endAnim() {
        if (this.set != null) {
            this.set.removeAllListeners();
            this.set.end();
            this.set = null;
        }
    }

    private void endAnimClick() {
        if (this.setClick != null) {
            this.setClick.removeAllListeners();
            this.setClick.end();
            this.setClick = null;
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.endAnim();
        this.endAnimClick();
    }

    private int dp(int val) {
        return DensityUtil.dip2px((Context)this.getActivity(), (float)val);
    }
}

