/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicgunview.danmuopengl;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.os.HandlerThread;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.ui.basicgunview.IDanmukuView;
import com.yy.mobile.ui.basicgunview.danmuopengl.DanmakuSurfaceViewRenderer;
import com.yy.mobile.ui.basicgunview.danmuopengl.gunpower.DanMuItemStub;
import com.yy.mobile.ui.basicgunview.danmuopengl.gunpower.DanmuItem;
import com.yy.mobile.ui.basicgunview.danmuopengl.util.TexturePool;
import com.yy.mobile.ui.basicgunview.newgunpower.GunNewPower;
import com.yy.mobile.ui.basicgunview.newgunpower.IDanmuClickListener;
import com.yy.mobile.ui.basicgunview.newgunpower.IDanmuOpenStatus;
import com.yy.mobile.ui.basicgunview.newgunpower.IDanmuSwitchListener;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.log.MLog;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class DanmakuSurfaceView
extends GLSurfaceView
implements IDanmukuView {
    private static final int DEFAULT_TOP_MARGIN = DimenConverter.dip2px((Context)BasicConfig.getInstance().getAppContext(), (float)4.0f);
    private static final int TOUCH_SLOP = 20;
    private static final String TAG = "DanmakuSurfaceView";
    public float width = 0.0f;
    private DanmakuSurfaceViewRenderer mRenderer;
    private int gapLine = 3;
    private float mLineSpace;
    private int kTopMargin = DEFAULT_TOP_MARGIN;
    private Map<Integer, DanmuItem> mLinesAvaliable;
    private HashMap<Integer, Boolean> hashMap = new HashMap();
    private AtomicBoolean mOnOff = new AtomicBoolean(false);
    private OnItemLongClickListener mOnItemLongClickListener;
    private IDanmuOpenStatus danmuOpenStatus;
    private IDanmuSwitchListener switchListener;
    private IDanmuClickListener listener;
    private CopyOnWriteArrayList<DanmuItem> danmuItemList = new CopyOnWriteArrayList();
    private HandlerThread mHandlerThread;
    private SafeDispatchHandler mSafeDispatchHandler;
    private Runnable scheduRunnable = new Runnable(){

        @Override
        public void run() {
            if (DanmakuSurfaceView.this.danmuOpenStatus != null && DanmakuSurfaceView.this.hashMap != null) {
                DanmakuSurfaceView.this.danmuOpenStatus.getGunPower(DanmakuSurfaceView.this.hashMap);
            }
            DanmakuSurfaceView.this.postTask(500);
        }
    };
    private int mDownMotionX;
    private int mDownMotionY;
    private int mLastMotionX;
    private int mLastMotionY;
    private boolean isMoved;
    private boolean isLongClick;
    private DanmuItem mTouchDownDanmuItem;
    Runnable mLongPressRunnable = new Runnable(){

        @Override
        public void run() {
            DanmakuSurfaceView.this.isLongClick = true;
            DanmuItem item2 = DanmakuSurfaceView.this.findDanmuWithLocation(DanmakuSurfaceView.this.mLastMotionX, DanmakuSurfaceView.this.mLastMotionY);
            if (DanmakuSurfaceView.this.mTouchDownDanmuItem != null && item2 != null && !TextUtils.isEmpty((CharSequence)((DanmakuSurfaceView)DanmakuSurfaceView.this).mTouchDownDanmuItem.pureText) && TextUtils.equals((CharSequence)((DanmakuSurfaceView)DanmakuSurfaceView.this).mTouchDownDanmuItem.pureText, (CharSequence)item2.pureText) && DanmakuSurfaceView.this.mOnItemLongClickListener != null) {
                DanmakuSurfaceView.this.mOnItemLongClickListener.onItemLongClick(item2.gunId, item2.pureText);
            }
        }
    };
    Runnable mClickRunnable = new Runnable(){

        @Override
        public void run() {
            if (DanmakuSurfaceView.this.mTouchDownDanmuItem != null & DanmakuSurfaceView.this.listener != null) {
                DanmakuSurfaceView.this.listener.setOnClickListener(new DanMuItemStub(((DanmakuSurfaceView)DanmakuSurfaceView.this).mTouchDownDanmuItem.gunId, ((DanmakuSurfaceView)DanmakuSurfaceView.this).mTouchDownDanmuItem.senderUid, ((DanmakuSurfaceView)DanmakuSurfaceView.this).mTouchDownDanmuItem.content));
            }
        }
    };
    private HashMap<Integer, Integer> levelMap = new HashMap();

    public DanmakuSurfaceView(Context context) {
        super(context);
        this.init(context);
    }

    public DanmakuSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public void showView(ViewGroup rootView, RelativeLayout.LayoutParams params) {
        if (this.getParent() != null) {
            rootView.removeAllViews();
        }
        this.setZOrderOnTop(true);
        if (this.getHolder() != null) {
            this.getHolder().setFormat(-3);
        }
        TexturePool.uninit();
        rootView.addView((View)this, (ViewGroup.LayoutParams)params);
    }

    public void hideView(ViewGroup rootView) {
        if (this.getParent() != null) {
            rootView.removeView((View)this);
        }
    }

    public OnItemLongClickListener getOnItemLongClickListener() {
        return this.mOnItemLongClickListener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener onItemLongClickListener) {
        this.mOnItemLongClickListener = onItemLongClickListener;
    }

    private void init(Context context) {
        this.mLinesAvaliable = new HashMap<Integer, DanmuItem>();
        this.mHandlerThread = new HandlerThread("Danmaku-HandlerThread");
        this.mHandlerThread.start();
        this.mSafeDispatchHandler = new SafeDispatchHandler(this.mHandlerThread.getLooper());
        this.setEGLContextClientVersion(2);
        this.setEGLConfigChooser(8, 8, 8, 8, 16, 0);
        try {
            this.mRenderer = new DanmakuSurfaceViewRenderer(context, this);
            this.setRenderer(this.mRenderer);
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        this.getHolder().setFormat(-3);
        this.setZOrderOnTop(true);
        this.setRenderMode(0);
        this.setSpeed(120.0f);
        this.setLineSpace(4);
        this.mRenderer.setListener(new DanmakuSurfaceViewRenderer.RenderListener(){

            @Override
            public void onInited() {
            }

            @Override
            public void onOpenDanmuSwitch() {
                DanmakuSurfaceView.this.getAvaliableLine();
            }

            @Override
            public void onInitDrawMode() {
                DanmakuSurfaceView.this.setRenderMode(0);
            }

            @Override
            public void onListInit(CopyOnWriteArrayList<DanmuItem> list2) {
                if (list2 != null && DanmakuSurfaceView.this.danmuItemList != null) {
                    if (DanmakuSurfaceView.this.danmuItemList.size() > 0) {
                        DanmakuSurfaceView.this.danmuItemList.clear();
                    }
                    DanmakuSurfaceView.this.danmuItemList.addAll(list2);
                    if (list2.size() == 0) {
                        DanmakuSurfaceView.this.setRenderMode(0);
                    }
                }
            }

            @Override
            public void onSurfaceChanged(int width, int height) {
                DanmakuSurfaceView.this.setScreenWidth(width);
            }
        });
        for (int i = 0; i < this.gapLine; ++i) {
            this.levelMap.put(i, 1);
        }
    }

    public void setScreenWidth(float width) {
        this.width = width;
    }

    public void setDrawTime(int time) {
    }

    public void initFlag() {
        if (this.hashMap.size() > 0) {
            this.hashMap.clear();
        }
        for (int i = 0; i < this.gapLine; ++i) {
            this.hashMap.put(i, true);
        }
    }

    private void onBarrageSwitch(boolean on) {
        if (on) {
            this.mOnOff.set(true);
            if (this.switchListener != null) {
                this.switchListener.openSwitch();
            }
            this.initFlag();
            this.postTask(0);
        } else {
            this.mOnOff.set(false);
            if (this.switchListener != null) {
                this.switchListener.closeSwitch();
            }
            this.initFlag();
            if (this.mLinesAvaliable != null) {
                this.mLinesAvaliable.clear();
            }
            this.removeTask();
            if (this.danmuItemList != null && this.danmuItemList.size() > 0) {
                this.danmuItemList.clear();
            }
        }
    }

    public void initTexturePool() {
        TexturePool.uninit();
    }

    public void setOnSwitchListener(IDanmuSwitchListener listener2) {
        this.switchListener = listener2;
    }

    public boolean onDanmuSwitch() {
        return this.mOnOff.get();
    }

    public void setOpenView() {
        this.onBarrageSwitch(true);
    }

    public void setCloseView() {
        this.onBarrageSwitch(false);
    }

    public int getTopMargin() {
        return this.kTopMargin;
    }

    public void onResume() {
        super.onResume();
    }

    public void onPause() {
        super.onPause();
    }

    private synchronized boolean getAvaliableLine(int position) {
        if (position > this.gapLine) {
            return false;
        }
        if (this.mLinesAvaliable.get(position) == null) {
            this.setCheckStatus(position, true);
            return true;
        }
        DanmuItem danmaku = this.mLinesAvaliable.get(position);
        if (danmaku.getCurrentOffsetX() > (float)danmaku.getBitmapWidth()) {
            this.setCheckStatus(position, true);
            return true;
        }
        this.setCheckStatus(position, false);
        return false;
    }

    private synchronized void getAvaliableLine() {
        for (int i = 0; i < this.gapLine; ++i) {
            if (this.mLinesAvaliable.get(i) == null) {
                this.setCheckStatus(i, true);
                continue;
            }
            DanmuItem danmaku = this.mLinesAvaliable.get(i);
            if (danmaku == null) {
                this.setCheckStatus(i, true);
                continue;
            }
            if (danmaku.getCurrentOffsetX() > (float)danmaku.getBitmapWidth()) {
                this.setCheckStatus(i, true);
                continue;
            }
            this.setCheckStatus(i, false);
        }
    }

    public void setSpeed(float speed) {
        float pxSpeed = ScreenUtil.getInstance().dip2px(speed);
        this.mRenderer.setSpeed(pxSpeed);
    }

    public int getLines() {
        return this.gapLine;
    }

    public void setLines(int lines) {
        this.gapLine = lines;
        for (int i = 0; i < this.gapLine; ++i) {
            this.levelMap.put(i, 1);
        }
        if (this.hashMap != null && this.hashMap.size() > 0) {
            this.onBarrageSwitch(false);
            this.onBarrageSwitch(true);
            MLog.error((Object)TAG, (String)("reset onBarrageSwitch gapline= " + this.gapLine), (Object[])new Object[0]);
        }
    }

    public void setLineSpace(int lineSpace) {
        float pxLineSpace;
        this.mLineSpace = pxLineSpace = (float)ScreenUtil.getInstance().dip2px(lineSpace);
    }

    public void setCheckStatus(int position, boolean isOpen) {
        if (position < this.gapLine) {
            this.hashMap.put(position, isOpen);
        } else {
            MLog.error((Object)TAG, (String)("getLineStatus is line > gapLine , gapLine " + this.gapLine), (Object[])new Object[0]);
        }
    }

    public void sendGunPower(GunNewPower gun, int position) {
        if (gun == null || position < 0 || position >= this.gapLine) {
            return;
        }
        if (this.mOnOff.get() && this.getAvaliableLine(position) && gun != null && gun.bitmap != null) {
            this.setCheckStatus(position, false);
            DanmuItem danmakuItem = new DanmuItem(gun.gunId, gun.senderUid, gun.bitmap, gun.content);
            danmakuItem.pureText = gun.pureText;
            this.mLinesAvaliable.put(position, danmakuItem);
            float offsetY = (float)(danmakuItem.getmViewHeight() * position) + this.mLineSpace;
            danmakuItem.setOffsetY(offsetY);
            this.mRenderer.addDanmaku(danmakuItem);
            this.setRenderMode(1);
            this.requestRender();
        }
    }

    public void queryDanmuOpenStatus(IDanmuOpenStatus status) {
        this.danmuOpenStatus = status;
    }

    public void setOnClickListener(IDanmuClickListener clickListener) {
        this.listener = clickListener;
    }

    public void onDestory() {
        this.removeTask();
        if (Build.VERSION.SDK_INT >= 18) {
            if (this.mHandlerThread != null) {
                this.mHandlerThread.quitSafely();
                this.mHandlerThread = null;
                MLog.debug((Object)TAG, (String)"[onDestory] quitSafely", (Object[])new Object[0]);
            }
        } else {
            try {
                if (this.mHandlerThread != null) {
                    this.mHandlerThread.quit();
                    this.mHandlerThread = null;
                    MLog.debug((Object)TAG, (String)"[onDestory] quit", (Object[])new Object[0]);
                }
            }
            catch (Throwable e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
            try {
                this.removeCallbacks(this.mLongPressRunnable);
                this.removeCallbacks(this.mClickRunnable);
            }
            catch (Throwable throwable) {
                MLog.error((Object)TAG, (Throwable)throwable);
            }
            if (this.mSafeDispatchHandler != null) {
                this.mSafeDispatchHandler.removeCallbacksAndMessages(null);
                this.mSafeDispatchHandler = null;
            }
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        switch (event.getAction()) {
            case 0: {
                this.mDownMotionX = this.mLastMotionX = x;
                this.mDownMotionY = this.mLastMotionY = y;
                this.isMoved = false;
                this.isLongClick = false;
                this.postDelayed(this.mLongPressRunnable, 300L);
                this.mTouchDownDanmuItem = this.findDanmuWithLocation(x, y);
                return true;
            }
            case 2: {
                this.mLastMotionX = x;
                this.mLastMotionY = y;
                if (this.isMoved || Math.abs(this.mDownMotionX - x) <= 20 && Math.abs(this.mDownMotionY - y) <= 20) break;
                this.isMoved = true;
                this.removeCallbacks(this.mLongPressRunnable);
                return false;
            }
            case 1: {
                this.removeCallbacks(this.mLongPressRunnable);
                if (this.isLongClick || this.isMoved) break;
                this.post(this.mClickRunnable);
                break;
            }
        }
        return super.onTouchEvent(event);
    }

    private DanmuItem findDanmuWithLocation(int locX, int locY) {
        if (this.danmuItemList == null || this.danmuItemList.isEmpty()) {
            return null;
        }
        for (DanmuItem point : this.danmuItemList) {
            float x = this.width - point.offsetX;
            if (!((float)locX > x) || !((float)locX < x + (float)point.bitmapWidth) || !((float)locY > point.offsetY) || !((float)locY < point.offsetY + (float)point.bitmapHeight)) continue;
            MLog.info((Object)((Object)this), (String)String.format("X: %s locX: %s locY: %s offsetX: %s offsetY: %s bitmapWidth: %s bitmapHeight: %s", Float.valueOf(x), locX, locY, Float.valueOf(point.offsetX), Float.valueOf(point.offsetY), point.bitmapWidth, point.bitmapHeight), (Object[])new Object[0]);
            return point;
        }
        return null;
    }

    public synchronized HashMap<Integer, Integer> getLevelMap() {
        return this.levelMap;
    }

    public synchronized void setLevelMap(int index, int level) {
        this.levelMap.put(index, level);
    }

    public void setDanMuAlpha(int alpha) {
        MLog.info((Object)TAG, (String)("setDanMuAlpha alpha :" + alpha), (Object[])new Object[0]);
        if (this.mRenderer != null) {
            this.mRenderer.setDanmuAlpha((float)alpha / 100.0f);
        }
    }

    private void postTask(int delay) {
        this.removeTask();
        if (this.mSafeDispatchHandler != null) {
            this.mSafeDispatchHandler.removeCallbacks(this.scheduRunnable);
            this.mSafeDispatchHandler.postDelayed(this.scheduRunnable, (long)delay);
        }
    }

    private void removeTask() {
        if (this.mSafeDispatchHandler != null) {
            this.mSafeDispatchHandler.removeCallbacks(this.scheduRunnable);
        }
    }

    public static interface OnItemLongClickListener {
        public void onItemLongClick(long var1, String var3);
    }
}

