/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicgunview.danmucanvas.view;

import android.graphics.RectF;
import android.view.MotionEvent;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.ui.basicgunview.danmucanvas.Bean.BaseDanmaku;
import com.yy.mobile.ui.basicgunview.danmucanvas.controller.IDanmakuView;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.IDanmakuIterator;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.IDanmakus;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.android.Danmakus;
import com.yy.mobile.ui.basicgunview.danmuopengl.gunpower.DanMuItemStub;

public class DanmakuTouchHelper {
    private IDanmakuView danmakuView;
    private RectF mDanmakuBounds;

    private DanmakuTouchHelper(IDanmakuView danmakuView) {
        this.danmakuView = danmakuView;
        this.mDanmakuBounds = new RectF();
    }

    public static synchronized DanmakuTouchHelper instance(IDanmakuView danmakuView) {
        return new DanmakuTouchHelper(danmakuView);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                IDanmakus clickDanmakus = this.touchHitDanmaku(event.getX(), event.getY());
                if (null == clickDanmakus || clickDanmakus.isEmpty()) break;
                IDanmakuIterator iterator = clickDanmakus.iterator();
                while (iterator.hasNext()) {
                    BaseDanmaku danmaku = iterator.next();
                    if (danmaku == null || this.danmakuView.getIDanmakuClickListener() == null) continue;
                    this.danmakuView.getIDanmakuClickListener().setOnClickListener(new DanMuItemStub(danmaku.gunId, LoginUtil.getUid(), danmaku.content));
                }
                break;
            }
        }
        return false;
    }

    private void performClickWithlatest(BaseDanmaku newest) {
        if (this.danmakuView.getOnDanmakuClickListener() != null) {
            this.danmakuView.getOnDanmakuClickListener().onDanmakuClick(newest);
        }
    }

    private void performClick(IDanmakus danmakus) {
        if (this.danmakuView.getOnDanmakuClickListener() != null) {
            this.danmakuView.getOnDanmakuClickListener().onDanmakuClick(danmakus);
        }
    }

    private IDanmakus touchHitDanmaku(float x, float y) {
        Danmakus hitDanmakus = new Danmakus(4);
        this.mDanmakuBounds.setEmpty();
        IDanmakus danmakus = this.danmakuView.getCurrentVisibleDanmakus();
        if (null != danmakus && !danmakus.isEmpty()) {
            IDanmakuIterator iterator = danmakus.iterator();
            while (iterator.hasNext()) {
                BaseDanmaku danmaku = iterator.next();
                if (null == danmaku) continue;
                this.mDanmakuBounds.set(danmaku.getLeft(), danmaku.getTop(), danmaku.getRight(), danmaku.getBottom());
                if (!this.mDanmakuBounds.contains(x, y)) continue;
                hitDanmakus.addItem(danmaku);
            }
        }
        return hitDanmakus;
    }

    private BaseDanmaku fetchLatestOne(IDanmakus danmakus) {
        if (danmakus.isEmpty()) {
            return null;
        }
        return danmakus.last();
    }
}

