/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basefunction.followguide;

import com.duowan.mobile.basemedia.watchlive.template.IChannelBaseParam;
import com.duowan.mobile.basemedia.watchlive.template.Scene;
import com.yy.mobile.ui.basefunction.followguide.ABTestFollowGuideHandler;
import com.yy.mobile.ui.basefunction.followguide.ActionFollowGuideHandler;
import com.yy.mobile.ui.basefunction.followguide.LiveLoginGuideHandler;
import com.yy.mobile.util.log.MLog;

public class LoginFollowGuideManager {
    private static final String TAG = "LoginFollowGuideManager";
    public static final int SHOW_TYPE_FOLLOW_ACTION = 1;
    public static final int SHOW_TYPE_LOGIN_GUIDE = 2;
    public static final int SHOW_TYPE_FOLLOW_ABTEST_A = 3;
    public static final int SHOW_TYPE_FOLLOW_ABTEST_B = 4;
    public static final int SHOW_STATE_NONE = 0;
    public static final int SHOW_STATE_TENDING = 1;
    public static final int SHOW_STATE_SHOWING = 2;
    public static final int SHOW_STATE_SHOWN = 3;
    private ActionFollowGuideHandler mActionFollowGuideHandler = new ActionFollowGuideHandler();
    private ABTestFollowGuideHandler mABTestFollowGuideHandler = new ABTestFollowGuideHandler();
    private LiveLoginGuideHandler mLiveLoginGuideHandler = new LiveLoginGuideHandler();
    private Scene mCurrentScene;
    private IChannelBaseParam mChannelParam;
    private boolean mIsLandscape;
    private static LoginFollowGuideManager INSTANCE;

    private LoginFollowGuideManager() {
    }

    public static LoginFollowGuideManager instance() {
        if (INSTANCE == null) {
            INSTANCE = new LoginFollowGuideManager();
        }
        return INSTANCE;
    }

    public void init() {
        this.mActionFollowGuideHandler.init();
        this.mABTestFollowGuideHandler.init();
        this.mLiveLoginGuideHandler.init();
    }

    public void setIsLandscape(boolean isLandscape) {
        MLog.info((Object)TAG, (String)("setIsLandscape: " + isLandscape), (Object[])new Object[0]);
        this.mIsLandscape = isLandscape;
    }

    public void setLiveScene(Scene scene, IChannelBaseParam channelParam) {
        MLog.info((Object)TAG, (String)("setLiveScene: " + scene + ", mChannelParam=" + channelParam), (Object[])new Object[0]);
        this.mCurrentScene = scene;
        this.mChannelParam = channelParam;
    }

    public Scene getLiveScene() {
        return this.mCurrentScene;
    }

    public void uninit() {
        this.mActionFollowGuideHandler.release();
        this.mABTestFollowGuideHandler.release();
        this.mLiveLoginGuideHandler.release();
    }

    public void sceneInitDone() {
        this.mABTestFollowGuideHandler.sceneInitDone();
        this.mLiveLoginGuideHandler.sceneInitDone();
    }

    public void showFollowGuide(int type2) {
        MLog.info((Object)TAG, (String)("showFollowGuide: scene=" + this.mCurrentScene + ", type=" + type2 + ", mIsLandscape=" + this.mIsLandscape), (Object[])new Object[0]);
        if (this.isAbleToShowFollowGuide() && type2 == 1) {
            this.mActionFollowGuideHandler.showFollowGuide();
        }
    }

    public void updateFollowGuideShownState(int type2, boolean isShown) {
        switch (type2) {
            case 1: {
                this.mActionFollowGuideHandler.updateFollowGuideShownState(isShown);
                break;
            }
            case 3: {
                this.mABTestFollowGuideHandler.updateFollowGuideShownState(isShown);
                break;
            }
            case 4: {
                this.mABTestFollowGuideHandler.updateFollowGuideShownState(isShown);
                break;
            }
            case 2: {
                this.mLiveLoginGuideHandler.updateFollowGuideShownState(isShown);
                break;
            }
        }
    }

    public void followAnchorSuccess(int type2) {
        switch (type2) {
            case 1: {
                this.mActionFollowGuideHandler.followAnchorSuccess();
                break;
            }
            case 3: {
                this.mABTestFollowGuideHandler.followAnchorSuccess();
                break;
            }
            case 4: {
                this.mABTestFollowGuideHandler.followAnchorSuccess();
                break;
            }
        }
    }

    public void navToLoginFromGuide() {
        this.mLiveLoginGuideHandler.navToLoginFromGuide();
    }

    public void initFollowGuideCarrier(String fromTag) {
        MLog.debug((Object)TAG, (String)("initFollowGuideCarrier: " + fromTag), (Object[])new Object[0]);
        this.mActionFollowGuideHandler.enterLiveRoom();
        this.mABTestFollowGuideHandler.enterLiveRoom();
    }

    public void checkShowLoginFlower() {
        this.mLiveLoginGuideHandler.checkShowLoginFlower();
    }

    public int getFollowGuideShowState(int type2) {
        if (type2 == 1) {
            return this.mActionFollowGuideHandler.getFollowGuideShowState();
        }
        if (type2 == 3 || type2 == 4) {
            return this.mABTestFollowGuideHandler.getFollowGuideShowState();
        }
        return 0;
    }

    public boolean isAbleToShowFollowGuide() {
        if (this.mIsLandscape) {
            return false;
        }
        return this.mCurrentScene == Scene.ENTERTAINMENT;
    }
}

