/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.swivelChair;

import android.content.Context;
import android.graphics.Color;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.swivelChair.SwivelChairGamePannel;
import com.yy.mobile.ui.widget.CustomStrokeTextView;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import java.lang.ref.WeakReference;

public class SCGameChair
implements View.OnTouchListener {
    private static final String TAG = "SCGameChair";
    private Context mContext;
    private int strokeWidth = 8;
    private int fontSize = 18;
    private View view;
    private int chairPos;
    private CustomStrokeTextView mBettingMoneyTxt;
    private LinearLayout mTxtMultipleLayout;
    private RelativeLayout mMultipleLayout;
    private RelativeLayout.LayoutParams layoutParams;
    private RecycleImageView mMultipleBgIcon;
    private RecycleImageView mChairImg;
    private RelativeLayout mAnchorInfoLayout;
    private LinearLayout mBettingMoneyLayout;
    private RecycleImageView mChairRivSelected;
    private WeakReference<SwivelChairGamePannel.OnChairItemClickEvent> onChairItemClickEventWeakRef;
    private boolean isloadSelected = false;
    private TextView mAnchorNameText;
    private CircleImageView mAnchorHeadCiv;
    private String mIconUrl = "";
    private boolean animationRun = false;
    private boolean isBetting = false;
    private int frameTime = 30;
    private int frameIndex = 0;
    private LinearLayout mChairContairLayout;
    private int multiple;
    private int[] chairFrameImgIds = new int[]{R.drawable.swivelchair_bm_1, R.drawable.swivelchair_bm_2, R.drawable.swivelchair_bm_3, R.drawable.swivelchair_bm_4, R.drawable.swivelchair_bm_5, R.drawable.swivelchair_bm_6, R.drawable.swivelchair_bm_7, R.drawable.swivelchair_bm_10, R.drawable.swivelchair_bm_10, R.drawable.swivelchair_bm_10};
    private int[] multNumber = new int[]{R.drawable.sc_0, R.drawable.sc_1, R.drawable.sc_2, R.drawable.sc_3, R.drawable.sc_4, R.drawable.sc_5, R.drawable.sc_6, R.drawable.sc_7, R.drawable.sc_8, R.drawable.sc_9};
    private SafeDispatchHandler handler = new SafeDispatchHandler(Looper.getMainLooper());
    private Animation animDwon;
    private Animation animUp;
    private boolean needUp = false;
    private Runnable frameAnimRunnable = new Runnable(){

        @Override
        public void run() {
            ImageLoader.loadImageBackgroundResource((int)SCGameChair.this.chairFrameImgIds[SCGameChair.this.frameIndex], (View)SCGameChair.this.mChairImg, (ImageConfig)ImageConfig.defaultImageConfig());
            SCGameChair.this.frameIndex++;
            if (SCGameChair.this.frameIndex == SCGameChair.this.chairFrameImgIds.length) {
                SCGameChair.this.frameIndex = 0;
                SCGameChair.this.animationRun = false;
                if (!SCGameChair.this.mIconUrl.equals("") || SCGameChair.this.mIconUrl == null) {
                    ImageLoader.loadImage((String)SCGameChair.this.mIconUrl, (RecycleImageView)SCGameChair.this.mAnchorHeadCiv, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait);
                }
            } else if (SCGameChair.this.animationRun) {
                SCGameChair.this.handler.postDelayed((Runnable)this, (long)SCGameChair.this.frameTime);
            }
        }
    };

    public SCGameChair(Context context, int pos) {
        this.mContext = context;
        this.chairPos = pos;
        this.view = LayoutInflater.from((Context)context).inflate(R.layout.item_swivelchair_chair, null);
        this.animDwon = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.swivelchair_click_down);
        this.animUp = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.swivelchair_click_up);
        this.mBettingMoneyTxt = (CustomStrokeTextView)this.view.findViewById(R.id.betting_money_tx);
        this.mBettingMoneyTxt.setStorekeColor(this.fontSize, this.strokeWidth, 151, 72, 33);
        this.mBettingMoneyTxt.setTextColor(Color.rgb((int)255, (int)249, (int)223));
        this.mAnchorNameText = (TextView)this.view.findViewById(R.id.anchor_name_tx);
        this.mMultipleBgIcon = (RecycleImageView)this.view.findViewById(R.id.multiple_bg_icon);
        this.mChairRivSelected = (RecycleImageView)this.view.findViewById(R.id.chair_riv_selected);
        this.mAnchorHeadCiv = (CircleImageView)this.view.findViewById(R.id.anchor_head_civ);
        this.mTxtMultipleLayout = (LinearLayout)this.view.findViewById(R.id.txt_multiple_ll);
        this.mMultipleLayout = (RelativeLayout)this.view.findViewById(R.id.multiple_rl);
        this.mChairImg = (RecycleImageView)this.view.findViewById(R.id.chair_riv);
        this.mChairContairLayout = (LinearLayout)this.view.findViewById(R.id.chair_contair_ll);
        this.mChairContairLayout.setOnTouchListener((View.OnTouchListener)this);
        ImageLoader.loadImageBackgroundResource((int)R.drawable.swivelchair_yz_bm, (View)this.mChairImg, (ImageConfig)ImageConfig.defaultImageConfig());
        this.mAnchorInfoLayout = (RelativeLayout)this.view.findViewById(R.id.anchor_info_rl);
        this.mBettingMoneyLayout = (LinearLayout)this.view.findViewById(R.id.betting_money_ll);
        this.layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        if (this.chairPos > 3 || this.chairPos == 2) {
            this.layoutParams.addRule(9);
        } else if (this.chairPos == 1 || this.chairPos == 3 || this.chairPos == 0) {
            this.layoutParams.addRule(11);
        }
        this.mMultipleLayout.setLayoutParams((ViewGroup.LayoutParams)this.layoutParams);
        if (this.mMultipleBgIcon != null) {
            if (this.chairPos > 3) {
                ImageLoader.loadImageBackgroundResource((int)R.drawable.reward_icon_1, (View)this.mMultipleBgIcon, (ImageConfig)ImageConfig.defaultImageConfig());
            } else if (this.chairPos == 2 || this.chairPos == 3) {
                ImageLoader.loadImageBackgroundResource((int)R.drawable.reward_icon_2, (View)this.mMultipleBgIcon, (ImageConfig)ImageConfig.defaultImageConfig());
            } else if (this.chairPos == 0 || this.chairPos == 1) {
                ImageLoader.loadImageBackgroundResource((int)R.drawable.reward_icon_3, (View)this.mMultipleBgIcon, (ImageConfig)ImageConfig.defaultImageConfig());
            }
        }
        this.resetChairState();
    }

    public View getChairView() {
        return this.view;
    }

    public void onDestroy() {
        this.handler.removeCallbacksAndMessages(null);
    }

    public void setData(int multiple) {
        this.multiple = multiple;
        char[] chars = String.valueOf(multiple).toCharArray();
        this.mTxtMultipleLayout.removeAllViews();
        for (int idx = 0; idx < chars.length; ++idx) {
            RecycleImageView number = new RecycleImageView(this.mContext);
            ImageLoader.loadImageBackgroundResource((int)this.multNumber[Integer.parseInt(chars[idx] + "")], (View)number, (ImageConfig)ImageConfig.defaultImageConfig());
            this.mTxtMultipleLayout.addView((View)number);
        }
        RecycleImageView scMultImg = new RecycleImageView(this.mContext);
        ImageLoader.loadImageBackgroundResource((int)R.drawable.sc_mult, (View)scMultImg, (ImageConfig)ImageConfig.defaultImageConfig());
        this.mTxtMultipleLayout.addView((View)scMultImg);
        if (this.mMultipleLayout.getVisibility() != 0) {
            this.mMultipleLayout.setVisibility(0);
        }
        if (this.mChairRivSelected != null && this.mChairRivSelected.getVisibility() == 0) {
            this.mChairRivSelected.setVisibility(4);
        }
    }

    public void setOnChairItemClickEventWeakRef(SwivelChairGamePannel.OnChairItemClickEvent onChairItemClickEvent) {
        if (this.onChairItemClickEventWeakRef == null) {
            this.onChairItemClickEventWeakRef = new WeakReference<SwivelChairGamePannel.OnChairItemClickEvent>(onChairItemClickEvent);
        }
    }

    public void setBettingDiamondData(int baseBetting) {
        if (baseBetting <= 0) {
            return;
        }
        this.mBettingMoneyTxt.setText((CharSequence)Integer.toString(baseBetting));
        if (this.mBettingMoneyLayout.getVisibility() == 4) {
            this.mBettingMoneyLayout.setVisibility(0);
        }
        this.isBetting = true;
    }

    public int getBetDiamond() {
        String bettingMoney = this.mBettingMoneyTxt.getText().toString();
        if (this.mBettingMoneyTxt != null) {
            if (!StringUtils.isEmpty((String)bettingMoney).booleanValue()) {
                return StringUtils.safeParseInt((String)bettingMoney);
            }
            return 0;
        }
        return 0;
    }

    public void clearBettingDiamondData() {
        String bettingMoney = this.mBettingMoneyTxt.getText().toString();
        if (StringUtils.isEmpty((String)bettingMoney).booleanValue()) {
            return;
        }
        this.mBettingMoneyTxt.setText((CharSequence)"");
        this.mBettingMoneyLayout.setVisibility(4);
    }

    public void setAnchorName(String anchorName) {
        this.mAnchorNameText.setText((CharSequence)anchorName);
        this.mAnchorInfoLayout.setVisibility(0);
    }

    public void resetResultChairState() {
        this.mAnchorHeadCiv.setImageDrawable(null);
        ImageLoader.loadImageBackgroundResource((int)R.drawable.swivelchair_yz_bm, (View)this.mChairImg, (ImageConfig)ImageConfig.defaultImageConfig());
        this.resetChairState();
    }

    public void resetChairState() {
        if (this.mAnchorInfoLayout != null && this.mAnchorInfoLayout.getVisibility() == 0) {
            this.mAnchorInfoLayout.setVisibility(4);
        }
        if (this.mBettingMoneyLayout != null && this.mBettingMoneyLayout.getVisibility() == 0) {
            this.mBettingMoneyLayout.setVisibility(4);
        }
        if (this.mMultipleLayout != null && this.mMultipleLayout.getVisibility() == 0) {
            this.mMultipleLayout.setVisibility(4);
        }
        if (this.mChairRivSelected != null && this.mChairRivSelected.getVisibility() == 0) {
            this.mChairRivSelected.setVisibility(4);
        }
    }

    public void setSelectedState(boolean state) {
        if (state) {
            if (!this.isloadSelected) {
                this.isloadSelected = true;
                ImageLoader.loadImageBackgroundResource((int)R.drawable.swivelchair_selected, (View)this.mChairRivSelected, (ImageConfig)ImageConfig.defaultImageConfig());
            }
            this.mChairRivSelected.setVisibility(0);
        } else {
            this.mChairRivSelected.setVisibility(4);
        }
    }

    public void startChairAnimation() {
        this.animationRun = true;
        this.handler.removeCallbacks(this.frameAnimRunnable);
        this.handler.postDelayed(this.frameAnimRunnable, (long)this.frameTime);
    }

    public void stopChairAnimation() {
        this.animationRun = false;
        this.handler.removeCallbacks(this.frameAnimRunnable);
        this.frameIndex = 0;
    }

    public boolean isBetting() {
        return this.isBetting;
    }

    public void setBetting(boolean betting) {
        this.isBetting = betting;
    }

    public void setmIconUrl(String mIconUrl) {
        this.mIconUrl = mIconUrl;
    }

    public boolean onTouch(View v, MotionEvent event) {
        LinearLayout layout2 = (LinearLayout)v;
        switch (event.getAction()) {
            case 0: {
                SwivelChairGamePannel.OnChairItemClickEvent e;
                if (!SwivelChairGamePannel.canBetRank || SwivelChairGamePannel.needUp) break;
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)TAG, (String)("wwd swivelchair actionDown SwivelChairGamePannel.needUp=" + SwivelChairGamePannel.needUp + "|SwivelChairGamePannel.canBetRank=" + SwivelChairGamePannel.canBetRank), (Object[])new Object[0]);
                }
                layout2.startAnimation(this.animDwon);
                this.animDwon.setFillAfter(true);
                this.needUp = true;
                SwivelChairGamePannel.OnChairItemClickEvent onChairItemClickEvent = e = this.onChairItemClickEventWeakRef != null ? (SwivelChairGamePannel.OnChairItemClickEvent)this.onChairItemClickEventWeakRef.get() : null;
                if (e == null) break;
                e.clickEvent(this.chairPos);
                break;
            }
            case 1: {
                if (!this.needUp) break;
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)TAG, (String)("wwd swivelchair actionUp needUp=" + this.needUp + "  SwivelChairGamePannel.needUp=" + SwivelChairGamePannel.needUp), (Object[])new Object[0]);
                }
                this.needUp = false;
                SwivelChairGamePannel.needUp = false;
                layout2.startAnimation(this.animUp);
                this.animUp.setFillAfter(true);
                break;
            }
        }
        return true;
    }

    public int getMultiple() {
        return this.multiple;
    }
}

