/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.redpacket.ui;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.duowan.mobile.entlive.events.IRedPacketClient_receiveMsgRedPacketList_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onChatEmotionComponentDismiss_EventArgs;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onShowChatInputBroadcast_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.PluginBus;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.redpacket.IRedPacketProperty;
import com.yy.mobile.ui.redpacket.PageCategory;
import com.yy.mobile.ui.redpacket.RedPacketController;
import com.yy.mobile.ui.redpacket.RedPacketItem;
import com.yy.mobile.ui.redpacket.ui.RedPacketResultListComponent$$EventBinder;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.ui.utils.MoneyUtil;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.redpacket.GrabRedPacketInfo;
import java.util.ArrayList;

public class RedPacketResultListComponent
extends Component
implements IRedPacketProperty,
View.OnClickListener {
    public static final String TAG = "RedPacketResultListComponent";
    private static int detaY = -80;
    protected View rootView;
    protected CircleImageView iconUser;
    protected TextView tvUserName;
    protected TextView tvVault;
    protected RecycleImageView iconClose;
    protected TextView tvRobMoney;
    protected TextView tvRemain;
    protected TextView tvBottom;
    protected TextView tvBottomBludDiamond;
    protected TextView tvBottomGold;
    protected TextView tvTotal;
    protected LinearLayout layoutList;
    protected View imgRedIcon;
    GrabRedPacketInfo info;
    RedPacketItem mRedPacketItem = new RedPacketItem();
    boolean isC;
    private EventBinder mRedPacketResultListComponentSniperEventBinder;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle arg = this.getArguments();
        if (arg != null) {
            this.info = (GrabRedPacketInfo)arg.getParcelable("result");
            this.isC = arg.getBoolean("c");
            if (this.info != null && MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)("->onCreate grabuser=" + this.info.grabUser), (Object[])new Object[0]);
            }
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        try {
            this.rootView = inflater.inflate(R.layout.redpacket_result_list_layout, container, false);
            this.rootView.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    return true;
                }
            });
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)throwable.getMessage(), (Object[])new Object[0]);
            return null;
        }
        this.initView(this.rootView);
        return this.rootView;
    }

    public void onHiddenChanged(boolean hidden) {
        Bundle arg;
        super.onHiddenChanged(hidden);
        if (!hidden && (arg = this.getArguments()) != null) {
            this.info = (GrabRedPacketInfo)arg.getParcelable("result");
            this.isC = arg.getBoolean("c");
            if (this.info != null && MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)("->onHiddenChanged grabuser=" + this.info.grabUser), (Object[])new Object[0]);
            }
            if (this.rootView != null) {
                this.setRedPacketInfo();
            }
        }
    }

    private void initView(View rootView) {
        if (this.getResources().getConfiguration().orientation == 1) {
            detaY = -(this.dp(360) - (ResolutionUtils.getScreenHeight((Context)this.getActivity()) / 2 - this.dp(120)));
        }
        this.iconUser = (CircleImageView)rootView.findViewById(R.id.icon_user);
        this.tvUserName = (TextView)rootView.findViewById(R.id.tv_user_name);
        this.tvVault = (TextView)rootView.findViewById(R.id.tv_vault);
        this.iconClose = (RecycleImageView)rootView.findViewById(R.id.icon_close);
        this.iconClose.setOnClickListener((View.OnClickListener)this);
        this.tvVault.setOnClickListener((View.OnClickListener)this);
        this.tvRobMoney = (TextView)rootView.findViewById(R.id.tv_rob_money);
        this.tvRemain = (TextView)rootView.findViewById(R.id.tv_remain);
        this.tvBottom = (TextView)rootView.findViewById(R.id.tv_bottom);
        this.tvBottomGold = (TextView)rootView.findViewById(R.id.tv_bottom_gold);
        this.tvBottomBludDiamond = (TextView)rootView.findViewById(R.id.tv_bottom_blud_diamond);
        this.tvTotal = (TextView)rootView.findViewById(R.id.tv_total);
        this.layoutList = (LinearLayout)rootView.findViewById(R.id.layout_list);
        this.imgRedIcon = rootView.findViewById(R.id.icon_red);
        this.setRedPacketInfo();
    }

    private void setRedPacketInfo() {
        if (RedPacketController.getInstatnce().isKeyBoardShown() && this.rootView.getTranslationY() == 0.0f) {
            this.rootView.setTranslationY((float)detaY);
        }
        if (this.info != null) {
            if (this.info.grabUser != null) {
                this.tvVault.setVisibility(this.info.grabUser.isAnchor && (this.info.isAnchor || this.info.moneyType == 2) ? 0 : 8);
                this.tvRemain.setVisibility(4);
                if (this.info.owerUid > 0L && this.info.owerUid == this.info.toUId) {
                    this.tvBottom.setVisibility(0);
                    this.tvBottomGold.setVisibility(4);
                    this.tvBottomBludDiamond.setVisibility(4);
                    if (this.info.grabUser.money > 0L) {
                        this.tvBottom.setText((CharSequence)this.getString(R.string.red_packet_bag_info));
                    } else {
                        this.tvBottom.setText((CharSequence)"");
                    }
                } else if (this.info.grabUser.isAnchor && this.info.isAnchor) {
                    this.tvBottom.setVisibility(4);
                    this.tvBottomGold.setVisibility(0);
                    this.tvBottomBludDiamond.setVisibility(0);
                    this.tvBottomBludDiamond.setText((CharSequence)this.getString(R.string.red_packet_diamond, new Object[]{String.valueOf(this.info.diamond)}));
                    this.tvBottomGold.setText((CharSequence)this.getString(R.string.red_packet_gold, new Object[]{MoneyUtil.rediamondToYb((long)this.info.gold)}));
                } else if (this.info.grabUser.uid > 0L && this.info.grabUser.uid == this.info.owerUid) {
                    this.tvBottom.setVisibility(0);
                    this.tvBottomGold.setVisibility(4);
                    this.tvBottomBludDiamond.setVisibility(4);
                    this.tvBottom.setText((CharSequence)this.getString(R.string.red_packet_bag_info2));
                    if (!this.info.isAnchor) {
                        this.tvBottom.setText((CharSequence)"");
                    }
                    if (this.info.remain > 0L) {
                        this.tvRemain.setVisibility(0);
                        this.tvRemain.setText((CharSequence)this.getString(R.string.red_packet_remain, new Object[]{StringUtils.formatCommonSeperate((Object)this.info.remain)}));
                    }
                } else {
                    this.tvBottom.setVisibility(0);
                    this.tvBottomGold.setVisibility(4);
                    this.tvBottomBludDiamond.setVisibility(4);
                    if (this.info.grabUser.money > 0L) {
                        this.tvBottom.setText((CharSequence)this.getString(R.string.red_packet_bag_info));
                    } else {
                        this.tvBottom.setText((CharSequence)"");
                    }
                }
                ImageLoader.loadImage((String)this.info.owerIcon, (RecycleImageView)this.iconUser, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.search_anchor_icon);
                if (!StringUtils.isEmpty((String)this.info.owerNick).booleanValue()) {
                    String name = this.info.owerNick;
                    if (name.length() > 10) {
                        name = name.substring(0, 10) + "...";
                    }
                    this.tvUserName.setText((CharSequence)(name + "\u7684\u7ea2\u5305"));
                }
                if (this.info.grabUser.money > 0L) {
                    this.tvRobMoney.setTextSize(35.0f);
                    this.tvRobMoney.setText((CharSequence)String.valueOf(this.info.grabUser.money));
                    this.imgRedIcon.setVisibility(0);
                } else {
                    if (this.info.result == 5) {
                        this.tvRobMoney.setText((CharSequence)"\u672c\u8f6e\u7ea2\u5305\u5df2\u7ed3\u675f");
                    } else {
                        this.tvRobMoney.setText((CharSequence)this.getString(R.string.red_packet_over));
                    }
                    this.tvRobMoney.setTextSize(16.0f);
                    this.imgRedIcon.setVisibility(8);
                }
                StringBuilder sb = new StringBuilder();
                int start1 = 0;
                int end1 = 0;
                int start2 = 0;
                int end2 = 0;
                int start3 = 0;
                int end3 = 0;
                sb.append("\u7ea2\u5305\u91d1\u989d\u5171");
                start1 = 0;
                end1 = sb.length();
                String money = "";
                try {
                    money = StringUtils.formatCommonSeperate((Object)this.info.total);
                }
                catch (Exception ex) {
                    money = String.valueOf(this.info.total);
                }
                sb.append(money);
                start2 = end1;
                end2 = sb.length();
                if (this.info.grabnum == this.info.sendnum) {
                    sb.append("\u6d3b\u52a8\u7ea2\u94bb,\u88ab ");
                    sb.append(String.valueOf(this.info.grabnum));
                    sb.append("\u4eba\u62a2\u5b8c");
                } else {
                    sb.append("\u6d3b\u52a8\u7ea2\u94bb,\u6709 ");
                    sb.append(String.valueOf(this.info.grabnum));
                    sb.append("\u4eba\u6765\u62a2");
                }
                start3 = end2;
                end3 = sb.length();
                SpannableString ss = new SpannableString((CharSequence)sb.toString());
                ss.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#999999")), start1, end1, 33);
                ss.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#9f767a")), start2, end2, 33);
                ss.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#999999")), start3, end3, 33);
                this.tvTotal.setText((CharSequence)ss);
                this.layoutList.removeAllViews();
                if (this.info.grabUserList != null) {
                    ArrayList users = this.info.grabUserList.size() >= 3 ? this.info.grabUserList.subList(0, 3) : this.info.grabUserList;
                    int index = 0;
                    int size = this.info.grabUserList.size();
                    for (GrabRedPacketInfo.RedPacketUser user : users) {
                        View item2 = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.layout_red_packet_result_item, (ViewGroup)this.layoutList, false);
                        this.initItems(item2, user, ++index);
                        if (size < 3) {
                            this.layoutList.addView(item2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
                            continue;
                        }
                        this.layoutList.addView(item2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 1.0f));
                    }
                }
            }
            this.mRedPacketItem.className = this.getClass().getCanonicalName();
            this.mRedPacketItem.isNeedReplace = true;
            this.mRedPacketItem.redPacketId = this.info.redPacketId;
            this.mRedPacketItem.category = this.isC ? PageCategory.C : PageCategory.B;
        }
    }

    private void initItems(View item2, GrabRedPacketInfo.RedPacketUser user, int index) {
        TextView tvNum = (TextView)item2.findViewById(R.id.tv_num);
        RecycleImageView ivUser = (RecycleImageView)item2.findViewById(R.id.iv_user);
        TextView tvNick = (TextView)item2.findViewById(R.id.tv_nick);
        TextView tvDiamond = (TextView)item2.findViewById(R.id.tv_diamond);
        tvNum.setText((CharSequence)String.valueOf(index));
        ImageLoader.loadImage((String)user.icon, (RecycleImageView)ivUser, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait);
        if (!FP.empty((CharSequence)user.nick)) {
            if (user.nick.length() > 8) {
                tvNick.setText((CharSequence)(user.nick.substring(0, 8) + "..."));
            } else {
                tvNick.setText((CharSequence)user.nick);
            }
        } else {
            tvNick.setText((CharSequence)"");
        }
        tvDiamond.setText((CharSequence)String.valueOf(user.money));
        if (index == 1) {
            tvNum.setBackgroundResource(R.drawable.circle_num_bg_1);
        } else if (index == 2) {
            tvNum.setBackgroundResource(R.drawable.circle_num_bg_2);
        } else if (index == 3) {
            tvNum.setBackgroundResource(R.drawable.circle_num_bg_3);
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.icon_close) {
            RedPacketController.getInstatnce().removeComponent(this.getActivity().getSupportFragmentManager(), TAG, true);
        } else if (v.getId() == R.id.tv_vault) {
            RedPacketController.getInstatnce().showVaultComponent(this.getChildFragmentManager());
        }
    }

    @BusEvent
    public void onChatEmotionComponentDismiss(IChatEmotionClient_onChatEmotionComponentDismiss_EventArgs busEventArgs) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"[onChatEmotionComponentDismiss] close input@@", (Object[])new Object[0]);
        }
        if (this.getResources().getConfiguration().orientation == 1 && this.rootView != null && !this.isHidden()) {
            this.rootView.animate().translationY(0.0f);
        }
    }

    @BusEvent
    public void onShowChatInputBroadcast(IChatEmotionClient_onShowChatInputBroadcast_EventArgs busEventArgs) {
        boolean showChatInput = busEventArgs.getShowChatInput();
        if (this.getResources().getConfiguration().orientation == 1 && this.rootView != null && !this.isHidden() && showChatInput && this.rootView.getTranslationY() == 0.0f) {
            this.rootView.animate().translationY((float)detaY);
        }
    }

    private int dp(int val) {
        return DensityUtil.dip2px((Context)this.getActivity(), (float)val);
    }

    @Override
    public RedPacketItem getRedPacketProperty() {
        return this.mRedPacketItem;
    }

    public void onDestroy() {
        PluginBus.INSTANCE.get().post((Object)new IRedPacketClient_receiveMsgRedPacketList_EventArgs());
        super.onDestroy();
        RedPacketController.getInstatnce().removeRedPacketProperty(this);
    }

    protected void onViewCreated(View view, Bundle bundle) {
        if (this.mRedPacketResultListComponentSniperEventBinder == null) {
            this.mRedPacketResultListComponentSniperEventBinder = new RedPacketResultListComponent$$EventBinder();
        }
        this.mRedPacketResultListComponentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, bundle);
    }

    protected void onDestroyView() {
        super.onDestroyView();
        if (this.mRedPacketResultListComponentSniperEventBinder != null) {
            this.mRedPacketResultListComponentSniperEventBinder.unBindEvent();
        }
    }
}

