/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.plugincenter.component;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.yy.android.small.Small;
import com.yy.android.sniper.annotation.mvp.DelegateBind;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.mvp.MvpDialogFragment;
import com.yy.mobile.plugin.Plugins;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.IComponentRoot;
import com.yy.mobile.ui.basicfunction.uicore.IBasicFunctionCore;
import com.yy.mobile.ui.plugincenter.authority.AuthorityController;
import com.yy.mobile.ui.plugincenter.presenter.PluginCenterDecoration;
import com.yy.mobile.ui.plugincenter.presenter.PluginCenterPresenter;
import com.yy.mobile.ui.utils.ActivityCheckerUtils;
import com.yy.mobile.ui.utils.DimensUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ResolutionUtils;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.plugincenter.IPluginCenterCore;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.util.Collection;

@DelegateBind(presenter=PluginCenterPresenter.class)
public class PluginCenterComponent
extends MvpDialogFragment<PluginCenterPresenter, PluginCenterComponent> {
    private static final String TAG = "PluginCenterComponent";
    private IComponentRoot mRoot;
    private RecyclerView mRecyclerView;
    private Button mAuthorityBtn;
    private ProgressBar mLoadingProgress;
    private TextView mNodataTipView;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(0, 16973834);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.setCanceledOnTouchOutside(true);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setBackgroundDrawableResource(R.color.transparent);
        dialog.getWindow().setFlags(1024, 1024);
        dialog.getWindow().setGravity(80);
        dialog.getWindow().clearFlags(2);
        this.setComponentSize(dialog.getWindow(), this.getCachedPluginSize());
        return dialog;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.entlive_plugincenter_fragment, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mAuthorityBtn = (Button)view.findViewById(R.id.entlive_plugincenter_authority);
        this.mAuthorityBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PluginCenterComponent.this.showAuthorityController();
            }
        });
        this.mLoadingProgress = (ProgressBar)view.findViewById(R.id.entlive_plugincenter_view_loading);
        this.mNodataTipView = (TextView)view.findViewById(R.id.entlive_plugincenter_no_data_tips);
        this.initRecyclerView(view);
        ((PluginCenterPresenter)this.getPresenter()).onViewCreated(this.getArguments());
    }

    private void initRecyclerView(View view) {
        this.mRecyclerView = (RecyclerView)view.findViewById(R.id.entlive_plugincenter_recyclerview);
        if (this.isLandscape()) {
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 0, false));
        } else {
            int screenWidth = ResolutionUtils.getScreenWidth((Context)this.getContext());
            int horizontalPadding = (screenWidth - 3 * DimensUtils.dip2pixel((Context)this.getContext(), (float)84.0f)) / 6;
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), 3));
            this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new PluginCenterDecoration(horizontalPadding));
        }
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)((PluginCenterPresenter)this.getPresenter()).getAdapter());
    }

    private int getCachedPluginSize() {
        IPluginCenterCore pluginCenterCore = (IPluginCenterCore)CoreFactory.getCore(IPluginCenterCore.class);
        if (null == pluginCenterCore || null == pluginCenterCore.getPluginInfo()) {
            return 0;
        }
        return FP.size((Collection)pluginCenterCore.getPluginInfo().plugs);
    }

    public void setComponentSize(int pluginListSize) {
        if (null != this.getDialog()) {
            this.setComponentSize(this.getDialog().getWindow(), pluginListSize);
        }
    }

    private void setComponentSize(Window window, int pluginListSize) {
        if (null == window || !ActivityCheckerUtils.isActivityValid((Activity)this.getActivity())) {
            return;
        }
        int height = this.isLandscape() ? DimensUtils.dip2pixel((Context)this.getActivity(), (float)160.0f) : (pluginListSize <= 6 ? DimensUtils.dip2pixel((Context)this.getActivity(), (float)280.0f) : DimensUtils.dip2pixel((Context)this.getActivity(), (float)300.0f));
        window.setLayout(-1, height);
    }

    public boolean isLandscape() {
        try {
            return this.getResources().getConfiguration().orientation == 2;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void onDismiss(DialogInterface dialog) {
        if (((IBasicFunctionCore)ICoreManagerBase.getCore(IBasicFunctionCore.class)).isSlideFunctionComponentShowing()) {
            ((IBasicFunctionCore)ICoreManagerBase.getCore(IBasicFunctionCore.class)).hideSlideFunctionsComponent();
        }
        super.onDismiss(dialog);
    }

    private void showAuthorityController() {
        if (!ActivityCheckerUtils.isActivityValid((Activity)this.getActivity())) {
            return;
        }
        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51710", "0010");
        AuthorityController authorityController = new AuthorityController();
        if (!AuthorityController.isShow) {
            AuthorityController.isShow = true;
            authorityController.show(this.getActivity().getSupportFragmentManager(), "AuthorityController");
        }
    }

    public void setAuthorityVisibility(int visibility) {
        if (null != this.mAuthorityBtn) {
            this.mAuthorityBtn.setVisibility(visibility);
        }
    }

    public void setNodataTipVisibility(int visibility) {
        if (null != this.mNodataTipView) {
            this.mNodataTipView.setVisibility(visibility);
        }
    }

    public void setLoadingVisibility(int visibility) {
        if (null != this.mLoadingProgress) {
            this.mLoadingProgress.setVisibility(visibility);
        }
    }

    public void onMultiPluginsSelect(long pluginId, String androidId) {
        if (!ActivityCheckerUtils.isActivityValid((Activity)this.getActivity())) {
            return;
        }
        Intent intent = new Intent("MULTIPLE_LIVE_PLUGIN_PLAY_ACTION");
        intent.putExtra("taskId", pluginId);
        intent.putExtra("pluginId", androidId);
        Small.startAction((Intent)intent, (Activity)this.getActivity());
        if (pluginId == Plugins.FightPk.taskId()) {
            ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51331", "0013");
        }
        this.dismissAllowingStateLoss();
    }

    public void show(FragmentActivity activity) {
        if (!ActivityCheckerUtils.isActivityValid((Activity)activity)) {
            return;
        }
        this.show(activity.getSupportFragmentManager(), TAG);
    }

    public static class Builder {
        public static final String KEY_ISOW = "key_isowner";
        public static final String KEY_TEMPLATEID = "key_templateId";
        private boolean mIsOw;
        private long mTemplateId = 0L;

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder setIsOw(boolean isOw) {
            this.mIsOw = isOw;
            return this;
        }

        public Builder setTemplateIdString(String templateIdString) {
            try {
                this.mTemplateId = Long.parseLong(templateIdString);
            }
            catch (Exception e) {
                this.mTemplateId = 0L;
            }
            return this;
        }

        public Builder setTemplateId(long templateId) {
            this.mTemplateId = templateId;
            return this;
        }

        public PluginCenterComponent build(IComponentRoot root) {
            Bundle bundle = new Bundle();
            bundle.putBoolean(KEY_ISOW, this.mIsOw);
            bundle.putLong(KEY_TEMPLATEID, this.mTemplateId);
            PluginCenterComponent component = new PluginCenterComponent();
            component.setArguments(bundle);
            component.mRoot = root;
            return component;
        }
    }
}

