/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.mobilelive;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.yy.mobile.base.ui.BasePresenterComponent;
import com.yy.mobile.plugin.pluginunionlive.PluginBus;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.sdkwrapper.player.vod.PlayerCallback;
import com.yy.mobile.sdkwrapper.player.vod.PlayerPlayInfo;
import com.yy.mobile.sdkwrapper.player.vod.SmallVideoPlayer;
import com.yy.mobile.sdkwrapper.yylive.utils.ConstantsWrapper;
import com.yy.mobile.ui.meidabasicvideoview.MediaVideoViewSize;
import com.yy.mobile.ui.mobilelive.MobileLiveReplayActivity;
import com.yy.mobile.ui.mobilelive.ReplayTouchPlayerRelativeLayout;
import com.yy.mobile.ui.mobilelive.replay.ReplayVideoComponentProxy;
import com.yy.mobile.ui.mobilelive.replay.bean.ReplayUrlInfo;
import com.yy.mobile.ui.mobilelive.replay.bean.event.ReplayVideoFragment_VideoAreaClick_EventArgs;
import com.yy.mobile.ui.mobilelive.replay.business.ReplayVideoComponentContract;
import com.yy.mobile.ui.mobilelive.replay.business.ReplayVideoComponentPresenter;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import com.yymobile.core.mobilelive.IMobileLiveReplayCore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ReplayVideoFragment
extends BasePresenterComponent<ReplayVideoComponentPresenter>
implements ReplayVideoComponentContract.IView,
ReplayVideoComponentProxy {
    public static final String TAG = "ReplayVideoFragmentNew";
    public static final String STORE_REASON_PAY_ONE = "256";
    public static final String PARAM_VIDEO_URL = "param_video_url";
    public static final String PARAM_PROGAME_ID = "param_progame_id";
    public static final String PARAM_IMG_URL = "param_img_url";
    private RelativeLayout mVideoRoot;
    private ReplayTouchPlayerRelativeLayout mReplayVideo;
    private RelativeLayout mLoadingView;
    private LinearLayout mVideoLinearLayout;
    private MobileLiveReplayActivity mContext;
    public SmallVideoPlayer mSmallVideoPlayer;

    public static ReplayVideoFragment newInstance(List<Map<String, String>> data, String imgurl, String progamId) {
        ReplayVideoFragment replayVideoComponent = new ReplayVideoFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList(PARAM_VIDEO_URL, (ArrayList)data);
        bundle.putString(PARAM_IMG_URL, imgurl);
        bundle.putString(PARAM_PROGAME_ID, progamId);
        replayVideoComponent.setArguments(bundle);
        return replayVideoComponent;
    }

    public int getLayout() {
        return R.layout.fragment_replay_video;
    }

    public void initVariable(Bundle savedInstanceState) {
        this.mContext = (MobileLiveReplayActivity)this.getActivity();
        this.mPresenter = new ReplayVideoComponentPresenter(this.mContext);
        ((ReplayVideoComponentPresenter)this.mPresenter).attachView(this);
        ((ReplayVideoComponentPresenter)this.mPresenter).parseBundleInfo(savedInstanceState == null ? this.getArguments() : savedInstanceState);
        if (CoreFactory.getCore(IMobileLiveCore.class) != null) {
            ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).initLastTime();
        } else {
            MLog.error((Object)TAG, (String)"CoreFactory.getCore(IMobileLiveCore.class) = null", (Object[])new Object[0]);
        }
    }

    public void initViewAndData() {
        this.mVideoLinearLayout = (LinearLayout)this.f(R.id.video_textureView);
        this.mVideoRoot = (RelativeLayout)this.f(R.id.video_root);
        this.mReplayVideo = (ReplayTouchPlayerRelativeLayout)this.f(R.id.replay_video_root);
        this.mLoadingView = (RelativeLayout)this.f(R.id.loading_container);
        this.mLoadingView.setVisibility(8);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        params.setMargins(0, 0, 0, 0);
        this.mReplayVideo.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void initListener() {
    }

    @Override
    public void updateVideoAreaClickListener() {
        if (this.mReplayVideo != null) {
            this.mReplayVideo.setClickListener(new ReplayTouchPlayerRelativeLayout.ClickListener(){

                @Override
                public void onClick() {
                    PluginBus.INSTANCE.get().post((Object)new ReplayVideoFragment_VideoAreaClick_EventArgs());
                }
            });
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        ((ReplayVideoComponentPresenter)this.mPresenter).onSaveInstanceState(outState);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mSmallVideoPlayer = new SmallVideoPlayer((Context)this.mContext);
        ((ReplayVideoComponentPresenter)this.mPresenter).setPlayer(this.mSmallVideoPlayer);
        this.mSmallVideoPlayer.setPlayerCallback((PlayerCallback)this.mPresenter);
        this.mVideoLinearLayout.addView((View)this.mSmallVideoPlayer);
        this.mSmallVideoPlayer.setScaleMode(ConstantsWrapper.ScaleMode.AspectFit);
        this.mSmallVideoPlayer.play((PlayerPlayInfo)((ReplayVideoComponentPresenter)this.mPresenter).getCurrentReplayUrlInfo());
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        MLog.info((Object)TAG, (String)("onConfigurationChanged:" + newConfig.orientation), (Object[])new Object[0]);
        if (this.checkActivityValid()) {
            ((ReplayVideoComponentPresenter)this.mPresenter).setOrientationMode(newConfig.orientation == 2);
        }
    }

    @Override
    public boolean isLandScape() {
        if (this.checkActivityValid()) {
            return this.getResources().getConfiguration().orientation == 2;
        }
        return false;
    }

    @Override
    public void fixedVideoLayout(MediaVideoViewSize mediaVideoViewSize, boolean isPortrait) {
        if (this.checkActivityValid()) {
            if (this.mVideoRoot != null) {
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mVideoRoot.getLayoutParams();
                layoutParams.width = mediaVideoViewSize.screenWidth;
                layoutParams.height = mediaVideoViewSize.videoHeight;
                MLog.info((Object)TAG, (String)("[fixedVideoLayout] mediaVideoViewSize=" + mediaVideoViewSize.screenWidth + " x " + mediaVideoViewSize.videoHeight), (Object[])new Object[0]);
                if (isPortrait) {
                    if (Build.VERSION.SDK_INT >= 17) {
                        layoutParams.removeRule(13);
                    }
                    layoutParams.setMargins(0, DensityUtil.dip2px((Context)this.getActivity(), (float)80.0f), 0, 0);
                } else {
                    layoutParams.setMargins(0, 0, 0, 0);
                    layoutParams.addRule(13);
                }
                this.mVideoRoot.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                this.mVideoRoot.requestLayout();
            }
            MLog.info((Object)TAG, (String)("fixedVideoLayout isLandScape = " + this.isLandScape() + " screenWidth = " + mediaVideoViewSize.screenWidth + " videoHeight = " + mediaVideoViewSize.videoHeight), (Object[])new Object[0]);
        } else {
            MLog.info((Object)TAG, (String)"fixedVideoLayout is not checkActivityValid", (Object[])new Object[0]);
        }
    }

    public void onPause() {
        super.onPause();
        MLog.info((Object)TAG, (String)"onPause", (Object[])new Object[0]);
        ((ReplayVideoComponentPresenter)this.mPresenter).onPause();
    }

    public void onResume() {
        super.onResume();
        MLog.info((Object)TAG, (String)"onResume", (Object[])new Object[0]);
        ((ReplayVideoComponentPresenter)this.mPresenter).onResume();
    }

    public void onStop() {
        super.onStop();
        MLog.info((Object)TAG, (String)"onStop", (Object[])new Object[0]);
        ((ReplayVideoComponentPresenter)this.mPresenter).onStop();
    }

    public void onDestroy() {
        super.onDestroy();
        MLog.info((Object)TAG, (String)"onDestroy", (Object[])new Object[0]);
        ((IMobileLiveReplayCore)ICoreManagerBase.getCore(IMobileLiveReplayCore.class)).clear();
        ((ReplayVideoComponentPresenter)this.mPresenter).onDestory();
    }

    @Override
    public void finish() {
        this.getHandler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (ReplayVideoFragment.this.checkActivityValid() && ReplayVideoFragment.this.getActivity() != null) {
                    ReplayVideoFragment.this.getActivity().finish();
                }
            }
        }, 800L);
    }

    @Override
    public boolean checkActivityValid() {
        return super.checkActivityValid();
    }

    @Override
    public void setVisibility(int visibility, int ... viewIds) {
        for (int id2 : viewIds) {
            if (this.f(id2) == null) continue;
            this.f(id2).setVisibility(visibility);
        }
    }

    @Override
    public void setRootViewBackgroundResource() {
        if (!this.checkActivityValid()) {
            return;
        }
        try {
            if (this.isLandScape()) {
                this.mReplayVideo.setBackgroundResource(R.drawable.mediavideo_basic_bg_horizontal);
            } else {
                this.mReplayVideo.setBackgroundResource(R.drawable.mediavideo_basic_bg_vertical);
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
        }
    }

    @Override
    public ReplayUrlInfo getReplayUrlInfo() {
        return ((ReplayVideoComponentPresenter)this.mPresenter).getCurrentReplayUrlInfo();
    }

    @Override
    public int getPlayStatus() {
        return this.mSmallVideoPlayer.mPlayStatus;
    }

    @Override
    public void resumePlayer(boolean isUserPause) {
        this.mSmallVideoPlayer.resumePlayer(isUserPause);
    }

    @Override
    public void pausePlayer(boolean isUserPause) {
        this.mSmallVideoPlayer.pausePlayer(isUserPause);
    }

    @Override
    public void seekTo(int progress) {
        this.mSmallVideoPlayer.seekTo((long)progress);
    }

    @Override
    public boolean takeSnapshot(String path) {
        return this.mSmallVideoPlayer.takeSnapshot(path);
    }

    @Override
    public void resumeOrPause(boolean isUserPause) {
        this.mSmallVideoPlayer.resumeOrPause(isUserPause);
    }

    @Override
    public void changeVideoSize(LinearLayout videoContainer, int height, int width, int left, int top, int right, int bottom, int gravity) {
        LinearLayout.LayoutParams params;
        if (videoContainer != null && (params = (LinearLayout.LayoutParams)videoContainer.getLayoutParams()) != null) {
            params.width = width;
            params.height = height;
            params.setMargins(left, top, right, bottom);
            if (gravity != -1) {
                params.gravity = gravity;
            }
            videoContainer.setLayoutParams((ViewGroup.LayoutParams)params);
            videoContainer.requestLayout();
        }
    }
}

