/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gift;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;

public class NobleGiftListAdapter
extends BaseAdapter {
    private static final String TAG = "NobleGiftListAdapter";
    private final List<AmountInfo> amountInfos;
    private Context mContext;
    private LayoutInflater mInflater;
    private int mCurrentAmount;

    public NobleGiftListAdapter(final Context context) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)context);
        this.amountInfos = new ArrayList<AmountInfo>(){
            {
                this.add(new AmountInfo(-1, context.getString(R.string.str_only_noble_gift)));
                this.add(new AmountInfo(100, context.getString(R.string.str_noble_gift_final_level)));
                this.add(new AmountInfo(10, context.getString(R.string.str_noble_gift_middle_level)));
                this.add(new AmountInfo(1, context.getString(R.string.str_noble_gift_no_level)));
            }
        };
    }

    public int getCount() {
        return this.amountInfos.size();
    }

    public Object getItem(int position) {
        return this.amountInfos.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        AmountItemViewHolder viewHolder;
        if (convertView == null) {
            convertView = this.mInflater.inflate(R.layout.gift_link_amount_list_item, parent, false);
            viewHolder = new AmountItemViewHolder();
            viewHolder.amountTextView = (TextView)convertView.findViewById(R.id.tv_amount);
            viewHolder.descriptionTextView = (TextView)convertView.findViewById(R.id.tv_description);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (AmountItemViewHolder)convertView.getTag();
        }
        Object itemObject = this.getItem(position);
        if (itemObject != null) {
            AmountInfo amountInfo = (AmountInfo)itemObject;
            viewHolder.descriptionTextView.setText((CharSequence)amountInfo.description);
            if (amountInfo.amount == -1) {
                viewHolder.amountTextView.setVisibility(8);
                viewHolder.descriptionTextView.setTextColor(this.mContext.getResources().getColor(R.color.color_gray));
                viewHolder.descriptionTextView.setGravity(17);
                viewHolder.descriptionTextView.setTextSize(0, (float)this.mContext.getResources().getDimensionPixelSize(R.dimen.long_text_tips_fnt));
            } else {
                viewHolder.amountTextView.setVisibility(0);
                viewHolder.amountTextView.setText((CharSequence)String.valueOf(amountInfo.amount));
                viewHolder.descriptionTextView.setGravity(3);
                viewHolder.descriptionTextView.setTextSize(0, (float)this.mContext.getResources().getDimensionPixelSize(R.dimen.short_text_navigation_fnt));
            }
            if (amountInfo.amount == this.mCurrentAmount) {
                convertView.setBackgroundResource(R.color.common_new_gold_color);
                viewHolder.descriptionTextView.setTextColor(this.mContext.getResources().getColor(R.color.color_gray));
            } else {
                convertView.setBackgroundResource(R.color.common_color_11);
                viewHolder.descriptionTextView.setTextColor(this.mContext.getResources().getColor(R.color.common_color_15));
            }
        }
        return convertView;
    }

    public int getCurrentAmount() {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"getCurrentAmount mCurrentAmount=%d", (Object[])new Object[]{this.mCurrentAmount});
        }
        if (this.mCurrentAmount <= 1) {
            this.mCurrentAmount = 1;
        }
        return this.mCurrentAmount;
    }

    public void setCurrentAmount(int amount) {
        this.mCurrentAmount = amount;
        this.notifyDataSetChanged();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"setCurrentAmount mCurrentAmount=%d", (Object[])new Object[]{this.mCurrentAmount});
        }
    }

    public Integer getAmount(int position) {
        AmountInfo amountInfo = (AmountInfo)this.getItem(position);
        if (amountInfo != null) {
            return amountInfo.amount;
        }
        return 0;
    }

    private static class AmountInfo {
        int amount;
        String description;

        private AmountInfo(int amount, String description) {
            this.amount = amount;
            this.description = description;
        }

        public String toString() {
            return "AmountInfo{amount=" + this.amount + ", description='" + this.description + '\'' + '}';
        }
    }

    private static class AmountItemViewHolder {
        TextView amountTextView;
        TextView descriptionTextView;

        private AmountItemViewHolder() {
        }
    }
}

