/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.common;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.RelativeLayout;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.yy.mobile.RxBus;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.liveapi.help.WebViewEventListener;
import com.yy.mobile.plugin.main.events.IWebViewClient_closeActWindow_EventArgs;
import com.yy.mobile.ui.swivelChair.SCLoadingView;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.ui.webview.purewebview.IPureWebview;
import com.yy.mobile.ui.webview.purewebview.PureWebviewUtil;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.ylink.bridge.coreapi.IWebViewEventListener;

public class CommonDialogView
extends RelativeLayout {
    private SCLoadingView scLoadingView;
    private String url;
    private int width = DensityUtil.dip2px((Context)BasicConfig.getInstance().getAppContext(), (float)280.0f);
    private int height = DensityUtil.dip2px((Context)BasicConfig.getInstance().getAppContext(), (float)285.0f);
    private IPureWebview webView;
    private Context context;
    private RelativeLayout.LayoutParams webLoadLayoutParams;
    private WebViewEventListener webViewEventListener = new WebViewEventListener(){

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            if (CommonDialogView.this.webView.getRootView().getVisibility() != 0) {
                CommonDialogView.this.webView.getRootView().setVisibility(0);
            }
            if (CommonDialogView.this.scLoadingView != null) {
                CommonDialogView.this.removeView(CommonDialogView.this.scLoadingView);
            }
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            String jsonParams = "{\"windowType\":\"1\"}";
            RxBus.getDefault().post((Object)new IWebViewClient_closeActWindow_EventArgs(jsonParams));
        }
    };

    public CommonDialogView(Context context) {
        super(context);
        this.context = context;
    }

    public CommonDialogView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
    }

    public CommonDialogView setWidth(int width) {
        if (width > 0) {
            this.width = width;
        }
        return this;
    }

    public CommonDialogView setHeight(int height) {
        if (height > 0) {
            this.height = height;
        }
        return this;
    }

    public CommonDialogView setUrl(String url) {
        this.url = url;
        return this;
    }

    public CommonDialogView parserUrlConfig(String url) {
        String[] infos = url.split("[?]");
        if (infos.length > 0) {
            String[] whMap;
            this.url = infos[0];
            if (infos.length == 2 && (whMap = infos[1].split("&")).length == 2) {
                String[] wInfos = whMap[0].split("=");
                String[] hInfos = whMap[1].split("=");
                if (wInfos.length == 2 && hInfos.length == 2) {
                    if (wInfos[0].equals("w")) {
                        this.width = (int)ResolutionUtils.convertDpToPixel((float)(StringUtils.safeParseInt((String)wInfos[1]) / 2), (Context)BasicConfig.getInstance().getAppContext());
                    } else if (hInfos[0].equals("w")) {
                        this.width = (int)ResolutionUtils.convertDpToPixel((float)(StringUtils.safeParseInt((String)hInfos[1]) / 2), (Context)BasicConfig.getInstance().getAppContext());
                    }
                    if (wInfos[0].equals("h")) {
                        this.height = (int)ResolutionUtils.convertDpToPixel((float)(StringUtils.safeParseInt((String)wInfos[1]) / 2), (Context)BasicConfig.getInstance().getAppContext());
                    } else if (hInfos[0].equals("h")) {
                        this.height = (int)ResolutionUtils.convertDpToPixel((float)(StringUtils.safeParseInt((String)hInfos[1]) / 2), (Context)BasicConfig.getInstance().getAppContext());
                    }
                }
            }
        }
        return this;
    }

    public void build() {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(this.width, this.height);
        params.addRule(13);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        RelativeLayout.LayoutParams webParams = new RelativeLayout.LayoutParams(-1, -1);
        if (this.webView == null) {
            this.initWebView();
            this.addView(this.webView.getRootView(), (ViewGroup.LayoutParams)webParams);
        }
        this.initLoadLayout();
    }

    public void onDisponse() {
        if (this.webView != null) {
            this.webView.release();
            this.webView = null;
            this.webViewEventListener = null;
        }
    }

    private void initLoadLayout() {
        this.scLoadingView = new SCLoadingView(this.context);
        this.webLoadLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
        this.webLoadLayoutParams.addRule(13);
        this.addView(this.scLoadingView, (ViewGroup.LayoutParams)this.webLoadLayoutParams);
    }

    private void initWebView() {
        this.webView = new PureWebviewUtil.Builder(this.context).setOpenStatus(true).create();
        this.webView.setUrl(this.url);
        this.webView.getPullToRefreshWebView().setMode(PullToRefreshBase.Mode.DISABLED);
        this.webView.setWebViewEventLister((IWebViewEventListener)this.webViewEventListener);
    }
}

