/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.turntable.popuptips;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.turntable.popuptips.LuckyListItemInfo;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.StringUtils;
import com.yymobile.core.gift.GiftConfigParser;

public class LuckyListItemView
extends RelativeLayout {
    private LuckyListItemInfo mItemInfo = new LuckyListItemInfo();
    private RelativeLayout mRootView;
    private Context mContext;
    private TextView tvName;
    private TextView tvNum;
    private TextView tvRank;
    private RecycleImageView giftIcon;

    public LuckyListItemView(Context context) {
        super(context);
        this.mContext = context;
        this.initView();
    }

    public LuckyListItemView(Context context, LuckyListItemInfo item2) {
        super(context);
        this.mContext = context;
        this.mItemInfo = item2;
        this.initView();
    }

    private void initView() {
        this.mRootView = (RelativeLayout)LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_luckylist_item, null);
        this.tvName = (TextView)this.mRootView.findViewById(R.id.tv_name);
        this.tvNum = (TextView)this.mRootView.findViewById(R.id.tv_num);
        this.tvRank = (TextView)this.mRootView.findViewById(R.id.tv_rank);
        this.giftIcon = (RecycleImageView)this.mRootView.findViewById(R.id.gift_icon);
        if ("1".equals(this.mItemInfo.giftType)) {
            this.giftIcon.setImageResource(R.drawable.icon_red_diamond);
        } else {
            String path = "";
            if (GiftConfigParser.getInstance().getGiftConfigItemByType(StringUtils.safeParseInt((String)this.mItemInfo.id)) != null) {
                path = GiftConfigParser.getInstance().getGiftConfigItemByType((int)StringUtils.safeParseInt((String)this.mItemInfo.id)).iconPath;
            }
            ImageLoader.loadImage((String)path, (RecycleImageView)this.giftIcon, (ImageConfig)ImageConfig.smallImageConfig(), (int)R.drawable.lr_ic_default_gift);
        }
        if (this.mItemInfo.name == null || "".equals(this.mItemInfo.name)) {
            this.mItemInfo.name = "\u624b\u673aYY\u65b0\u4eba";
        }
        this.tvName.setText((CharSequence)this.mItemInfo.name);
        this.tvNum.setText((CharSequence)this.mItemInfo.num);
        if (this.mItemInfo.rank == 0) {
            this.tvRank.setText((CharSequence)"4+");
        } else if (this.mItemInfo.rank == 1) {
            this.tvRank.setBackgroundResource(R.drawable.bg_luckylist_rank1);
        } else if (this.mItemInfo.rank == 2) {
            this.tvRank.setBackgroundResource(R.drawable.bg_luckylist_rank2);
        } else if (this.mItemInfo.rank == 3) {
            this.tvRank.setBackgroundResource(R.drawable.bg_luckylist_rank3);
        }
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, (int)ResolutionUtils.convertDpToPixel((float)40.0f, (Context)this.mContext));
        this.addView((View)this.mRootView, (ViewGroup.LayoutParams)params);
    }
}

