/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.chatemotion;

import android.app.Activity;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.View;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.liveapi.chatemotion.uicore.IChatEmotionCore;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onChatEmotionComponentShow_EventArgs;
import com.yy.mobile.ui.chatemotion.ChatEmotionPopupComponent;
import com.yy.mobile.ui.profile.HotwordPopupWindow;
import com.yy.mobile.util.FP;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.BaseFragmentApi;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ShowChatPresenter {
    private static final String TAG = "ShowChatPresenter";

    public void showChatComponent(Fragment fragment, boolean mIsLandscape) {
        if (mIsLandscape) {
            this.showLandScapeChatComponent(fragment);
        } else {
            this.showPortraitChatComponent();
        }
    }

    public void showLandScapeChatComponent(FragmentManager manager) {
        this.showLandScapeChatComponent(manager, null);
    }

    public void showLandScapeChatComponent(Fragment fragment) {
        this.showLandScapeChatComponent(fragment, null);
    }

    public void showLandScapeChatComponent(Fragment fragment, @Nullable CharSequence defaultInputText) {
        Fragment parentFragment = fragment.getParentFragment();
        if (parentFragment != null) {
            this.showLandScapeChatComponent(parentFragment.getChildFragmentManager(), defaultInputText);
        }
    }

    public void showLandScapeChatComponent(FragmentManager manager, @Nullable CharSequence defaultInputText) {
        RxBus.getDefault().post((Object)new IChatEmotionClient_onChatEmotionComponentShow_EventArgs());
        ChatEmotionPopupComponent component = TextUtils.isEmpty((CharSequence)defaultInputText) ? ChatEmotionPopupComponent.newInstance() : ChatEmotionPopupComponent.newInstance(defaultInputText);
        component.show(manager, "ChatEmotionPopupComponent");
    }

    public void showPortraitChatComponent() {
        this.showPortraitChatComponent(null);
    }

    public void showPortraitChatComponent(@Nullable String defaultInputText) {
        if (!TextUtils.isEmpty((CharSequence)defaultInputText)) {
            ((IChatEmotionCore)ICoreManagerBase.getCore(IChatEmotionCore.class)).setTextToInput(defaultInputText);
        }
        ((IChatEmotionCore)ICoreManagerBase.getCore(IChatEmotionCore.class)).showChatInputBroadcast(true);
    }

    public HotwordPopupWindow showHotWordComponent(@NotNull Activity activity, @NotNull View anchorView, boolean isLandscape, int dataSize) {
        HotwordPopupWindow window = new HotwordPopupWindow(activity, dataSize);
        window.show(anchorView, isLandscape);
        return window;
    }

    @Nullable
    public HotwordPopupWindow showHotWordComponentWithLogin(@NotNull Activity activity, @NotNull View anchorView, boolean isLandscape, List<String> words) {
        HotwordPopupWindow window = null;
        if (LoginUtil.isLogined()) {
            window = this.showHotWordComponent(activity, anchorView, isLandscape, FP.size(words));
            window.setHotWordsListView(words);
            Property property = new Property();
            property.putString("key1", String.valueOf(ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().topSid));
            property.putString("key3", String.valueOf(ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId()));
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51012", "0003", (Serializable)property);
        } else if (CoreApiManager.getInstance() != null && CoreApiManager.getInstance().getApi(BaseFragmentApi.class) != null) {
            ((BaseFragmentApi)CoreApiManager.getInstance().getApi(BaseFragmentApi.class)).showLoginDialog(activity);
        }
        return window;
    }
}

