/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.basic;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import com.trello.rxlifecycle2.LifecycleTransformer;
import com.trello.rxlifecycle2.android.FragmentEvent;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.live.basic.ELAbsModule;
import com.yy.live.basic.module.event.BaseModuleEvent;
import com.yy.live.basic.module.management.ELModuleContext;
import com.yy.live.basic.module.management.ELModulesManager;
import com.yy.live.helper.DialogFactory;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.util.ActivityUtilKt;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.BaseFragmentApi;
import com.yy.mobile.ylink.bridge.coreapi.LoginApi;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import org.jetbrains.annotations.NotNull;

public abstract class ELBasicModule<P>
extends ELAbsModule
implements EventCompat,
BaseModuleEvent.HitChecker {
    private static final String TAG = "ELBasicModule";
    protected FragmentActivity mContext;
    protected Component mComponent;
    private P mModuleMvpPresenter;
    protected DialogFactory mDialogFactory;
    protected ELModuleContext modudleContext;
    private String extendInfoString;
    private Handler mHandler;
    protected View mContentView;

    @Nullable
    protected ModuleInitialParameter getInitialParameter() {
        if (this.modudleContext == null || this.modudleContext.getModulesManager() == null) {
            return null;
        }
        return com.yy.moduleconfigs.ModuleInitialParameter.getModuleParamter(this.modudleContext.getModulesManager().getAttachedComponentName(), this.getCurrentModuleName());
    }

    @Override
    public void onPreCreateView(@NotNull ELModuleContext moduleContext, @NotNull String extend) {
        this.modudleContext = moduleContext;
        this.extendInfoString = extend;
        this.init(this.modudleContext, this.extendInfoString);
        this.onEventBind();
    }

    @Override
    public void onCreateView() {
    }

    @Override
    public void onResume() {
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onDispose() {
        try {
            this.onEventUnBind();
        }
        catch (Throwable t) {
            MLog.error((Object)TAG, (String)("onDispose onEventUnBind=" + t.getMessage()), (Object[])new Object[0]);
        }
        if (this.mDialogFactory != null) {
            this.mDialogFactory.dismissDialog();
        }
        ICoreManagerBase.removeClient((Object)this);
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.modudleContext = null;
    }

    @Override
    public void init(ELModuleContext moduleContext, String extend) {
        if (moduleContext != null) {
            ICoreManagerBase.addClient((Object)this);
            this.modudleContext = moduleContext;
            this.mComponent = moduleContext.getComponent();
            if (this.mComponent != null) {
                this.mContext = this.mComponent.getActivity();
                this.mDialogFactory = new DialogFactory((Context)this.mContext);
            }
        }
    }

    protected Context getContext() {
        return this.mContext;
    }

    protected IChannelLinkCore getChannelCore() {
        return ICoreManagerBase.getChannelLinkCore();
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
    }

    public Handler getHandler() {
        if (this.mHandler == null) {
            this.mHandler = new SafeDispatchHandler(Looper.getMainLooper());
        }
        return this.mHandler;
    }

    protected ELAbsModule getModuleByName(String name) {
        if (this.modudleContext != null && this.modudleContext.getModulesManager() != null) {
            return this.modudleContext.getModulesManager().getModuleByName(name);
        }
        return null;
    }

    protected void login() {
        if (CoreApiManager.getInstance().getApi(LoginApi.class) != null) {
            ((LoginApi)CoreApiManager.getInstance().getApi(LoginApi.class)).goToLogin((Context)this.mContext);
        }
    }

    protected boolean isLandScape() {
        Activity activity = YYActivityManager.INSTANCE.getCurrentActivity();
        return ActivityUtilKt.isLandScape((Activity)activity);
    }

    protected void showLoginDialog() {
        if (CoreApiManager.getInstance().getApi(BaseFragmentApi.class) != null) {
            ((BaseFragmentApi)CoreApiManager.getInstance().getApi(BaseFragmentApi.class)).showLoginDialog((Activity)this.mContext);
        }
    }

    @Override
    public void subscribeBackPressListener() {
        if (this.modudleContext != null && this.modudleContext.getModulesManager() != null) {
            this.modudleContext.getModulesManager().subscribeBackPressListener(this);
        }
    }

    @Override
    public void unSubscribeBackPressListener() {
        if (this.modudleContext != null && this.modudleContext.getModulesManager() != null) {
            this.modudleContext.getModulesManager().unSubscribeBackPressListener(this);
        }
    }

    @Override
    public boolean onBackPress() {
        return false;
    }

    @Override
    public boolean persist() {
        return false;
    }

    @TargetApi(value=17)
    protected boolean checkActivityValid() {
        if (null == this.mComponent || null == this.mComponent.getActivity()) {
            return false;
        }
        FragmentActivity activity = this.mComponent.getActivity();
        return !activity.isFinishing() && (Build.VERSION.SDK_INT < 17 || !activity.isDestroyed());
    }

    protected final <T> LifecycleTransformer<T> bindUntilEvent(@NonNull FragmentEvent event) {
        if (this.mComponent == null) {
            throw new NullPointerException("module bust have component!");
        }
        return this.mComponent.bindUntilEvent(event);
    }

    protected final <T> LifecycleTransformer<T> bindToLifecycle() {
        if (this.mComponent == null) {
            throw new NullPointerException("module bust have component!");
        }
        return this.mComponent.bindToLifecycle();
    }

    public void onEventBind() {
    }

    public void onEventUnBind() {
    }

    @Nullable
    protected P createPresenter() {
        return null;
    }

    protected final P getPresenter() {
        if (this.mModuleMvpPresenter == null) {
            this.mModuleMvpPresenter = this.createPresenter();
        }
        return this.mModuleMvpPresenter;
    }

    @Override
    public void onModuleGone() {
    }

    @Override
    public void onModuleInvisible() {
    }

    @Override
    public void onModuleVisible() {
    }

    @Override
    public String getCurrentModuleName() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public boolean isEventHit(@NonNull BaseModuleEvent event) {
        if (this.modudleContext == null || this.modudleContext.getModulesManager() == null) {
            return false;
        }
        ELModulesManager modulesManager = this.modudleContext.getModulesManager();
        for (BaseModuleEvent.TargetModuleIdentification target2 : event.getTargets()) {
            if (!modulesManager.isComponentHit(target2.getComponent()) || !target2.getModule().equals(this.getCurrentModuleName())) continue;
            return true;
        }
        return false;
    }

    public static abstract class ModuleInitialParameter {
    }
}

