/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import com.yy.mobile.memoryrecycle.views.YYRelativeLayout;
import com.yy.mobile.ui.utils.DimensUtils;
import com.yy.mobile.util.log.MLog;

public class PartTransparentView
extends YYRelativeLayout {
    private Context mContext;
    private Rect mTransparentRect;
    private Paint mSolidPaint;
    private Paint mStrokePaint;
    private PorterDuffXfermode mPorterDuffXfermode;
    private int mSolidColor = 0xFFFFFF;
    private int mStrokeColor = -7175131;
    private boolean mShowStroke = true;

    public PartTransparentView(Context context) {
        super(context);
        this.init(context);
    }

    public PartTransparentView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public PartTransparentView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        this.mTransparentRect = new Rect(0, 0, 0, 0);
    }

    public void setTransparentRect(Rect rect) {
        this.mTransparentRect = rect;
    }

    public void setColor(int color2) {
        this.mSolidColor = color2;
    }

    public void showStroke(boolean showStroke) {
        this.mShowStroke = showStroke;
    }

    public void setStrokeColor(int color2) {
        this.mStrokeColor = color2;
    }

    protected void onDraw(Canvas canvas) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"PartTransparentView", (String)"onDraw", (Object[])new Object[0]);
        }
        this.setLayerType(2, null);
        this.drawStroke(canvas);
        if (this.mSolidPaint == null) {
            this.mSolidPaint = new Paint();
        }
        this.mSolidPaint.setFilterBitmap(false);
        this.mSolidPaint.setStyle(Paint.Style.FILL);
        if (this.mPorterDuffXfermode == null) {
            this.mPorterDuffXfermode = new PorterDuffXfermode(PorterDuff.Mode.CLEAR);
        }
        this.mSolidPaint.setXfermode((Xfermode)this.mPorterDuffXfermode);
        canvas.drawRect(this.mTransparentRect, this.mSolidPaint);
        this.mSolidPaint.setXfermode(null);
        this.setLayerType(0, null);
    }

    private void drawStroke(Canvas canvas) {
        if (!this.mShowStroke) {
            return;
        }
        if (this.mStrokePaint == null) {
            this.mStrokePaint = new Paint();
        }
        this.mStrokePaint.setStyle(Paint.Style.STROKE);
        this.mStrokePaint.setColor(this.mStrokeColor);
        this.mStrokePaint.setStrokeWidth((float)DimensUtils.dip2pixel((Context)this.mContext, (float)1.5f));
        canvas.drawRect(this.mTransparentRect, this.mStrokePaint);
    }
}

