/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.swivelChair;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import java.util.ArrayList;
import java.util.Map;

public class SwivelRecordAdapter
extends BaseAdapter {
    private Context mContext;
    private LayoutInflater inflater;
    private ArrayList<Map<String, String>> records = new ArrayList();

    public SwivelRecordAdapter(Context mContext) {
        this.mContext = mContext;
        this.inflater = LayoutInflater.from((Context)mContext);
    }

    public void setData(ArrayList<Map<String, String>> datas) {
        this.records.clear();
        if (null != datas && datas.size() > 0) {
            this.records.addAll(datas);
        }
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.records.size();
    }

    public Object getItem(int position) {
        return position < this.records.size() ? this.records.get(position) : null;
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (null == convertView) {
            holder = new ViewHolder();
            convertView = this.inflater.inflate(R.layout.swivelchair_record_item_layout, null);
            holder.headImg = (CircleImageView)convertView.findViewById(R.id.record_head);
            holder.nameTxt = (TextView)convertView.findViewById(R.id.record_name);
            holder.multipleTxt = (TextView)convertView.findViewById(R.id.record_multiple);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        Map map = (Map)this.getItem(position);
        if (null != map) {
            if (null != holder.headImg) {
                ImageLoader.loadImage((String)(map.containsKey("icon") ? (String)map.get("icon") : ""), (RecycleImageView)holder.headImg, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait);
            }
            if (null != holder.nameTxt) {
                holder.nameTxt.setText((CharSequence)(map.containsKey("nick") ? (String)map.get("nick") : ""));
            }
            if (null != holder.multipleTxt) {
                holder.multipleTxt.setText((CharSequence)String.format("%s\u500d", map.containsKey("multiple") ? (String)map.get("multiple") : "0"));
            }
        }
        return convertView;
    }

    public static class ViewHolder {
        public CircleImageView headImg;
        public TextView nameTxt;
        public TextView multipleTxt;
    }
}

