/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.redpacket.ui;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.duowan.mobile.entlive.events.IRedPacketClient_onClickAreaDetection_EventArgs;
import com.duowan.mobile.entlive.events.IRedPacketClient_onHideSoftKeyboard_EventArgs;
import com.duowan.mobile.entlive.events.IRedPacketClient_onLoading_EventArgs;
import com.duowan.mobile.entlive.events.IRedPacketClient_onSoftKeyboardVisibie_EventArgs;
import com.duowan.mobile.entlive.events.IRedPacketClient_setRedPacketWords_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.liveapi.chatemotion.uicore.IChatEmotionCore;
import com.yy.mobile.plugin.pluginunionlive.PluginBus;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.richtext.EmoticonFilter;
import com.yy.mobile.richtext.XmlFilter;
import com.yy.mobile.ui.basicchanneltemplate.component.BasePopupComponent;
import com.yy.mobile.ui.redpacket.ui.RedPacketInputPopupComponent$$EventBinder;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.ui.utils.SoftKeyboardStateHelper;
import com.yy.mobile.ui.widget.listenkeyboard.KeyboardStateListener;
import com.yy.mobile.ui.widget.listenkeyboard.ListenIntoKeyboardShowOrHideRelativeLayout;
import com.yy.mobile.util.ImeUtil;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.channel.ChannelState;
import com.yymobile.core.channel.PublicChatMessage;
import com.yymobile.core.medal.MedalCenter;
import com.yymobile.core.medal.MedalConfig;
import com.yymobile.core.redpacket.GetPacketInfo;
import com.yymobile.core.redpacket.IRedPackeCore;
import com.yymobile.core.sensitivewords.ISensitiveWordsCore;
import java.util.ArrayList;
import java.util.List;

public class RedPacketInputPopupComponent
extends BasePopupComponent
implements EventCompat,
View.OnClickListener {
    private static final String TAG = "RedPacketInputPopupComponent";
    View root;
    LinearLayout inputLayout;
    EditText inputBox;
    Button btnSend;
    boolean keyboardVisiable = false;
    GetPacketInfo packetInfo;
    private SoftKeyboardStateHelper mSoftKeyboardStateHelper;
    private EventBinder mRedPacketInputPopupComponentSniperEventBinder;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(1, 16973837);
        this.getActivity().getWindow().setSoftInputMode(20);
        Bundle arg = this.getArguments();
        if (arg != null) {
            this.packetInfo = (GetPacketInfo)arg.getParcelable("redpacket");
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.root = inflater.inflate(R.layout.layout_redpacket_input, container, false);
        this.root.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)RedPacketInputPopupComponent.TAG, (String)"root onTouch", (Object[])new Object[0]);
                }
                PluginBus.INSTANCE.get().post((Object)new IRedPacketClient_onClickAreaDetection_EventArgs(event));
                return true;
            }
        });
        this.inputLayout = (LinearLayout)this.root.findViewById(R.id.input_layout);
        this.inputBox = (EditText)this.root.findViewById(R.id.input_box);
        this.inputBox.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return false;
            }
        });
        this.inputBox.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                try {
                    if (!RedPacketInputPopupComponent.this.checkActivityValid()) {
                        return;
                    }
                    String msg = editable.toString().trim();
                    if (RedPacketInputPopupComponent.this.btnSend != null) {
                        if (StringUtils.isNullOrEmpty((String)msg)) {
                            RedPacketInputPopupComponent.this.btnSend.setEnabled(false);
                            RedPacketInputPopupComponent.this.btnSend.setBackgroundResource(R.drawable.bg_chat_input);
                            RedPacketInputPopupComponent.this.btnSend.setTextColor(RedPacketInputPopupComponent.this.getResources().getColor(R.color.common_color_9));
                        } else {
                            RedPacketInputPopupComponent.this.btnSend.setEnabled(true);
                            RedPacketInputPopupComponent.this.btnSend.setBackgroundResource(R.drawable.btn_focus_selector);
                            RedPacketInputPopupComponent.this.btnSend.setTextColor(RedPacketInputPopupComponent.this.getResources().getColor(R.color.txt_color_unfollow));
                        }
                    }
                }
                catch (Throwable throwable) {
                    MLog.error((Object)RedPacketInputPopupComponent.TAG, (String)("[afterTextChanged] throwable = " + throwable), (Object[])new Object[0]);
                }
            }
        });
        this.inputBox.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)RedPacketInputPopupComponent.TAG, (String)"inputBox onTouch", (Object[])new Object[0]);
                }
                if (RedPacketInputPopupComponent.this.checkActivityValid()) {
                    ImeUtil.showIME((Activity)RedPacketInputPopupComponent.this.getActivity(), (View)RedPacketInputPopupComponent.this.inputBox);
                }
                return false;
            }
        });
        this.inputBox.setFocusableInTouchMode(true);
        this.inputBox.requestFocus();
        this.btnSend = (Button)this.root.findViewById(R.id.btn_send);
        this.btnSend.setOnClickListener((View.OnClickListener)this);
        if (this.packetInfo != null) {
            this.inputBox.setText((CharSequence)(this.packetInfo.getWord() == null ? "" : this.packetInfo.getWord()));
        }
        if (this.inputBox.getText() != null && this.inputBox.getText().length() > 0) {
            this.inputBox.setSelection(this.inputBox.getText().length());
        }
        ((ListenIntoKeyboardShowOrHideRelativeLayout)this.root).setKeyboardStateListener(new KeyboardStateListener(){

            public void stateChange(boolean isKeyboardVisiable) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)RedPacketInputPopupComponent.TAG, (String)("->stateChange isKeyboardVisiable=" + isKeyboardVisiable + ",current keyboardVisiable=" + RedPacketInputPopupComponent.this.keyboardVisiable), (Object[])new Object[0]);
                }
                if (RedPacketInputPopupComponent.this.keyboardVisiable != isKeyboardVisiable) {
                    RedPacketInputPopupComponent.this.keyboardVisiable = isKeyboardVisiable;
                    if (!RedPacketInputPopupComponent.this.keyboardVisiable) {
                        RedPacketInputPopupComponent.this.inputBox.clearFocus();
                        ImeUtil.hideIME((Context)RedPacketInputPopupComponent.this.getActivity(), (View)RedPacketInputPopupComponent.this.inputBox);
                        PluginBus.INSTANCE.get().post((Object)new IRedPacketClient_onSoftKeyboardVisibie_EventArgs(false));
                        RedPacketInputPopupComponent.this.getHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                RedPacketInputPopupComponent.this.dismissAllowingStateLoss();
                            }
                        });
                    }
                }
            }
        });
        this.mSoftKeyboardStateHelper = new SoftKeyboardStateHelper(this.inputLayout.getRootView());
        this.mSoftKeyboardStateHelper.addSoftKeyboardStateListener(new SoftKeyboardStateHelper.SoftKeyboardStateListener(){

            public void onSoftKeyboardOpened(int keyboardHeightInPx) {
                if (RedPacketInputPopupComponent.this.checkActivityValid()) {
                    RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)RedPacketInputPopupComponent.this.inputLayout.getLayoutParams();
                    layoutParams.bottomMargin = RedPacketInputPopupComponent.this.isLandScape() ? DensityUtil.dip2px((Context)RedPacketInputPopupComponent.this.getActivity(), (float)10.0f) : 0;
                    RedPacketInputPopupComponent.this.inputLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    PluginBus.INSTANCE.get().post((Object)new IRedPacketClient_onSoftKeyboardVisibie_EventArgs(true));
                    if (MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)RedPacketInputPopupComponent.TAG, (String)"SoftKeyBoard Opened, input container reLayout finished", (Object[])new Object[0]);
                    }
                }
            }

            public void onSoftKeyboardClosed() {
                if (RedPacketInputPopupComponent.this.checkActivityValid()) {
                    PluginBus.INSTANCE.get().post((Object)new IRedPacketClient_onSoftKeyboardVisibie_EventArgs(false));
                    RedPacketInputPopupComponent.this.dismissAllowingStateLoss();
                    if (MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)RedPacketInputPopupComponent.TAG, (String)"SoftKeyBoard Closed, input container reLayout finished", (Object[])new Object[0]);
                    }
                }
            }
        });
        return this.root;
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive")
    public void onHideSoftKeyboard(IRedPacketClient_onHideSoftKeyboard_EventArgs busEventArgs) {
        this.onHideSoftKeyboard();
    }

    public void onHideSoftKeyboard() {
        ImeUtil.hideIME((Context)this.getActivity(), (View)this.inputBox);
        this.dismissAllowingStateLoss();
        PluginBus.INSTANCE.get().post((Object)new IRedPacketClient_onSoftKeyboardVisibie_EventArgs(false));
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.setCanceledOnTouchOutside(true);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setWindowAnimations(R.style.slide_dialog_animation);
        dialog.getWindow().setBackgroundDrawableResource(R.color.transparent);
        if (2 == this.getResources().getConfiguration().orientation) {
            dialog.getWindow().setFlags(1024, 1024);
        }
        dialog.getWindow().clearFlags(2);
        dialog.getWindow().setGravity(80);
        dialog.getWindow().setSoftInputMode(20);
        dialog.getWindow().setLayout(-1, -1);
        return dialog;
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive")
    public void setRedPacketWords(IRedPacketClient_setRedPacketWords_EventArgs busEventArgs) {
        String words = busEventArgs.mWords;
        if (this.inputBox != null) {
            this.inputBox.setText((CharSequence)words);
        }
    }

    public void onClick(View v) {
        if (v == this.btnSend) {
            this.sendMessage(this.inputBox.getText().toString());
        }
    }

    public void sendMessage(String message) {
        try {
            if (this.isNetworkAvailable()) {
                if (!StringUtils.isNullOrEmpty((String)message)) {
                    if (!this.isContainSensitiveWords(message)) {
                        if (this.packetInfo != null && message.equals(this.packetInfo.getWord())) {
                            MLog.info((Object)TAG, (String)"check message is commond!", (Object[])new Object[0]);
                            this.sendChatMsg(this.inputBox.getText().toString());
                            this.onHideSoftKeyboard();
                            PluginBus.INSTANCE.get().post((Object)new IRedPacketClient_onLoading_EventArgs());
                            ((IRedPackeCore)ICoreManagerBase.getCore(IRedPackeCore.class)).reqGrabRedPacket(this.packetInfo.getRedPacketId());
                        } else {
                            this.toast("\u53e3\u4ee4\u8f93\u5165\u6709\u8bef!");
                        }
                    }
                } else {
                    this.toast("\u53e3\u4ee4\u4e3a\u7a7a!");
                }
            } else {
                this.toast(this.getString(R.string.str_net_error_common));
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)("[sendMessage] error! throwable=" + throwable), (Object[])new Object[0]);
        }
    }

    private void sendChatMsg(String message) {
        IChatEmotionCore.ChatMsgInfo chatMsgInfo = new IChatEmotionCore.ChatMsgInfo();
        chatMsgInfo.msgToSend = message;
        chatMsgInfo.msgLength = EmoticonFilter.parseSpannableLength((String)message);
        boolean isInSocialChannel = false;
        ChannelInfo info = ((IChannelLinkCore)ICoreManagerBase.getCore(IChannelLinkCore.class)).getCurrentChannelInfo();
        if (null != info && info.channelType == ChannelInfo.ChannelType.FRIEND) {
            isInSocialChannel = true;
        }
        String uid = String.valueOf(LoginUtil.getUid());
        ArrayList<MedalConfig.MedalType> medalTypes = new ArrayList<MedalConfig.MedalType>();
        medalTypes.add(MedalConfig.MedalType.noble);
        if (!isInSocialChannel) {
            medalTypes.add(MedalConfig.MedalType.truelove);
        }
        medalTypes.add(MedalConfig.MedalType.medalwall);
        medalTypes.add(MedalConfig.MedalType.actmedal);
        medalTypes.add(MedalConfig.MedalType.taillight);
        List subscribeStrs = MedalCenter.getInstance().subscribeChatMedal(uid, medalTypes);
        String matchId = null;
        XmlFilter.CreateMedalXmlInfo medalXmlInfo = new XmlFilter.CreateMedalXmlInfo(uid, matchId, subscribeStrs);
        chatMsgInfo.msgToSend = XmlFilter.creatXmlNobleChannelMessage((String)message, (XmlFilter.CreateMedalXmlInfo)medalXmlInfo);
        ((IChatEmotionCore)ICoreManagerBase.getCore(IChatEmotionCore.class)).sendMessage(chatMsgInfo);
        ((IChatEmotionCore)ICoreManagerBase.getCore(IChatEmotionCore.class)).sendOwnMessage(chatMsgInfo.msgToSend);
    }

    private boolean isContainSensitiveWords(String message) {
        try {
            if (((ISensitiveWordsCore)ICoreManagerBase.getCore(ISensitiveWordsCore.class)).containFinanceSensitiveWord(message)) {
                MLog.info((Object)"containFinanceSensitiveWord", (String)message, (Object[])new Object[0]);
                SingleToastUtil.showToast((String)"\u5305\u542b\u654f\u611f\u8bcd");
                return true;
            }
            if (ICoreManagerBase.getChannelLinkCore().isChannelPOLICE()) {
                MLog.info((Object)"containFinanceSensitiveWord", (String)message, (Object[])new Object[0]);
                if (this.checkActivityValid()) {
                    this.toast(R.string.str_forbid_send_with_userInfo_channelPolice);
                }
                return true;
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)"[isContainSensitiveWords] check isContainSensitiveWords error!", (Object[])new Object[0]);
        }
        return false;
    }

    public ChannelMessage buildChannelMessage(String message) {
        PublicChatMessage msg = new PublicChatMessage();
        msg.sid = ((IChannelLinkCore)ICoreManagerBase.getCore(IChannelLinkCore.class)).getCurrentChannelInfo().topSid;
        if (((IChannelLinkCore)ICoreManagerBase.getCore(IChannelLinkCore.class)).getChannelState() == ChannelState.In_Channel) {
            msg.uid = LoginUtil.getUid();
        }
        msg.text = message;
        msg.nickname = ICoreManagerBase.getUserCore().getCacheLoginUserInfo() != null && ICoreManagerBase.getUserCore().getCacheLoginUserInfo().nickName != null ? ICoreManagerBase.getUserCore().getCacheLoginUserInfo().nickName : LoginUtil.getAccountName();
        return msg;
    }

    private boolean isLandScape() {
        if (this.getActivity() != null) {
            return this.getResources().getConfiguration().orientation == 2;
        }
        return false;
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mRedPacketInputPopupComponentSniperEventBinder == null) {
            this.mRedPacketInputPopupComponentSniperEventBinder = new RedPacketInputPopupComponent$$EventBinder();
        }
        this.mRedPacketInputPopupComponentSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mRedPacketInputPopupComponentSniperEventBinder != null) {
            this.mRedPacketInputPopupComponentSniperEventBinder.unBindEvent();
        }
    }
}

