/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.mobilelive.replay.business;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import com.yy.mobile.RxBus;
import com.yy.mobile.base.mvp.presenter.BindPresenter;
import com.yy.mobile.channel.core.AbsChannelControllerCore;
import com.yy.mobile.plugin.main.events.IMobileLiveReplayClient_onReplayNormalEnd_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveReplayClient_onReplayPause_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveReplayClient_onReplayPlaying_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveReplayClient_onReplayTimeChanged_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveReplayClient_onReplayVideoSize_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.PluginBus;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.sdkwrapper.player.vod.PlayerCallback;
import com.yy.mobile.sdkwrapper.player.vod.PlayerPlayInfo;
import com.yy.mobile.sdkwrapper.player.vod.SmallVideoPlayer;
import com.yy.mobile.ui.LiveNavigationUtils;
import com.yy.mobile.ui.meidabasicvideoview.MediaVideoViewSize;
import com.yy.mobile.ui.mobilelive.MobileLiveReplayActivity;
import com.yy.mobile.ui.mobilelive.replay.ReplayLeaveInfo;
import com.yy.mobile.ui.mobilelive.replay.bean.ReplayUrlInfo;
import com.yy.mobile.ui.mobilelive.replay.bean.event.HideLoadingViewEvent;
import com.yy.mobile.ui.mobilelive.replay.bean.event.ReplayVideoFragment_UpdateEventArgs;
import com.yy.mobile.ui.mobilelive.replay.business.ReplayVideoComponentContract;
import com.yy.mobile.ui.mobilelive.replay.util.ReplayUtil;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import com.yymobile.core.mobilelive.IMobileLiveReplayCore;
import com.yyproto.utils.FP;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ReplayVideoComponentPresenter
extends BindPresenter<ReplayVideoComponentContract.IView>
implements ReplayVideoComponentContract.Presenter,
PlayerCallback {
    private static final String TAG = "ReplayVideoComponentPresenter";
    private List<Map<String, String>> mReplayUrlList = new ArrayList<Map<String, String>>();
    public static final String PARAM_VIDEO_URL = "param_video_url";
    public static final String PARAM_PROGAME_ID = "param_progame_id";
    public static final String PARAM_IMG_URL = "param_img_url";
    private ReplayUrlInfo mCurrentReplayUrlInfo = new ReplayUrlInfo();
    private List<ReplayUrlInfo> mReplayUrlInfos;
    private long stopPlayTime = 0L;
    private MobileLiveReplayActivity mContext;
    private float widthHeightRatio = 0.0f;
    private SmallVideoPlayer mSmallVideoPlayer;
    private int currentReplayUrlIndex;
    int cacheProgress;

    public void setPlayer(SmallVideoPlayer smallVideoPlayer) {
        this.mSmallVideoPlayer = smallVideoPlayer;
    }

    public ReplayVideoComponentPresenter(MobileLiveReplayActivity context) {
        this.mContext = context;
    }

    public ReplayUrlInfo getCurrentReplayUrlInfo() {
        return this.mCurrentReplayUrlInfo;
    }

    public void parseBundleInfo(Bundle replayInfoBundle) {
        if (replayInfoBundle != null) {
            this.mReplayUrlList = replayInfoBundle.getParcelableArrayList(PARAM_VIDEO_URL);
            this.mCurrentReplayUrlInfo.programId = replayInfoBundle.getString(PARAM_PROGAME_ID);
            this.mCurrentReplayUrlInfo.loadingBackgroundImgUrl = replayInfoBundle.getString(PARAM_IMG_URL);
            MLog.info((Object)TAG, (String)("onCreate video url mReplayUrlList=" + this.mReplayUrlList + " progameID=" + this.mCurrentReplayUrlInfo.programId + " mLoadingBackgroundImgUrl" + this.mCurrentReplayUrlInfo.programId), (Object[])new Object[0]);
            if (!FP.empty(this.mReplayUrlList)) {
                this.mReplayUrlInfos = ReplayUtil.parseReplayMapToList(this.mReplayUrlList, this.mCurrentReplayUrlInfo.programId);
                if (this.mReplayUrlInfos != null && this.mReplayUrlInfos.size() > 0) {
                    this.mCurrentReplayUrlInfo = this.mReplayUrlInfos.get(this.currentReplayUrlIndex++);
                    this.mCurrentReplayUrlInfo.loadingBackgroundImgUrl = replayInfoBundle.getString(PARAM_IMG_URL);
                    if (this.mCurrentReplayUrlInfo.isVRPlay) {
                        ((ReplayVideoComponentContract.IView)this.mView).updateVideoAreaClickListener();
                    }
                    PluginBus.INSTANCE.get().post((Object)new ReplayVideoFragment_UpdateEventArgs());
                } else {
                    MLog.error((Object)TAG, (String)"[parseBundleInfo] data error", (Object[])new Object[0]);
                    ((ReplayVideoComponentContract.IView)this.mView).finish();
                }
            } else {
                MLog.error((Object)TAG, (String)"[parseBundleInfo] mReplayUrlList == null", (Object[])new Object[0]);
                ((ReplayVideoComponentContract.IView)this.mView).finish();
            }
        } else {
            MLog.error((Object)TAG, (String)"[parseBundleInfo] replayInfoBundle == null", (Object[])new Object[0]);
            ((ReplayVideoComponentContract.IView)this.mView).finish();
        }
    }

    public void setOrientationMode(boolean isLandscape) {
        MediaVideoViewSize mediaVideoViewSize = new MediaVideoViewSize();
        if (isLandscape) {
            DisplayMetrics metric = new DisplayMetrics();
            this.mContext.getWindowManager().getDefaultDisplay().getMetrics(metric);
            int screenWidth = metric.widthPixels;
            int screenHeight = metric.heightPixels;
            if (this.widthHeightRatio < (float)screenWidth / (float)screenHeight) {
                MLog.info((Object)TAG, (String)"height is the screen height", (Object[])new Object[0]);
                mediaVideoViewSize.videoHeight = metric.heightPixels;
                mediaVideoViewSize.screenWidth = (int)((float)mediaVideoViewSize.videoHeight * this.widthHeightRatio);
            } else {
                MLog.info((Object)TAG, (String)"width is the screen height", (Object[])new Object[0]);
                mediaVideoViewSize.screenWidth = metric.widthPixels;
                mediaVideoViewSize.videoHeight = (int)((float)mediaVideoViewSize.screenWidth / this.widthHeightRatio);
            }
            ((ReplayVideoComponentContract.IView)this.mView).fixedVideoLayout(mediaVideoViewSize, false);
            this.mContext.getWindow().setFlags(1024, 1024);
        } else {
            mediaVideoViewSize.screenWidth = this.mContext.getResources().getDisplayMetrics().widthPixels;
            mediaVideoViewSize.videoHeight = (int)((float)mediaVideoViewSize.screenWidth / this.widthHeightRatio);
            if (this.widthHeightRatio >= 1.0f) {
                ((ReplayVideoComponentContract.IView)this.mView).fixedVideoLayout(mediaVideoViewSize, true);
            } else {
                mediaVideoViewSize.videoHeight = this.mContext.getResources().getDisplayMetrics().heightPixels;
                mediaVideoViewSize.screenWidth = this.mContext.getResources().getDisplayMetrics().widthPixels;
                ((ReplayVideoComponentContract.IView)this.mView).fixedVideoLayout(mediaVideoViewSize, false);
            }
            this.mContext.getWindow().clearFlags(1024);
        }
        ((ReplayVideoComponentContract.IView)this.mView).setRootViewBackgroundResource();
        RxBus.getDefault().post((Object)new IMobileLiveReplayClient_onReplayVideoSize_EventArgs(mediaVideoViewSize));
    }

    public void onPause() {
        if (this.mSmallVideoPlayer != null) {
            this.mSmallVideoPlayer.pausePlayer(this.mSmallVideoPlayer.isUserPause());
        }
    }

    public void onResume() {
        ((IMobileLiveReplayCore)ICoreManagerBase.getCore(IMobileLiveReplayCore.class)).checkReplayData(this.mCurrentReplayUrlInfo.programId, this.mCurrentReplayUrlInfo.cid, this.mCurrentReplayUrlInfo.sid, this.mCurrentReplayUrlInfo.absoluteStartTime, this.mCurrentReplayUrlInfo.replayProtocolType, this.mCurrentReplayUrlInfo.viewCount);
        if (this.mSmallVideoPlayer != null && !this.mSmallVideoPlayer.isUserPause()) {
            this.mSmallVideoPlayer.resumePlayer();
        }
        if (this.mSmallVideoPlayer != null) {
            this.mSmallVideoPlayer.vodMuteLiveAudio(true);
        }
    }

    public void onStop() {
        if (this.mSmallVideoPlayer != null && this.mSmallVideoPlayer.getTime() > 0L) {
            this.stopPlayTime = this.mSmallVideoPlayer.getTime();
        }
    }

    public void onDestory() {
        try {
            if (this.mSmallVideoPlayer != null) {
                this.mSmallVideoPlayer.onDestroy();
            }
        }
        catch (Throwable ex) {
            MLog.error((Object)TAG, (Throwable)ex);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putParcelableArrayList(PARAM_VIDEO_URL, (ArrayList)this.mReplayUrlList);
        outState.putString(PARAM_PROGAME_ID, this.mCurrentReplayUrlInfo.programId);
        outState.putString(PARAM_IMG_URL, this.mCurrentReplayUrlInfo.loadingBackgroundImgUrl);
    }

    public void onVideoLoadStart() {
        ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).replayPlayOrPause(false);
        if (this.mView != null) {
            ((ReplayVideoComponentContract.IView)this.mView).setVisibility(R.id.loading_container, 0);
        }
    }

    public void onVideoLoadFinished() {
        if (this.mView != null) {
            ((ReplayVideoComponentContract.IView)this.mView).setVisibility(R.id.loading_container, 8);
        }
    }

    public void onVideoPlayerPosition(int left, int top, int right, int bottom) {
    }

    public long getLegth() {
        if (this.mSmallVideoPlayer != null) {
            return this.mSmallVideoPlayer.getLength();
        }
        return 0L;
    }

    public void onVideoPlayStart() {
        ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).setReplayTotalTime(this.getLegth() / 1000L);
        if (this.stopPlayTime > 0L) {
            if (this.mSmallVideoPlayer != null) {
                this.mSmallVideoPlayer.seekTo(this.stopPlayTime);
            }
            MLog.info((Object)TAG, (String)"YYPlayer setTime  time=%d ", (Object[])new Object[]{this.stopPlayTime});
            this.stopPlayTime = 0L;
        }
        ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).replayPlayOrPause(true);
        RxBus.getDefault().post((Object)new IMobileLiveReplayClient_onReplayPlaying_EventArgs((int)this.getLegth()));
    }

    public void onTotalTime(int totalLength) {
    }

    public void onProgressUpdate(int totalLength, int playProgress) {
        this.stopPlayTime = playProgress;
        if (this.mSmallVideoPlayer != null) {
            RxBus.getDefault().post((Object)new IMobileLiveReplayClient_onReplayTimeChanged_EventArgs(this.mCurrentReplayUrlInfo.programId, (int)this.mSmallVideoPlayer.getTime(), this.cacheProgress));
        }
    }

    public void onBuffering() {
    }

    public void onCacheUpdate(int cacheProgress) {
        this.cacheProgress = cacheProgress;
    }

    public void onVideoPlaying() {
        PluginBus.INSTANCE.get().post((Object)new HideLoadingViewEvent());
        MLog.info((Object)TAG, (String)"[onVideoPlayStart] HideLoadingViewEvent", (Object[])new Object[0]);
        ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).replayPlayOrPause(true);
        RxBus.getDefault().post((Object)new IMobileLiveReplayClient_onReplayPlaying_EventArgs((int)this.getLegth()));
    }

    public void onVideoPlayPause() {
        MLog.info((Object)TAG, (String)"[onVideoPlayPause]", (Object[])new Object[0]);
        ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).replayPlayOrPause(false);
        RxBus.getDefault().post((Object)new IMobileLiveReplayClient_onReplayPause_EventArgs());
        if (this.mView != null) {
            ((ReplayVideoComponentContract.IView)this.mView).setVisibility(R.id.loading_container, 8);
        }
    }

    public void onError(int errorCode) {
        ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).replayPlayOrPause(false);
        int retryPlayTimes = 0;
        int retryTime = 0;
        if (this.mSmallVideoPlayer != null) {
            retryPlayTimes = this.mSmallVideoPlayer.mRetryPlayTimes;
            retryTime = this.mSmallVideoPlayer.getRetryTime();
        }
        MLog.info((Object)TAG, (String)("[onError] retryPlayTimes=" + retryPlayTimes + ",retryTime=" + retryTime), (Object[])new Object[0]);
        if (retryPlayTimes >= retryTime) {
            if (errorCode >= 0 && errorCode <= 9) {
                Toast.makeText((Context)this.mContext, (CharSequence)"\u7f51\u7edc\u5f02\u5e38\uff0c\u64ad\u653e\u5931\u8d25!", (int)1).show();
            } else {
                Toast.makeText((Context)this.mContext, (CharSequence)"\u89c6\u9891\u64ad\u653e\u5f02\u5e38!", (int)1).show();
            }
            MLog.info((Object)TAG, (String)"[onError] play error:finish activity", (Object[])new Object[0]);
            this.mContext.finish();
        } else {
            MLog.info((Object)TAG, (String)("[onError] play error: times=" + retryTime), (Object[])new Object[0]);
            if (this.mSmallVideoPlayer != null) {
                this.mSmallVideoPlayer.resumePlayer();
            }
        }
    }

    public void onRepeatlyPlayVideo(long resId) {
    }

    public void onPlayEnd() {
        this.stopPlayTime = 0L;
        RxBus.getDefault().post((Object)new IMobileLiveReplayClient_onReplayNormalEnd_EventArgs());
        if (this.mReplayUrlInfos != null && this.currentReplayUrlIndex < this.mReplayUrlInfos.size()) {
            this.mCurrentReplayUrlInfo = this.mReplayUrlInfos.get(this.currentReplayUrlIndex++);
            if (this.mCurrentReplayUrlInfo != null) {
                if (this.mCurrentReplayUrlInfo.isVRPlay) {
                    ((ReplayVideoComponentContract.IView)this.mView).updateVideoAreaClickListener();
                }
                PluginBus.INSTANCE.get().post((Object)new ReplayVideoFragment_UpdateEventArgs());
                if (this.mCurrentReplayUrlInfo != null && this.mCurrentReplayUrlInfo.cid > 0L && this.mCurrentReplayUrlInfo.sid > 0L && this.mCurrentReplayUrlInfo.absoluteStartTime > 0L) {
                    ((IMobileLiveReplayCore)ICoreManagerBase.getCore(IMobileLiveReplayCore.class)).initReplayData(this.mCurrentReplayUrlInfo.programId, this.mCurrentReplayUrlInfo.cid, this.mCurrentReplayUrlInfo.sid, this.mCurrentReplayUrlInfo.absoluteStartTime, this.mCurrentReplayUrlInfo.replayProtocolType, this.mCurrentReplayUrlInfo.viewCount);
                } else {
                    ((IMobileLiveReplayCore)ICoreManagerBase.getCore(IMobileLiveReplayCore.class)).initReplayData(this.mCurrentReplayUrlInfo.programId, 0L, 0L, 0L, 0, -1L);
                }
                if (this.mCurrentReplayUrlInfo != null && !FP.empty((CharSequence)this.mCurrentReplayUrlInfo.mPlayUrl) && !FP.empty((CharSequence)this.mCurrentReplayUrlInfo.programId)) {
                    if (this.mSmallVideoPlayer != null) {
                        this.mSmallVideoPlayer.stopPlayer();
                    }
                    ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).cleanAllReplayInfo(this.mCurrentReplayUrlInfo.programId);
                    try {
                        ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).initLastTime();
                        this.stopPlayTime = 0L;
                    }
                    catch (Throwable ex) {
                        MLog.error((Object)TAG, (Throwable)ex);
                    }
                    if (this.mSmallVideoPlayer != null && this.mCurrentReplayUrlInfo != null) {
                        this.mSmallVideoPlayer.play((PlayerPlayInfo)this.mCurrentReplayUrlInfo);
                    }
                    MLog.info((Object)TAG, (String)("[onPlayEnd] playNext PlayInfo=" + (Object)((Object)this.mCurrentReplayUrlInfo)), (Object[])new Object[0]);
                }
            } else {
                MLog.info((Object)TAG, (String)"mCurrentReplayUrlInfo == null", (Object[])new Object[0]);
            }
            MLog.info((Object)TAG, (String)("[onPlayEnd] getNext PlayInfo=" + (Object)((Object)this.mCurrentReplayUrlInfo)), (Object[])new Object[0]);
        } else if (this.mContext.getIntent().hasExtra("data_replay_uid")) {
            ReplayLeaveInfo replayLeaveInfo = new ReplayLeaveInfo().setmAnchorUid(this.mContext.getIntent().getLongExtra("data_replay_uid", 0L)).setmProgamId(this.mCurrentReplayUrlInfo.programId).setmPlayUrl(this.mCurrentReplayUrlInfo.mPlayUrl).setmMobileLiveTitle(((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).getCurrentMobileLiveInfo().title).setmReplayTypeFrom(0).setmBgImgUrl(this.mCurrentReplayUrlInfo.loadingBackgroundImgUrl);
            AbsChannelControllerCore iCoreManagerBase = (AbsChannelControllerCore)ICoreManagerBase.getCore(AbsChannelControllerCore.class);
            if (iCoreManagerBase == null || !iCoreManagerBase.isInterceptToMobileLiveReplayLeaveActivity((Activity)this.mContext, (Parcelable)replayLeaveInfo)) {
                LiveNavigationUtils.toMobileLiveReplayLeaveActivity((Context)this.mContext, replayLeaveInfo);
            }
            this.mContext.finish();
        }
        ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).replayPlayOrPause(false);
        MLog.info((Object)TAG, (String)("[onPlayEnd] mCurrentReplayUrlInfo=" + (Object)((Object)this.mCurrentReplayUrlInfo)), (Object[])new Object[0]);
    }

    public void onPlayVideoSize(float width, float height) {
        this.mCurrentReplayUrlInfo.mCurrentHeightWidthRatio = this.widthHeightRatio = width / height;
        if (this.mView != null) {
            this.setOrientationMode(((ReplayVideoComponentContract.IView)this.mView).isLandScape());
        }
    }

    public void onVideoPlayStop() {
        MLog.info((Object)TAG, (String)"[onVideoPlayStop]", (Object[])new Object[0]);
        ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).replayPlayOrPause(false);
    }
}

