/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basefunction.followguide;

import com.duowan.mobile.main.kinds.Kinds;
import com.yy.abtest.guide.NewDeviceLoginGuideABTest;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.main.events.IAuthClient_onLoginSucceed_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.PluginBus;
import com.yy.mobile.ui.basefunction.followguide.LiveLoginGuideHandler$$EventBinder;
import com.yy.mobile.ui.basefunction.followguide.LoginFollowGuideManager;
import com.yy.mobile.ui.basefunction.followguide.ShowLiveLoginGuideEventArgs;
import com.yy.mobile.ui.basefunction.followguide.ShowLoginGuideFlowerEventArgs;
import com.yy.mobile.ui.utils.DateUtils;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class LiveLoginGuideHandler
implements EventCompat {
    private static final String TAG = "LiveLoginGuideHandler";
    public static final String LOGIN_GUIDE_LAST_SHOW_DATE = "LOGIN_GUIDE_LAST_SHOW_DATE";
    public static final String LOGIN_GUIDE_CLICK_LOGINED_DONE = "LOGIN_GUIDE_CLICK_LOGINED_DONE";
    private static final int LIVE_LOGIN_GUIDE_SHOW_DELAY_TIME = 7;
    private static final int LIVE_LOGIN_GUIDE_SHOW_TIME = 15;
    private Disposable mDelayShowTimmer;
    private Disposable mGuideCountDownTimmer;
    private int mGuideCountDown;
    private int mGuideShowState = 0;
    private boolean hasClickedGuideToLogin = false;
    private EventBinder mLiveLoginGuideHandlerSniperEventBinder;

    public void onEventBind() {
        if (this.mLiveLoginGuideHandlerSniperEventBinder == null) {
            this.mLiveLoginGuideHandlerSniperEventBinder = new LiveLoginGuideHandler$$EventBinder();
        }
        this.mLiveLoginGuideHandlerSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mLiveLoginGuideHandlerSniperEventBinder != null) {
            this.mLiveLoginGuideHandlerSniperEventBinder.unBindEvent();
        }
    }

    public void init() {
        this.onEventBind();
    }

    public void release() {
        this.onEventUnBind();
    }

    public void sceneInitDone() {
        boolean sceneMatched = LoginFollowGuideManager.instance().isAbleToShowFollowGuide();
        String value = ((NewDeviceLoginGuideABTest)Kinds.of(NewDeviceLoginGuideABTest.class)).getShowLoginGuideType();
        boolean logined = LoginUtil.isLogined();
        String lastClickDate = CommonPref.instance().getString(LOGIN_GUIDE_LAST_SHOW_DATE);
        String today = DateUtils.dateToString((Date)new Date(), (String)"yyyy-MM-dd");
        boolean todayClicked = StringUtils.equal((String)lastClickDate, (String)today);
        boolean clickLoginDone = CommonPref.instance().getBoolean(LOGIN_GUIDE_CLICK_LOGINED_DONE, false);
        MLog.info((Object)TAG, (String)"sceneInitDone: sceneMatched=%s, abTestValue=%s, logined=%s, todayClicked=%s, clickLoginDone=%s", (Object[])new Object[]{sceneMatched, value, logined, todayClicked, clickLoginDone});
        if (sceneMatched && StringUtils.safeParseInt((String)value) == 1 && !logined && !todayClicked && !clickLoginDone) {
            this.startDelayShowTimmer();
            this.mGuideShowState = 1;
        }
    }

    private void startDelayShowTimmer() {
        if (this.mDelayShowTimmer == null || this.mDelayShowTimmer.isDisposed()) {
            this.mDelayShowTimmer = Observable.timer((long)7L, (TimeUnit)TimeUnit.SECONDS).subscribe((Consumer)new Consumer<Long>(){

                public void accept(Long aLong) throws Exception {
                    if (LiveLoginGuideHandler.this.mGuideShowState == 1) {
                        LiveLoginGuideHandler.this.showLiveLoginGuideView();
                        LiveLoginGuideHandler.this.startGuideCountDownTimmer();
                        LiveLoginGuideHandler.this.resetDelayShowTimmer();
                    }
                }
            }, RxUtils.errorConsumer((String)TAG, (String)"startDelayShowTimmer: error"));
        }
    }

    private void startGuideCountDownTimmer() {
        if (this.mGuideCountDownTimmer == null || this.mGuideCountDownTimmer.isDisposed()) {
            this.mGuideCountDown = 15;
            this.mGuideCountDownTimmer = Observable.interval((long)1L, (TimeUnit)TimeUnit.SECONDS).subscribe((Consumer)new Consumer<Long>(){

                public void accept(Long aLong) throws Exception {
                    MLog.debug((Object)LiveLoginGuideHandler.TAG, (String)("startGuideCountDownTimmer: mGuideCountDown=" + LiveLoginGuideHandler.this.mGuideCountDown), (Object[])new Object[0]);
                    if (LiveLoginGuideHandler.this.mGuideCountDown > 0) {
                        LiveLoginGuideHandler.this.mGuideCountDown--;
                    } else {
                        LiveLoginGuideHandler.this.mGuideShowState = 3;
                        LiveLoginGuideHandler.this.hideLiveLoginGuideView();
                        LiveLoginGuideHandler.this.resetGuideCountDownTimmer();
                    }
                }
            }, RxUtils.errorConsumer((String)TAG, (String)"startGuideCountDownTimmer: error"));
        }
    }

    public void updateFollowGuideShownState(boolean isShown) {
        MLog.debug((Object)TAG, (String)"updateFollowGuideShownState: isShown=%s, mGuideShowState=%s", (Object[])new Object[]{isShown, this.mGuideShowState});
        if (this.mGuideCountDown > 0 && isShown) {
            this.mGuideCountDown = 2;
        }
    }

    public void navToLoginFromGuide() {
        String today = DateUtils.dateToString((Date)new Date(), (String)"yyyy-MM-dd");
        MLog.info((Object)TAG, (String)("navToLoginFromGuide: " + today), (Object[])new Object[0]);
        this.mGuideShowState = 3;
        this.hasClickedGuideToLogin = true;
        this.resetGuideCountDownTimmer();
    }

    private void showLiveLoginGuideView() {
        PluginBus.INSTANCE.get().post((Object)new ShowLiveLoginGuideEventArgs(true));
    }

    private void hideLiveLoginGuideView() {
        PluginBus.INSTANCE.get().post((Object)new ShowLiveLoginGuideEventArgs(false));
    }

    private void resetDelayShowTimmer() {
        if (this.mDelayShowTimmer != null && !this.mDelayShowTimmer.isDisposed()) {
            this.mDelayShowTimmer.dispose();
        }
        this.mDelayShowTimmer = null;
    }

    private void resetGuideCountDownTimmer() {
        if (this.mGuideCountDownTimmer != null && !this.mGuideCountDownTimmer.isDisposed()) {
            this.mGuideCountDownTimmer.dispose();
        }
        this.mGuideCountDownTimmer = null;
        this.mGuideCountDown = 0;
    }

    @BusEvent(sync=true)
    public void onLoginSucceed(IAuthClient_onLoginSucceed_EventArgs busEventArgs) {
        MLog.debug((Object)TAG, (String)"onLoginSucceed:", (Object[])new Object[0]);
        this.hideLiveLoginGuideView();
        this.resetDelayShowTimmer();
        this.resetGuideCountDownTimmer();
        this.mGuideShowState = 3;
    }

    public void checkShowLoginFlower() {
        boolean logined = LoginUtil.isLogined();
        MLog.info((Object)TAG, (String)"checkShowLoginFlower: logined=%s, hasClickedGuideToLogin=%s", (Object[])new Object[]{logined, this.hasClickedGuideToLogin});
        if (logined && this.hasClickedGuideToLogin) {
            CommonPref.instance().putBoolean(LOGIN_GUIDE_CLICK_LOGINED_DONE, true);
            PluginBus.INSTANCE.get().post((Object)new ShowLoginGuideFlowerEventArgs());
            this.hasClickedGuideToLogin = false;
        }
    }

    @BusEvent(sync=true)
    public void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs busEventArgs) {
        MLog.debug((Object)TAG, (String)"onJoinChannelSuccess:", (Object[])new Object[0]);
        this.sceneInitDone();
    }

    @BusEvent(sync=true)
    public void leaveCurrentChannel(IChannelLinkClient_leaveCurrentChannel_EventArgs busEventArgs) {
        this.hideLiveLoginGuideView();
        this.resetDelayShowTimmer();
        this.resetGuideCountDownTimmer();
        this.mGuideShowState = 0;
    }
}

