/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.helper;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.log.MLog;

public class DialogFactory {
    private static final String TAG = "DialogFactory";
    private Dialog mDialog;
    private Context mContext;
    private AlertDialog.Builder mBuilder;
    private Handler mHandler;

    public DialogFactory(Context context) {
        this.mContext = context;
        this.mBuilder = new AlertDialog.Builder(context);
        this.mDialog = this.mBuilder.create();
        this.mHandler = new SafeDispatchHandler(Looper.getMainLooper());
    }

    public void showOkCancelDialog(CharSequence message, CharSequence okLabel, CharSequence cancelLabel, boolean cancelable, final OkCancelDialogListener l) {
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)"showOkCancelDialog ActivityInvalid....", (Object[])new Object[0]);
            return;
        }
        if (this.mDialog == null) {
            this.mDialog = this.mBuilder.create();
        }
        this.mDialog.setCancelable(cancelable);
        this.mDialog.setCanceledOnTouchOutside(cancelable);
        this.mDialog.show();
        Window window = this.mDialog.getWindow();
        window.setContentView(R.layout.dialog_layout_ok_cancel_dialog);
        TextView tip = (TextView)window.findViewById(R.id.message);
        tip.setText(message);
        TextView ok = (TextView)window.findViewById(R.id.btn_ok);
        ok.setText(okLabel);
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DialogFactory.this.mDialog.dismiss();
                if (l != null) {
                    l.onOk();
                }
            }
        });
        TextView cancel = (TextView)window.findViewById(R.id.btn_cancel);
        cancel.setText(cancelLabel);
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DialogFactory.this.mDialog.dismiss();
                if (l != null) {
                    l.onCancel();
                }
            }
        });
    }

    public void showOnlyOkDialog(CharSequence message, CharSequence okLabel, final OkDialogListener l) {
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)"showOkDialog ActivityInvalid....", (Object[])new Object[0]);
            return;
        }
        if (this.mDialog == null) {
            this.mDialog = this.mBuilder.create();
        }
        this.mDialog.show();
        Window window = this.mDialog.getWindow();
        window.setContentView(R.layout.dialog_layout__onlyok_dialog);
        TextView tip = (TextView)window.findViewById(R.id.message);
        tip.setText(message);
        TextView ok = (TextView)window.findViewById(R.id.btn_ok);
        ok.setText(okLabel);
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DialogFactory.this.mDialog.dismiss();
                if (l != null) {
                    l.onOk();
                }
            }
        });
    }

    public void showOnlyOkDialog(CharSequence message, CharSequence okLabel, boolean cancelable, final OkDialogListener l) {
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)"showOkDialog ActivityInvalid....", (Object[])new Object[0]);
            return;
        }
        if (this.mDialog == null) {
            this.mDialog = this.mBuilder.create();
        }
        this.mDialog.setCancelable(cancelable);
        this.mDialog.setCanceledOnTouchOutside(cancelable);
        this.mDialog.show();
        Window window = this.mDialog.getWindow();
        window.setContentView(R.layout.dialog_layout__onlyok_dialog);
        TextView tip = (TextView)window.findViewById(R.id.message);
        tip.setMovementMethod(LinkMovementMethod.getInstance());
        tip.setText(message);
        TextView ok = (TextView)window.findViewById(R.id.btn_ok);
        ok.setText(okLabel);
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DialogFactory.this.mDialog.dismiss();
                if (l != null) {
                    l.onOk();
                }
            }
        });
    }

    @TargetApi(value=17)
    public boolean checkActivityValid() {
        if (this.mContext == null) {
            MLog.warn((Object)TAG, (String)("Fragment " + this + " not attached to Activity"), (Object[])new Object[0]);
            return false;
        }
        if (this.mDialog != null && this.mDialog.getWindow() == null) {
            MLog.warn((Object)TAG, (String)"window null", (Object[])new Object[0]);
            return false;
        }
        if (((Activity)this.mContext).isFinishing()) {
            MLog.warn((Object)TAG, (String)"activity is finishing", (Object[])new Object[0]);
            return false;
        }
        if (Build.VERSION.SDK_INT >= 17 && ((Activity)this.mContext).isDestroyed()) {
            MLog.warn((Object)TAG, (String)"activity is isDestroyed", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    public boolean isDialogShowing() {
        if (this.mDialog != null) {
            return this.mDialog.isShowing();
        }
        return false;
    }

    public void dismissDialog() {
        if (this.mContext != null && this.mDialog != null && this.mDialog.getWindow() != null) {
            if (this.mContext instanceof Activity) {
                Activity activity = (Activity)this.mContext;
                if (!activity.isFinishing()) {
                    this.mDialog.dismiss();
                }
                this.mHandler.removeCallbacksAndMessages(null);
            } else {
                this.mDialog.dismiss();
            }
            this.mHandler.removeCallbacksAndMessages(null);
        }
    }

    public static interface OkDialogListener {
        public void onOk();
    }

    public static interface OkCancelDialogListener {
        public void onCancel();

        public void onOk();
    }
}

